/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network;

import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import sun.misc.Unsafe;

final class NetworkBufferUnsafe {
    static final Unsafe UNSAFE;
    static final Field ADDRESS;
    static final Field CAPACITY;
    static final long ADDRESS_OFFSET;
    static final long CAPACITY_OFFSET;
    static final long BYTE_ARRAY_OFFSET;

    NetworkBufferUnsafe() {
    }

    static void updateAddress(ByteBuffer buffer, long address) {
        UNSAFE.putLong(buffer, ADDRESS_OFFSET, address);
    }

    static void updateCapacity(ByteBuffer buffer, int capacity) {
        UNSAFE.putInt(buffer, CAPACITY_OFFSET, capacity);
    }

    static {
        try {
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            UNSAFE = (Unsafe)theUnsafe.get(null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            ADDRESS = Buffer.class.getDeclaredField("address");
            CAPACITY = Buffer.class.getDeclaredField("capacity");
            ADDRESS_OFFSET = UNSAFE.objectFieldOffset(ADDRESS);
            CAPACITY_OFFSET = UNSAFE.objectFieldOffset(CAPACITY);
        }
        catch (NoSuchFieldException e) {
            throw new AssertionError((Object)e);
        }
        BYTE_ARRAY_OFFSET = UNSAFE.arrayBaseOffset(byte[].class);
    }
}

