/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.extras.lan;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import net.minestom.server.MinecraftServer;
import net.minestom.server.event.EventDispatcher;
import net.minestom.server.event.server.ServerListPingEvent;
import net.minestom.server.extras.lan.OpenToLANConfig;
import net.minestom.server.ping.ServerListPingType;
import net.minestom.server.timer.Task;
import net.minestom.server.utils.time.Cooldown;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenToLAN {
    private static final InetSocketAddress PING_ADDRESS = new InetSocketAddress("224.0.2.60", 4445);
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenToLAN.class);
    private static volatile Cooldown eventCooldown;
    private static volatile DatagramSocket socket;
    private static volatile DatagramPacket packet;
    private static volatile Task task;

    private OpenToLAN() {
    }

    public static boolean open() {
        return OpenToLAN.open(new OpenToLANConfig());
    }

    public static boolean open(@NotNull OpenToLANConfig config) {
        Objects.requireNonNull(config, "config");
        if (socket != null) {
            return false;
        }
        try {
            socket = new DatagramSocket(config.port);
        }
        catch (SocketException e) {
            LOGGER.warn("Could not bind to the port!", (Throwable)e);
            return false;
        }
        eventCooldown = new Cooldown(config.delayBetweenEvent);
        task = MinecraftServer.getSchedulerManager().buildTask(OpenToLAN::ping).repeat(config.delayBetweenPings).schedule();
        return true;
    }

    public static boolean close() {
        if (socket == null) {
            return false;
        }
        task.cancel();
        socket.close();
        task = null;
        socket = null;
        return true;
    }

    public static boolean isOpen() {
        return socket != null;
    }

    private static void ping() {
        if (!MinecraftServer.getServer().isOpen()) {
            return;
        }
        if (packet == null || eventCooldown.isReady(System.nanoTime())) {
            ServerListPingEvent event = new ServerListPingEvent(ServerListPingType.OPEN_TO_LAN);
            EventDispatcher.call(event);
            byte[] data = ServerListPingType.OPEN_TO_LAN.getPingResponse(event.getResponseData()).getBytes(StandardCharsets.UTF_8);
            packet = new DatagramPacket(data, data.length, PING_ADDRESS);
            eventCooldown.refreshLastUpdate(System.nanoTime());
        }
        try {
            socket.send(packet);
        }
        catch (IOException e) {
            LOGGER.warn("Could not send Open to LAN packet!", (Throwable)e);
        }
    }

    static {
        socket = null;
        packet = null;
        task = null;
    }
}

