/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.kyori.adventure.key.Key;
import net.minestom.server.codec.Codec;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.StaticProtocolObject;
import org.jetbrains.annotations.NotNull;

public enum VillagerType implements StaticProtocolObject<VillagerType>
{
    DESERT(Key.key((String)"desert")),
    JUNGLE(Key.key((String)"jungle")),
    PLAINS(Key.key((String)"plains")),
    SAVANNA(Key.key((String)"savanna")),
    SNOW(Key.key((String)"snow")),
    SWAMP(Key.key((String)"swamp")),
    TAIGA(Key.key((String)"taiga"));

    private static final Map<Key, VillagerType> BY_KEY;
    public static final NetworkBuffer.Type<VillagerType> NETWORK_TYPE;
    public static final Codec<VillagerType> CODEC;
    private final Key key;

    private VillagerType(Key key) {
        this.key = key;
    }

    @Override
    @NotNull
    public Key key() {
        return this.key;
    }

    @Override
    public int id() {
        return this.ordinal();
    }

    static {
        BY_KEY = Arrays.stream(VillagerType.values()).collect(Collectors.toMap(VillagerType::key, Function.identity()));
        NETWORK_TYPE = NetworkBuffer.Enum(VillagerType.class);
        CODEC = Codec.KEY.transform(BY_KEY::get, VillagerType::key);
    }
}

