/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.component;

import java.util.Collection;
import net.kyori.adventure.key.Key;
import net.minestom.server.codec.Codec;
import net.minestom.server.component.DataComponentImpl;
import net.minestom.server.component.DataComponentMap;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.StaticProtocolObject;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface DataComponent<T>
extends StaticProtocolObject<DataComponent<T>>,
Codec<T>
permits DataComponentImpl {
    @NotNull
    public static final NetworkBuffer.Type<DataComponent<?>> NETWORK_TYPE = NetworkBuffer.VAR_INT.transform(DataComponent::fromId, StaticProtocolObject::id);
    @NotNull
    public static final Codec<DataComponent<?>> CODEC = Codec.STRING.transform(DataComponent::fromKey, StaticProtocolObject::name);
    @NotNull
    public static final NetworkBuffer.Type<DataComponentMap> MAP_NETWORK_TYPE = DataComponentMap.networkType(DataComponent::fromId);
    @NotNull
    public static final Codec<DataComponentMap> MAP_NBT_TYPE = DataComponentMap.codec(DataComponent::fromId, DataComponent::fromKey);
    @NotNull
    public static final NetworkBuffer.Type<DataComponentMap> PATCH_NETWORK_TYPE = DataComponentMap.patchNetworkType(DataComponent::fromId, true);
    @NotNull
    public static final NetworkBuffer.Type<DataComponentMap> UNTRUSTED_PATCH_NETWORK_TYPE = DataComponentMap.patchNetworkType(DataComponent::fromId, false);
    @NotNull
    public static final Codec<DataComponentMap> PATCH_CODEC = DataComponentMap.patchCodec(DataComponent::fromId, DataComponent::fromKey);

    public boolean isSynced();

    public boolean isSerialized();

    @NotNull
    public T read(@NotNull NetworkBuffer var1);

    public void write(@NotNull NetworkBuffer var1, @NotNull T var2);

    @Nullable
    public static DataComponent<?> fromKey(@NotNull String key) {
        return DataComponentImpl.NAMESPACES.get(key);
    }

    @Nullable
    public static DataComponent<?> fromKey(@NotNull Key key) {
        return DataComponent.fromKey(key.asString());
    }

    @Nullable
    public static DataComponent<?> fromId(int id) {
        return DataComponentImpl.IDS.get(id);
    }

    @NotNull
    public static Collection<DataComponent<?>> values() {
        return DataComponentImpl.NAMESPACES.values();
    }

    @ApiStatus.Internal
    public static <T> DataComponent<T> createHeadless(int id, @NotNull Key key, @Nullable NetworkBuffer.Type<T> network, @Nullable Codec<T> codec) {
        return new DataComponentImpl<T>(id, key, network, codec);
    }

    public record Value(@NotNull DataComponent<?> component, @Nullable Object value) {
    }

    public static interface Holder {
        default public boolean has(@NotNull DataComponent<?> component) {
            return this.get(component) != null;
        }

        @Nullable
        public <T> T get(@NotNull DataComponent<T> var1);

        @NotNull
        default public <T> T get(@NotNull DataComponent<T> component, @NotNull T defaultValue) {
            T value = this.get(component);
            return value != null ? value : defaultValue;
        }
    }
}

