/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.collision;

import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import net.minestom.server.collision.BlockCollision;
import net.minestom.server.collision.BoundingBox;
import net.minestom.server.collision.EntityCollision;
import net.minestom.server.collision.EntityCollisionResult;
import net.minestom.server.collision.PhysicsResult;
import net.minestom.server.collision.Shape;
import net.minestom.server.collision.ShapeImpl;
import net.minestom.server.collision.SweepResult;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Pos;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.entity.Entity;
import net.minestom.server.instance.Chunk;
import net.minestom.server.instance.Instance;
import net.minestom.server.instance.WorldBorder;
import net.minestom.server.instance.block.Block;
import net.minestom.server.utils.chunk.ChunkCache;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class CollisionUtils {
    public static PhysicsResult handlePhysics(@NotNull Entity entity, @NotNull Vec entityVelocity, @Nullable PhysicsResult lastPhysicsResult, boolean singleCollision) {
        Instance instance = entity.getInstance();
        assert (instance != null);
        return CollisionUtils.handlePhysics(instance, entity.getChunk(), entity.getBoundingBox(), entity.getPosition(), entityVelocity, lastPhysicsResult, singleCollision);
    }

    @NotNull
    public static Collection<EntityCollisionResult> checkEntityCollisions(@NotNull Instance instance, @NotNull BoundingBox boundingBox, @NotNull Point pos, @NotNull Vec velocity, double extendRadius, @NotNull Function<Entity, Boolean> entityFilter, @Nullable PhysicsResult physicsResult) {
        return EntityCollision.checkCollision(instance, boundingBox, pos, velocity, extendRadius, entityFilter, physicsResult);
    }

    @NotNull
    public static Collection<EntityCollisionResult> checkEntityCollisions(@NotNull Entity entity, @NotNull Vec velocity, double extendRadius, @NotNull Function<Entity, Boolean> entityFilter, @Nullable PhysicsResult physicsResult) {
        return EntityCollision.checkCollision(entity.getInstance(), entity.getBoundingBox(), entity.getPosition(), velocity, extendRadius, entityFilter, physicsResult);
    }

    public static PhysicsResult handlePhysics(@NotNull Entity entity, @NotNull Vec entityVelocity, @Nullable PhysicsResult lastPhysicsResult) {
        Instance instance = entity.getInstance();
        assert (instance != null);
        return CollisionUtils.handlePhysics(instance, entity.getChunk(), entity.getBoundingBox(), entity.getPosition(), entityVelocity, lastPhysicsResult, false);
    }

    public static PhysicsResult handlePhysics(@NotNull Instance instance, @Nullable Chunk chunk, @NotNull BoundingBox boundingBox, @NotNull Pos position, @NotNull Vec velocity, @Nullable PhysicsResult lastPhysicsResult, boolean singleCollision) {
        ChunkCache getter = new ChunkCache(instance, chunk != null ? chunk : instance.getChunkAt(position), Block.STONE);
        return CollisionUtils.handlePhysics(getter, boundingBox, position, velocity, lastPhysicsResult, singleCollision);
    }

    @ApiStatus.Internal
    public static PhysicsResult handlePhysics(@NotNull Block.Getter blockGetter, @NotNull BoundingBox boundingBox, @NotNull Pos position, @NotNull Vec velocity, @Nullable PhysicsResult lastPhysicsResult, boolean singleCollision) {
        return BlockCollision.handlePhysics(boundingBox, velocity, position, blockGetter, lastPhysicsResult, singleCollision);
    }

    public static boolean isLineOfSightReachingShape(@NotNull Instance instance, @Nullable Chunk chunk, @NotNull Point start, @NotNull Point end, @NotNull Shape shape) {
        PhysicsResult result = CollisionUtils.handlePhysics(instance, chunk, BoundingBox.ZERO, Pos.fromPoint(start), Vec.fromPoint(end.sub(start)), null, false);
        return shape.intersectBox(end.sub(result.newPosition()).sub(1.0E-6), BoundingBox.ZERO);
    }

    public static PhysicsResult handlePhysics(@NotNull Entity entity, @NotNull Vec entityVelocity) {
        return CollisionUtils.handlePhysics(entity, entityVelocity, null);
    }

    public static Entity canPlaceBlockAt(Instance instance, Point blockPos, Block b) {
        return BlockCollision.canPlaceBlockAt(instance, blockPos, b);
    }

    @NotNull
    public static Pos applyWorldBorder(@NotNull WorldBorder worldBorder, @NotNull Pos currentPosition, @NotNull Pos newPosition) {
        boolean zCollision;
        double radius = worldBorder.diameter() / 2.0;
        boolean xCollision = newPosition.x() > worldBorder.centerX() + radius || newPosition.x() < worldBorder.centerX() - radius;
        boolean bl = zCollision = newPosition.z() > worldBorder.centerZ() + radius || newPosition.z() < worldBorder.centerZ() - radius;
        if (xCollision || zCollision) {
            return newPosition.withCoord(xCollision ? currentPosition.x() : newPosition.x(), newPosition.y(), zCollision ? currentPosition.z() : newPosition.z());
        }
        return newPosition;
    }

    public static Shape parseBlockShape(Map<Object, Object> internCache, String collision, String occlusion, boolean occludes, byte lightEmission) {
        record ShapeEntry(String collision, String occlusion, boolean occludes, byte lightEmission) {
        }
        ShapeEntry entry = new ShapeEntry(collision, occlusion, occludes, lightEmission);
        Shape cachedShape = (Shape)internCache.get(entry);
        if (cachedShape != null) {
            return cachedShape;
        }
        ShapeImpl parsedShape = ShapeImpl.parseBlockFromRegistry(collision, occlusion, occludes, lightEmission);
        internCache.put(entry, parsedShape);
        return (Shape)internCache.computeIfAbsent(parsedShape, k -> parsedShape);
    }

    public static PhysicsResult blocklessCollision(@NotNull Pos entityPosition, @NotNull Vec entityVelocity) {
        return new PhysicsResult(entityPosition.add(entityVelocity), entityVelocity, false, false, false, false, entityVelocity, new Point[3], new Shape[3], new Point[3], false, SweepResult.NO_COLLISION);
    }
}

