package net.minestom.server.recipe.display;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.kyori.adventure.key.Key;
import net.minestom.server.codec.Codec;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.StaticProtocolObject;
import org.jetbrains.annotations.NotNull;

/**
 * AUTOGENERATED by GenericEnumGenerator
 */
public enum SlotDisplayType implements StaticProtocolObject<SlotDisplayType> {
    EMPTY(Key.key("empty")),

    ANY_FUEL(Key.key("any_fuel")),

    ITEM(Key.key("item")),

    ITEM_STACK(Key.key("item_stack")),

    TAG(Key.key("tag")),

    SMITHING_TRIM(Key.key("smithing_trim")),

    WITH_REMAINDER(Key.key("with_remainder")),

    COMPOSITE(Key.key("composite"));

    private static final Map<Key, SlotDisplayType> BY_KEY = Arrays.stream(values()).collect(Collectors.toMap(SlotDisplayType::key, Function.identity()));

    public static final NetworkBuffer.Type<SlotDisplayType> NETWORK_TYPE = NetworkBuffer.Enum(SlotDisplayType.class);

    public static final Codec<SlotDisplayType> CODEC = Codec.KEY.transform(BY_KEY::get, SlotDisplayType::key);

    private final Key key;

    SlotDisplayType(@NotNull Key key) {
        this.key = key;
    }

    @NotNull
    @Override
    public Key key() {
        return this.key;
    }

    @Override
    public int id() {
        return this.ordinal();
    }
}
