package net.minestom.server.recipe.display;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.kyori.adventure.key.Key;
import net.minestom.server.codec.Codec;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.StaticProtocolObject;
import org.jetbrains.annotations.NotNull;

/**
 * AUTOGENERATED by GenericEnumGenerator
 */
public enum RecipeDisplayType implements StaticProtocolObject<RecipeDisplayType> {
    CRAFTING_SHAPELESS(Key.key("crafting_shapeless")),

    CRAFTING_SHAPED(Key.key("crafting_shaped")),

    FURNACE(Key.key("furnace")),

    STONECUTTER(Key.key("stonecutter")),

    SMITHING(Key.key("smithing"));

    private static final Map<Key, RecipeDisplayType> BY_KEY = Arrays.stream(values()).collect(Collectors.toMap(RecipeDisplayType::key, Function.identity()));

    public static final NetworkBuffer.Type<RecipeDisplayType> NETWORK_TYPE = NetworkBuffer.Enum(RecipeDisplayType.class);

    public static final Codec<RecipeDisplayType> CODEC = Codec.KEY.transform(BY_KEY::get, RecipeDisplayType::key);

    private final Key key;

    RecipeDisplayType(@NotNull Key key) {
        this.key = key;
    }

    @NotNull
    @Override
    public Key key() {
        return this.key;
    }

    @Override
    public int id() {
        return this.ordinal();
    }
}
