package net.minestom.server.command;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.kyori.adventure.key.Key;
import net.minestom.server.codec.Codec;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.StaticProtocolObject;
import org.jetbrains.annotations.NotNull;

/**
 * AUTOGENERATED by GenericEnumGenerator
 */
public enum ArgumentParserType implements StaticProtocolObject<ArgumentParserType> {
    BOOL(Key.key("brigadier:bool")),

    FLOAT(Key.key("brigadier:float")),

    DOUBLE(Key.key("brigadier:double")),

    INTEGER(Key.key("brigadier:integer")),

    LONG(Key.key("brigadier:long")),

    STRING(Key.key("brigadier:string")),

    ENTITY(Key.key("entity")),

    GAME_PROFILE(Key.key("game_profile")),

    BLOCK_POS(Key.key("block_pos")),

    COLUMN_POS(Key.key("column_pos")),

    VEC3(Key.key("vec3")),

    VEC2(Key.key("vec2")),

    BLOCK_STATE(Key.key("block_state")),

    BLOCK_PREDICATE(Key.key("block_predicate")),

    ITEM_STACK(Key.key("item_stack")),

    ITEM_PREDICATE(Key.key("item_predicate")),

    COLOR(Key.key("color")),

    HEX_COLOR(Key.key("hex_color")),

    COMPONENT(Key.key("component")),

    STYLE(Key.key("style")),

    MESSAGE(Key.key("message")),

    NBT_COMPOUND_TAG(Key.key("nbt_compound_tag")),

    NBT_TAG(Key.key("nbt_tag")),

    NBT_PATH(Key.key("nbt_path")),

    OBJECTIVE(Key.key("objective")),

    OBJECTIVE_CRITERIA(Key.key("objective_criteria")),

    OPERATION(Key.key("operation")),

    PARTICLE(Key.key("particle")),

    ANGLE(Key.key("angle")),

    ROTATION(Key.key("rotation")),

    SCOREBOARD_SLOT(Key.key("scoreboard_slot")),

    SCORE_HOLDER(Key.key("score_holder")),

    SWIZZLE(Key.key("swizzle")),

    TEAM(Key.key("team")),

    ITEM_SLOT(Key.key("item_slot")),

    ITEM_SLOTS(Key.key("item_slots")),

    RESOURCE_LOCATION(Key.key("resource_location")),

    FUNCTION(Key.key("function")),

    ENTITY_ANCHOR(Key.key("entity_anchor")),

    INT_RANGE(Key.key("int_range")),

    FLOAT_RANGE(Key.key("float_range")),

    DIMENSION(Key.key("dimension")),

    GAMEMODE(Key.key("gamemode")),

    TIME(Key.key("time")),

    RESOURCE_OR_TAG(Key.key("resource_or_tag")),

    RESOURCE_OR_TAG_KEY(Key.key("resource_or_tag_key")),

    RESOURCE(Key.key("resource")),

    RESOURCE_KEY(Key.key("resource_key")),

    RESOURCE_SELECTOR(Key.key("resource_selector")),

    TEMPLATE_MIRROR(Key.key("template_mirror")),

    TEMPLATE_ROTATION(Key.key("template_rotation")),

    HEIGHTMAP(Key.key("heightmap")),

    LOOT_TABLE(Key.key("loot_table")),

    LOOT_PREDICATE(Key.key("loot_predicate")),

    LOOT_MODIFIER(Key.key("loot_modifier")),

    DIALOG(Key.key("dialog")),

    UUID(Key.key("uuid"));

    private static final Map<Key, ArgumentParserType> BY_KEY = Arrays.stream(values()).collect(Collectors.toMap(ArgumentParserType::key, Function.identity()));

    public static final NetworkBuffer.Type<ArgumentParserType> NETWORK_TYPE = NetworkBuffer.Enum(ArgumentParserType.class);

    public static final Codec<ArgumentParserType> CODEC = Codec.KEY.transform(BY_KEY::get, ArgumentParserType::key);

    private final Key key;

    ArgumentParserType(@NotNull Key key) {
        this.key = key;
    }

    @NotNull
    @Override
    public Key key() {
        return this.key;
    }

    @Override
    public int id() {
        return this.ordinal();
    }
}
