/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.utils.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.Strictness;
import java.io.Reader;
import org.jetbrains.annotations.NotNull;

public final class JsonUtil {
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().disableJdkUnsafe().setStrictness(Strictness.STRICT).create();

    @NotNull
    public static JsonElement fromJson(@NotNull String json) {
        return (JsonElement)GSON.fromJson(json, JsonElement.class);
    }

    @NotNull
    public static JsonElement fromJson(@NotNull Reader reader) {
        return (JsonElement)GSON.fromJson(reader, JsonElement.class);
    }

    @NotNull
    public static String toJson(@NotNull JsonElement element) {
        return GSON.toJson(element);
    }

    private JsonUtil() {
    }
}

