/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.snapshot;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import net.minestom.server.MinecraftServer;
import net.minestom.server.coordinate.CoordConversion;
import net.minestom.server.coordinate.Pos;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.entity.EntityType;
import net.minestom.server.entity.GameMode;
import net.minestom.server.instance.Section;
import net.minestom.server.instance.block.Block;
import net.minestom.server.registry.RegistryKey;
import net.minestom.server.snapshot.ChunkSnapshot;
import net.minestom.server.snapshot.EntitySnapshot;
import net.minestom.server.snapshot.InstanceSnapshot;
import net.minestom.server.snapshot.PlayerSnapshot;
import net.minestom.server.snapshot.ServerSnapshot;
import net.minestom.server.tag.Tag;
import net.minestom.server.tag.TagReadable;
import net.minestom.server.utils.collection.IntMappedArray;
import net.minestom.server.utils.collection.MappedCollection;
import net.minestom.server.utils.validate.Check;
import net.minestom.server.world.DimensionType;
import net.minestom.server.world.biome.Biome;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

@ApiStatus.Internal
public final class SnapshotImpl {

    public record Player(EntitySnapshot snapshot, String username, GameMode gameMode) implements PlayerSnapshot
    {
        @Override
        @NotNull
        public EntityType type() {
            return this.snapshot.type();
        }

        @Override
        @NotNull
        public UUID uuid() {
            return this.snapshot.uuid();
        }

        @Override
        public int id() {
            return this.snapshot.id();
        }

        @Override
        @NotNull
        public Pos position() {
            return this.snapshot.position();
        }

        @Override
        @NotNull
        public Vec velocity() {
            return this.snapshot.velocity();
        }

        @Override
        @NotNull
        public InstanceSnapshot instance() {
            return this.snapshot.instance();
        }

        @Override
        @NotNull
        public ChunkSnapshot chunk() {
            return this.snapshot.chunk();
        }

        @Override
        @NotNull
        public @NotNull Collection<@NotNull PlayerSnapshot> viewers() {
            return this.snapshot.viewers();
        }

        @Override
        @NotNull
        public @NotNull Collection<@NotNull EntitySnapshot> passengers() {
            return this.snapshot.passengers();
        }

        @Override
        @Nullable
        public EntitySnapshot vehicle() {
            return this.snapshot.vehicle();
        }

        @Override
        public <T> @UnknownNullability T getTag(@NotNull Tag<T> tag) {
            return this.snapshot.getTag(tag);
        }
    }

    public record Entity(EntityType type, UUID uuid, int id, Pos position, Vec velocity, AtomicReference<InstanceSnapshot> instanceRef, int chunkX, int chunkZ, int[] viewersId, int[] passengersId, int vehicleId, TagReadable tagReadable) implements EntitySnapshot
    {
        @Override
        public <T> @UnknownNullability T getTag(@NotNull Tag<T> tag) {
            return this.tagReadable.getTag(tag);
        }

        @Override
        @NotNull
        public InstanceSnapshot instance() {
            return this.instanceRef.getPlain();
        }

        @Override
        @NotNull
        public ChunkSnapshot chunk() {
            return Objects.requireNonNull(this.instance().chunk(this.chunkX, this.chunkZ));
        }

        @Override
        @NotNull
        public @NotNull Collection<@NotNull PlayerSnapshot> viewers() {
            return new IntMappedArray<PlayerSnapshot>(this.viewersId, id -> (PlayerSnapshot)this.instance().server().entity(id));
        }

        @Override
        @NotNull
        public @NotNull Collection<@NotNull EntitySnapshot> passengers() {
            return new IntMappedArray<EntitySnapshot>(this.passengersId, id -> this.instance().server().entity(id));
        }

        @Override
        @Nullable
        public EntitySnapshot vehicle() {
            if (this.vehicleId == -1) {
                return null;
            }
            return this.instance().server().entity(this.vehicleId);
        }
    }

    public record Chunk(int minSection, int chunkX, int chunkZ, Section[] sections, Int2ObjectOpenHashMap<Block> blockEntries, int[] entitiesIds, AtomicReference<InstanceSnapshot> instanceRef, TagReadable tagReadable) implements ChunkSnapshot
    {
        @Override
        public @UnknownNullability Block getBlock(int x, int y, int z, @NotNull Block.Getter.Condition condition) {
            if (condition != Block.Getter.Condition.TYPE) {
                Block entry;
                Block block = entry = !this.blockEntries.isEmpty() ? (Block)this.blockEntries.get(CoordConversion.chunkBlockIndex(x, y, z)) : null;
                if (entry != null || condition == Block.Getter.Condition.CACHED) {
                    return entry;
                }
            }
            Section section = this.sections[CoordConversion.globalToChunk(y) - this.minSection];
            int blockStateId = section.blockPalette().get(CoordConversion.globalToSectionRelative(x), CoordConversion.globalToSectionRelative(y), CoordConversion.globalToSectionRelative(z));
            return Objects.requireNonNullElse(Block.fromStateId(blockStateId), Block.AIR);
        }

        @Override
        @NotNull
        public RegistryKey<Biome> getBiome(int x, int y, int z) {
            Section section = this.sections[CoordConversion.globalToChunk(y) - this.minSection];
            int id = section.biomePalette().get(CoordConversion.globalToSectionRelative(x) / 4, CoordConversion.globalToSectionRelative(y) / 4, CoordConversion.globalToSectionRelative(z) / 4);
            RegistryKey<Biome> key = MinecraftServer.getBiomeRegistry().getKey((Biome)id);
            Check.notNull(key, "Biome with id {0} is not registered", id);
            return key;
        }

        @Override
        public <T> @UnknownNullability T getTag(@NotNull Tag<T> tag) {
            return this.tagReadable.getTag(tag);
        }

        @Override
        @NotNull
        public InstanceSnapshot instance() {
            return this.instanceRef.getPlain();
        }

        @Override
        @NotNull
        public @NotNull Collection<@NotNull EntitySnapshot> entities() {
            return new IntMappedArray<EntitySnapshot>(this.entitiesIds, id -> this.instance().server().entity(id));
        }
    }

    public record Instance(AtomicReference<ServerSnapshot> serverRef, RegistryKey<DimensionType> dimensionType, long worldAge, long time, Map<Long, AtomicReference<ChunkSnapshot>> chunksMap, int[] entitiesIds, TagReadable tagReadable) implements InstanceSnapshot
    {
        @Override
        @Nullable
        public ChunkSnapshot chunk(int chunkX, int chunkZ) {
            AtomicReference<ChunkSnapshot> ref = this.chunksMap.get(CoordConversion.chunkIndex(chunkX, chunkZ));
            return Objects.requireNonNull(ref, "Chunk not found").getPlain();
        }

        @Override
        @NotNull
        public @NotNull Collection<@NotNull ChunkSnapshot> chunks() {
            return MappedCollection.plainReferences(this.chunksMap.values());
        }

        @Override
        @NotNull
        public Collection<EntitySnapshot> entities() {
            return new IntMappedArray<EntitySnapshot>(this.entitiesIds, id -> this.server().entity(id));
        }

        @Override
        @NotNull
        public ServerSnapshot server() {
            return this.serverRef.getPlain();
        }

        @Override
        public <T> @UnknownNullability T getTag(@NotNull Tag<T> tag) {
            return this.tagReadable.getTag(tag);
        }
    }

    public record Server(Collection<InstanceSnapshot> instances, Int2ObjectOpenHashMap<AtomicReference<EntitySnapshot>> entityRefs) implements ServerSnapshot
    {
        @Override
        @NotNull
        public Collection<EntitySnapshot> entities() {
            return MappedCollection.plainReferences(this.entityRefs.values());
        }

        @Override
        public @UnknownNullability EntitySnapshot entity(int id) {
            AtomicReference ref = (AtomicReference)this.entityRefs.get(id);
            return ref != null ? (EntitySnapshot)ref.getPlain() : null;
        }
    }
}

