/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item.enchant;

import java.util.List;
import net.kyori.adventure.key.Key;
import net.minestom.server.codec.Codec;
import net.minestom.server.codec.StructCodec;
import net.minestom.server.gamedata.DataPack;
import net.minestom.server.item.enchant.Enchantment;
import net.minestom.server.item.enchant.LevelBasedValue;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.registry.Registries;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public non-sealed interface ValueEffect
extends Enchantment.Effect {
    @NotNull
    public static final StructCodec<ValueEffect> CODEC = Codec.RegistryTaggedUnion(Registries::enchantmentValueEffects, ValueEffect::codec, "type");

    @ApiStatus.Internal
    @NotNull
    public static DynamicRegistry<StructCodec<? extends ValueEffect>> createDefaultRegistry() {
        DynamicRegistry<StructCodec<? extends ValueEffect>> registry = DynamicRegistry.create(Key.key((String)"minestom:enchantment_value_effect"));
        registry.register("add", Add.CODEC, DataPack.MINECRAFT_CORE);
        registry.register("all_of", AllOf.CODEC, DataPack.MINECRAFT_CORE);
        registry.register("multiply", Multiply.CODEC, DataPack.MINECRAFT_CORE);
        registry.register("remove_binomial", RemoveBinomial.CODEC, DataPack.MINECRAFT_CORE);
        registry.register("set", Set.CODEC, DataPack.MINECRAFT_CORE);
        return registry;
    }

    public float apply(float var1, int var2);

    @NotNull
    public StructCodec<? extends ValueEffect> codec();

    public record Add(@NotNull LevelBasedValue value) implements ValueEffect
    {
        public static final StructCodec<Add> CODEC = StructCodec.struct("value", LevelBasedValue.CODEC, Add::value, Add::new);

        @Override
        public float apply(float base, int level) {
            return base + this.value.calc(level);
        }

        @NotNull
        public StructCodec<Add> codec() {
            return CODEC;
        }
    }

    public record AllOf(@NotNull List<ValueEffect> effects) implements ValueEffect
    {
        public static final StructCodec<AllOf> CODEC = StructCodec.struct("effects", CODEC.list(), AllOf::effects, AllOf::new);

        public AllOf(@NotNull List<ValueEffect> effects) {
            effects = List.copyOf(effects);
        }

        @Override
        public float apply(float base, int level) {
            for (ValueEffect effect : this.effects) {
                base = effect.apply(base, level);
            }
            return base;
        }

        @NotNull
        public StructCodec<AllOf> codec() {
            return CODEC;
        }
    }

    public record Multiply(@NotNull LevelBasedValue factor) implements ValueEffect
    {
        public static final StructCodec<Multiply> CODEC = StructCodec.struct("factor", LevelBasedValue.CODEC, Multiply::factor, Multiply::new);

        @Override
        public float apply(float base, int level) {
            return base * this.factor.calc(level);
        }

        @NotNull
        public StructCodec<Multiply> codec() {
            return CODEC;
        }
    }

    public record RemoveBinomial(@NotNull LevelBasedValue chance) implements ValueEffect
    {
        public static final StructCodec<RemoveBinomial> CODEC = StructCodec.struct("chance", LevelBasedValue.CODEC, RemoveBinomial::chance, RemoveBinomial::new);

        @Override
        public float apply(float base, int level) {
            throw new UnsupportedOperationException("todo");
        }

        @NotNull
        public StructCodec<RemoveBinomial> codec() {
            return CODEC;
        }
    }

    public record Set(@NotNull LevelBasedValue value) implements ValueEffect
    {
        public static final StructCodec<Set> CODEC = StructCodec.struct("value", LevelBasedValue.CODEC, Set::value, Set::new);

        @Override
        public float apply(float base, int level) {
            return this.value.calc(level);
        }

        @NotNull
        public StructCodec<Set> codec() {
            return CODEC;
        }
    }
}

