/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.command;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.kyori.adventure.key.Key;
import net.minestom.server.codec.Codec;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.StaticProtocolObject;
import org.jetbrains.annotations.NotNull;

public enum ArgumentParserType implements StaticProtocolObject<ArgumentParserType>
{
    BOOL("brigadier:bool"),
    FLOAT("brigadier:float"),
    DOUBLE("brigadier:double"),
    INTEGER("brigadier:integer"),
    LONG("brigadier:long"),
    STRING("brigadier:string"),
    ENTITY("entity"),
    GAME_PROFILE("game_profile"),
    BLOCK_POS("block_pos"),
    COLUMN_POS("column_pos"),
    VEC3("vec3"),
    VEC2("vec2"),
    BLOCK_STATE("block_state"),
    BLOCK_PREDICATE("block_predicate"),
    ITEM_STACK("item_stack"),
    ITEM_PREDICATE("item_predicate"),
    COLOR("color"),
    HEX_COLOR("hex_color"),
    COMPONENT("component"),
    STYLE("style"),
    MESSAGE("message"),
    NBT_COMPOUND_TAG("nbt_compound_tag"),
    NBT_TAG("nbt_tag"),
    NBT_PATH("nbt_path"),
    OBJECTIVE("objective"),
    OBJECTIVE_CRITERIA("objective_criteria"),
    OPERATION("operation"),
    PARTICLE("particle"),
    ANGLE("angle"),
    ROTATION("rotation"),
    SCOREBOARD_SLOT("scoreboard_slot"),
    SCORE_HOLDER("score_holder"),
    SWIZZLE("swizzle"),
    TEAM("team"),
    ITEM_SLOT("item_slot"),
    ITEM_SLOTS("item_slots"),
    RESOURCE_LOCATION("resource_location"),
    FUNCTION("function"),
    ENTITY_ANCHOR("entity_anchor"),
    INT_RANGE("int_range"),
    FLOAT_RANGE("float_range"),
    DIMENSION("dimension"),
    GAMEMODE("gamemode"),
    TIME("time"),
    RESOURCE_OR_TAG("resource_or_tag"),
    RESOURCE_OR_TAG_KEY("resource_or_tag_key"),
    RESOURCE("resource"),
    RESOURCE_KEY("resource_key"),
    RESOURCE_SELECTOR("resource_selector"),
    TEMPLATE_MIRROR("template_mirror"),
    TEMPLATE_ROTATION("template_rotation"),
    HEIGHTMAP("heightmap"),
    LOOT_TABLE("loot_table"),
    LOOT_PREDICATE("loot_predicate"),
    LOOT_MODIFIER("loot_modifier"),
    DIALOG("dialog"),
    UUID("uuid");

    private static final Map<Key, ArgumentParserType> BY_KEY;
    public static final NetworkBuffer.Type<ArgumentParserType> NETWORK_TYPE;
    public static final Codec<ArgumentParserType> CODEC;
    private final Key key;

    private ArgumentParserType(String key) {
        this.key = Key.key((String)key);
    }

    @Override
    @NotNull
    public Key key() {
        return this.key;
    }

    @Override
    public int id() {
        return this.ordinal();
    }

    static {
        BY_KEY = Arrays.stream(ArgumentParserType.values()).collect(Collectors.toUnmodifiableMap(ArgumentParserType::key, Function.identity()));
        NETWORK_TYPE = NetworkBuffer.Enum(ArgumentParserType.class);
        CODEC = Codec.KEY.transform(BY_KEY::get, ArgumentParserType::key);
    }
}

