/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.codec;

import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import net.kyori.adventure.dialog.DialogLike;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.api.BinaryTagHolder;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.KeybindComponent;
import net.kyori.adventure.text.NBTComponent;
import net.kyori.adventure.text.ScoreComponent;
import net.kyori.adventure.text.SelectorComponent;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.ShadowColor;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.StyleBuilderApplicable;
import net.kyori.adventure.text.format.StyleGetter;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.util.ARGBLike;
import net.kyori.adventure.util.Index;
import net.minestom.server.adventure.MinestomAdventure;
import net.minestom.server.codec.Codec;
import net.minestom.server.codec.Result;
import net.minestom.server.codec.StructCodec;
import net.minestom.server.codec.Transcoder;
import net.minestom.server.dialog.Dialog;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ComponentCodecs {
    private static final Codec<Component> COMPONENT_FORWARD = Codec.ForwardRef(() -> Codec.COMPONENT);
    public static final Codec<TextColor> TEXT_COLOR = new Codec<TextColor>(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        @NotNull
        public <D> Result<TextColor> decode(@NotNull Transcoder<D> coder, @NotNull D value) {
            String colorString;
            Result<String> colorResult = coder.getString(value);
            if (!(colorResult instanceof Result.Ok)) return colorResult.cast();
            Result.Ok ok = (Result.Ok)colorResult;
            try {
                String string;
                colorString = string = (String)ok.value();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            if (colorString.startsWith("#")) {
                TextColor color = TextColor.fromHexString((String)colorString);
                if (color != null) return new Result.Ok<TextColor>(color);
                return new Result.Error<TextColor>("Unknown color: " + colorString);
            }
            NamedTextColor namedColor = (NamedTextColor)NamedTextColor.NAMES.value((Object)colorString);
            if (namedColor != null) return new Result.Ok<NamedTextColor>(namedColor);
            return new Result.Error<TextColor>("Unknown color: " + colorString);
        }

        @Override
        @NotNull
        public <D> Result<D> encode(@NotNull Transcoder<D> coder, @Nullable TextColor value) {
            if (value == null) {
                return new Result.Error("null");
            }
            if (value instanceof NamedTextColor) {
                NamedTextColor namedColor = (NamedTextColor)value;
                return new Result.Ok<D>(coder.createString(namedColor.toString()));
            }
            return new Result.Ok<D>(coder.createString(value.asHexString()));
        }
    };
    public static final Codec<ShadowColor> SHADOW_COLOR = Codec.INT.transform(ShadowColor::shadowColor, ShadowColor::value);
    public static final StructCodec<ClickEvent> CLICK_EVENT = new StructCodec<ClickEvent>(){
        private static final Codec<ClickEvent.Action> ACTION_CODEC = Codec.Enum(ClickEvent.Action.class);

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        @NotNull
        public <D> Result<ClickEvent> decodeFromMap(@NotNull Transcoder<D> coder, @NotNull Transcoder.MapLike<D> map) {
            ClickEvent.Action action;
            Result actionResult = map.getValue("action").map(value -> ACTION_CODEC.decode(coder, value));
            if (!(actionResult instanceof Result.Ok)) return actionResult.cast();
            Result.Ok ok = (Result.Ok)actionResult;
            try {
                ClickEvent.Action action2;
                action = action2 = (ClickEvent.Action)ok.value();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            switch (action) {
                default: {
                    throw new MatchException(null, null);
                }
                case OPEN_URL: {
                    Result<Object> result = map.getValue("url").map(value -> Codec.STRING.decode(coder, value)).mapResult(ClickEvent::openUrl);
                    return result;
                }
                case OPEN_FILE: {
                    Result<Object> result = map.getValue("path").map(value -> Codec.STRING.decode(coder, value)).mapResult(ClickEvent::openFile);
                    return result;
                }
                case RUN_COMMAND: {
                    Result<Object> result = map.getValue("command").map(value -> Codec.STRING.decode(coder, value)).mapResult(ClickEvent::runCommand);
                    return result;
                }
                case SUGGEST_COMMAND: {
                    Result<Object> result = map.getValue("command").map(value -> Codec.STRING.decode(coder, value)).mapResult(ClickEvent::suggestCommand);
                    return result;
                }
                case CHANGE_PAGE: {
                    Result<Object> result = map.getValue("page").map(value -> Codec.INT.decode(coder, value)).mapResult(ClickEvent::changePage);
                    return result;
                }
                case COPY_TO_CLIPBOARD: {
                    Result<Object> result = map.getValue("value").map(value -> Codec.STRING.decode(coder, value)).mapResult(ClickEvent::copyToClipboard);
                    return result;
                }
                case SHOW_DIALOG: {
                    Result<Object> result = map.getValue("dialog").map(value -> Dialog.CODEC.decode(coder, value)).mapResult(dialog -> ClickEvent.showDialog((DialogLike)Dialog.wrap(dialog)));
                    return result;
                }
                case CUSTOM: {
                    Key id;
                    Result<Object> result;
                    Result idResult = map.getValue("id").map(value -> Codec.KEY.decode(coder, value));
                    if (idResult instanceof Result.Ok) {
                        Key key;
                        Result.Ok ok2 = (Result.Ok)idResult;
                        id = key = (Key)ok2.value();
                    } else {
                        result = idResult.cast();
                        return result;
                    }
                    CompoundBinaryTag payload = CompoundBinaryTag.empty();
                    if (map.hasValue("payload")) {
                        BinaryTag rawValue;
                        Result payloadResult = map.getValue("payload").map(value -> Codec.RAW_VALUE.decode(coder, value)).map(value -> value.convertTo(Transcoder.NBT));
                        if (payloadResult instanceof Result.Ok) {
                            BinaryTag binaryTag;
                            Result.Ok ok3 = (Result.Ok)payloadResult;
                            rawValue = binaryTag = (BinaryTag)ok3.value();
                        } else {
                            result = payloadResult.cast();
                            return result;
                        }
                        payload = rawValue;
                    }
                    result = new Result.Ok<ClickEvent>(ClickEvent.custom((Key)id, (BinaryTagHolder)MinestomAdventure.wrapNbt((BinaryTag)payload)));
                    return result;
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        @NotNull
        public <D> Result<D> encodeToMap(@NotNull Transcoder<D> coder, @NotNull ClickEvent value, @NotNull Transcoder.MapBuilder<D> map) {
            String string;
            Object actionValue;
            Result<D> actionResult = ACTION_CODEC.encode(coder, value.action());
            if (!(actionResult instanceof Result.Ok)) return actionResult.cast();
            Result.Ok ok = (Result.Ok)actionResult;
            try {
                Object t;
                actionValue = t = ok.value();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            map.put("action", actionValue);
            switch (value.action()) {
                default: {
                    throw new MatchException(null, null);
                }
                case OPEN_URL: {
                    string = "url";
                    return 2.encodePayload(coder, string, value.payload(), map);
                }
                case OPEN_FILE: {
                    string = "path";
                    return 2.encodePayload(coder, string, value.payload(), map);
                }
                case RUN_COMMAND: 
                case SUGGEST_COMMAND: {
                    string = "command";
                    return 2.encodePayload(coder, string, value.payload(), map);
                }
                case CHANGE_PAGE: {
                    string = "page";
                    return 2.encodePayload(coder, string, value.payload(), map);
                }
                case COPY_TO_CLIPBOARD: {
                    string = "value";
                    return 2.encodePayload(coder, string, value.payload(), map);
                }
                case SHOW_DIALOG: {
                    string = "dialog";
                    return 2.encodePayload(coder, string, value.payload(), map);
                }
                case CUSTOM: {
                    string = "__IGNORED__";
                }
            }
            return 2.encodePayload(coder, string, value.payload(), map);
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @NotNull
        private static <D> Result<D> encodePayload(@NotNull Transcoder<D> coder, @NotNull String name, @NotNull ClickEvent.Payload payload, @NotNull Transcoder.MapBuilder<D> map) {
            ClickEvent.Payload payload2 = payload;
            Objects.requireNonNull(payload2);
            ClickEvent.Payload payload3 = payload2;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ClickEvent.Payload.Text.class, ClickEvent.Payload.Int.class, ClickEvent.Payload.Dialog.class, ClickEvent.Payload.Custom.class}, (Object)payload3, n)) {
                case 0: {
                    ClickEvent.Payload.Text string = (ClickEvent.Payload.Text)payload3;
                    map.put(name, coder.createString(string.value()));
                    Result.Ok ok = new Result.Ok(map.build());
                    return ok;
                }
                case 1: {
                    ClickEvent.Payload.Int integer = (ClickEvent.Payload.Int)payload3;
                    map.put(name, coder.createInt(integer.integer()));
                    Result.Ok ok = new Result.Ok(map.build());
                    return ok;
                }
                case 2: {
                    Object dialogValue;
                    Result.Ok ok;
                    ClickEvent.Payload.Dialog dialog = (ClickEvent.Payload.Dialog)payload3;
                    Result<D> dialogResult = Dialog.CODEC.encode(coder, Dialog.unwrap(dialog.dialog()));
                    if (!(dialogResult instanceof Result.Ok)) {
                        ok = dialogResult.cast();
                        return ok;
                    }
                    Result.Ok ok2 = (Result.Ok)dialogResult;
                    try {
                        Object t;
                        dialogValue = t = ok2.value();
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                    map.put(name, dialogValue);
                    ok = new Result.Ok(map.build());
                    return ok;
                }
                case 3: {
                    Object customPayload;
                    Result.Ok ok;
                    ClickEvent.Payload.Custom custom = (ClickEvent.Payload.Custom)payload3;
                    map.put("id", coder.createString(custom.key().asString()));
                    Codec.RawValue payloadRawValue = Codec.RawValue.of(Transcoder.NBT, MinestomAdventure.unwrapNbt(custom.nbt()));
                    Result<D> payloadResult = Codec.RAW_VALUE.encode(coder, payloadRawValue);
                    if (!(payloadResult instanceof Result.Ok)) {
                        ok = payloadResult.cast();
                        return ok;
                    }
                    Result.Ok ok3 = (Result.Ok)payloadResult;
                    {
                        Object t;
                        customPayload = t = ok3.value();
                    }
                    map.put("payload", customPayload);
                    ok = new Result.Ok(map.build());
                    return ok;
                }
            }
            throw new UnsupportedOperationException("Unknown click event payload type: " + String.valueOf(payload.getClass()));
        }
    };
    private static final Codec<HoverEvent.Action<?>> HOVER_EVENT_ACTION = Codec.STRING.transform(arg_0 -> ((Index)HoverEvent.Action.NAMES).value(arg_0), HoverEvent.Action::toString);
    private static final Codec<HoverEvent<?>> HOVER_EVENT = HOVER_EVENT_ACTION.unionType("action", ComponentCodecs::hoverEventCodec, HoverEvent::action);
    private static final StructCodec<HoverEvent<Component>> SHOW_TEXT = StructCodec.struct("value", COMPONENT_FORWARD, HoverEvent::value, HoverEvent::showText);
    private static final StructCodec<HoverEvent<HoverEvent.ShowItem>> SHOW_ITEM = StructCodec.struct("id", Codec.KEY, hoverEvent -> ((HoverEvent.ShowItem)hoverEvent.value()).item(), "count", Codec.INT.optional(1), hoverEvent -> ((HoverEvent.ShowItem)hoverEvent.value()).count(), HoverEvent::showItem);
    private static final StructCodec<HoverEvent<HoverEvent.ShowEntity>> SHOW_ENTITY = StructCodec.struct("id", Codec.KEY, hoverEvent -> ((HoverEvent.ShowEntity)hoverEvent.value()).type(), "uuid", Codec.UUID_COERCED, hoverEvent -> ((HoverEvent.ShowEntity)hoverEvent.value()).id(), "name", COMPONENT_FORWARD, hoverEvent -> ((HoverEvent.ShowEntity)hoverEvent.value()).name(), HoverEvent::showEntity);
    public static final StructCodec<Style> STYLE = StructCodec.struct("color", TEXT_COLOR.optional(), Style::color, "shadow_color", SHADOW_COLOR.optional(), StyleGetter::shadowColor, "bold", Codec.BOOLEAN.optional(), s -> ComponentCodecs.stateToBool(s.decoration(TextDecoration.BOLD)), "italic", Codec.BOOLEAN.optional(), s -> ComponentCodecs.stateToBool(s.decoration(TextDecoration.ITALIC)), "underlined", Codec.BOOLEAN.optional(), s -> ComponentCodecs.stateToBool(s.decoration(TextDecoration.UNDERLINED)), "strikethrough", Codec.BOOLEAN.optional(), s -> ComponentCodecs.stateToBool(s.decoration(TextDecoration.STRIKETHROUGH)), "obfuscated", Codec.BOOLEAN.optional(), s -> ComponentCodecs.stateToBool(s.decoration(TextDecoration.OBFUSCATED)), "click_event", CLICK_EVENT.optional(), Style::clickEvent, "hover_event", HOVER_EVENT.optional(), Style::hoverEvent, "insertion", Codec.STRING.optional(), Style::insertion, "font", Codec.KEY.optional(), Style::font, (color, shadowColor, bold, italic, underlined, strikethrough, obfuscated, clickEvent, hoverEvent, insertion, font) -> ((Style.Builder)Style.style().color(color).shadowColor((ARGBLike)shadowColor)).decoration(TextDecoration.BOLD, TextDecoration.State.byBoolean((Boolean)bold)).decoration(TextDecoration.ITALIC, TextDecoration.State.byBoolean((Boolean)italic)).decoration(TextDecoration.UNDERLINED, TextDecoration.State.byBoolean((Boolean)underlined)).decoration(TextDecoration.STRIKETHROUGH, TextDecoration.State.byBoolean((Boolean)strikethrough)).decoration(TextDecoration.OBFUSCATED, TextDecoration.State.byBoolean((Boolean)obfuscated)).clickEvent(clickEvent).hoverEvent((HoverEventSource)hoverEvent).insertion(insertion).font(font).build());
    private static final StructCodec<TextComponent> TEXT_CONTENT = StructCodec.struct("text", Codec.STRING, TextComponent::content, Component::text);
    private static final StructCodec<TranslatableComponent> TRANSLATABLE_CONTENT = StructCodec.struct("translate", Codec.STRING, TranslatableComponent::key, "fallback", Codec.STRING.optional(), TranslatableComponent::fallback, "with", COMPONENT_FORWARD.list().optional(List.of()), TranslatableComponent::args, (x$0, x$1, x$2) -> Component.translatable((String)x$0, (String)x$1, (List)x$2, (StyleBuilderApplicable[])new StyleBuilderApplicable[0]));
    private static final StructCodec<ScoreComponent> SCORE_INNER_CONTENT = StructCodec.struct("name", Codec.STRING, ScoreComponent::name, "objective", Codec.STRING, ScoreComponent::objective, Component::score);
    private static final StructCodec<ScoreComponent> SCORE_CONTENT = StructCodec.struct("score", SCORE_INNER_CONTENT, component -> component, component -> component);
    private static final StructCodec<SelectorComponent> SELECTOR_CONTENT = StructCodec.struct("selector", Codec.STRING, SelectorComponent::pattern, "separator", COMPONENT_FORWARD.optional(), SelectorComponent::separator, Component::selector);
    private static final StructCodec<KeybindComponent> KEYBIND_CONTENT = StructCodec.struct("keybind", Codec.STRING, component -> component.keybind(), Component::keybind);
    private static final StructCodec<NBTComponent<?, ?>> NBT_CONTENT = new StructCodec<NBTComponent<?, ?>>(){

        @Override
        @NotNull
        public <D> Result<NBTComponent<?, ?>> decodeFromMap(@NotNull Transcoder<D> coder, @NotNull Transcoder.MapLike<D> map) {
            return new Result.Error("NBTComponent not yet supported");
        }

        @Override
        @NotNull
        public <D> Result<D> encodeToMap(@NotNull Transcoder<D> coder, @NotNull NBTComponent<?, ?> value, @NotNull Transcoder.MapBuilder<D> map) {
            return new Result.Error("NBTComponent not yet supported");
        }
    };
    public static final Codec<Component> COMPONENT = Codec.Recursive(componentCodec -> {
        final Codec componentListCodec = componentCodec.list();
        final StructCodec<List> childrenCodec = StructCodec.struct("extra", componentListCodec.optional(List.of()), children -> children, children -> children);
        return new Codec<Component>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            @NotNull
            public <D> Result<Component> decode(@NotNull Transcoder<D> coder, @NotNull D value) {
                String maybeType;
                Transcoder.MapLike map;
                Result<String> stringResult = coder.getString(value);
                if (stringResult instanceof Result.Ok) {
                    String string;
                    Result.Ok ok = (Result.Ok)stringResult;
                    String string2 = string = (String)ok.value();
                    return new Result.Ok<TextComponent>(Component.text((String)string2));
                }
                Result listResult = componentListCodec.decode(coder, value);
                if (listResult instanceof Result.Ok) {
                    List list;
                    Result.Ok string2 = (Result.Ok)listResult;
                    List list2 = list = (List)string2.value();
                    return new Result.Ok<Component>(Component.empty().children(list2));
                }
                Result<Transcoder.MapLike<D>> mapResult = coder.getMap(value);
                if (!(mapResult instanceof Result.Ok)) return mapResult.cast();
                Result.Ok ok = (Result.Ok)mapResult;
                try {
                    Transcoder.MapLike mapLike;
                    map = mapLike = (Transcoder.MapLike)ok.value();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                String string = maybeType = (String)map.getValue("type").map(coder::getString).orElse(null);
                int n = 0;
                Result.Error<Component> baseResult = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"text", "translatable", "score", "selector", "keybind", "nbt"}, (Object)string, n)) {
                    case 0 -> TEXT_CONTENT.decodeFromMap(coder, map);
                    case 1 -> TRANSLATABLE_CONTENT.decodeFromMap(coder, map);
                    case 2 -> SCORE_CONTENT.decodeFromMap(coder, map);
                    case 3 -> SELECTOR_CONTENT.decodeFromMap(coder, map);
                    case 4 -> KEYBIND_CONTENT.decodeFromMap(coder, map);
                    case 5 -> NBT_CONTENT.decodeFromMap(coder, map);
                    default -> {
                        Result<TextComponent> textResult = TEXT_CONTENT.decodeFromMap(coder, map);
                        if (textResult instanceof Result.Ok) {
                            yield textResult;
                        }
                        Result<TranslatableComponent> translatableResult = TRANSLATABLE_CONTENT.decodeFromMap(coder, map);
                        if (translatableResult instanceof Result.Ok) {
                            yield translatableResult;
                        }
                        Result<ScoreComponent> scoreResult = SCORE_CONTENT.decodeFromMap(coder, map);
                        if (scoreResult instanceof Result.Ok) {
                            yield scoreResult;
                        }
                        Result<SelectorComponent> selectorResult = SELECTOR_CONTENT.decodeFromMap(coder, map);
                        if (selectorResult instanceof Result.Ok) {
                            yield selectorResult;
                        }
                        Result<KeybindComponent> keybindResult = KEYBIND_CONTENT.decodeFromMap(coder, map);
                        if (keybindResult instanceof Result.Ok) {
                            yield keybindResult;
                        }
                        Result<NBTComponent<?, ?>> nbtResult = NBT_CONTENT.decodeFromMap(coder, map);
                        if (nbtResult instanceof Result.Ok) {
                            yield nbtResult;
                        }
                        yield new Result.Error<Component>("Unable to determine component type");
                    }
                };
                return baseResult.map(base -> childrenCodec.decodeFromMap(coder, map).mapResult(arg_0 -> ((Component)base).children(arg_0))).map(style -> STYLE.decodeFromMap(coder, map).mapResult(arg_0 -> ((Component)style).style(arg_0)));
            }

            @Override
            @NotNull
            public <D> Result<D> encode(@NotNull Transcoder<D> coder, @Nullable Component value) {
                if (value == null) {
                    return new Result.Error("null");
                }
                if (value instanceof TextComponent) {
                    TextComponent text = (TextComponent)value;
                    if (value.children().isEmpty() && value.style().isEmpty()) {
                        return new Result.Ok<D>(coder.createString(text.content()));
                    }
                }
                Transcoder.MapBuilder map = coder.createMap();
                Component component = value;
                Objects.requireNonNull(component);
                Component component2 = component;
                int n = 0;
                Result<Object> baseResult = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TextComponent.class, TranslatableComponent.class, ScoreComponent.class, SelectorComponent.class, KeybindComponent.class, NBTComponent.class}, (Object)component2, n)) {
                    case 0 -> {
                        TextComponent textComponent = (TextComponent)component2;
                        yield TEXT_CONTENT.encodeToMap(coder, textComponent, map);
                    }
                    case 1 -> {
                        TranslatableComponent translatableComponent = (TranslatableComponent)component2;
                        yield TRANSLATABLE_CONTENT.encodeToMap(coder, translatableComponent, map);
                    }
                    case 2 -> {
                        ScoreComponent scoreComponent = (ScoreComponent)component2;
                        yield SCORE_CONTENT.encodeToMap(coder, scoreComponent, map);
                    }
                    case 3 -> {
                        SelectorComponent selectorComponent = (SelectorComponent)component2;
                        yield SELECTOR_CONTENT.encodeToMap(coder, selectorComponent, map);
                    }
                    case 4 -> {
                        KeybindComponent keybindComponent = (KeybindComponent)component2;
                        yield KEYBIND_CONTENT.encodeToMap(coder, keybindComponent, map);
                    }
                    case 5 -> {
                        NBTComponent nbtComponent = (NBTComponent)component2;
                        yield NBT_CONTENT.encodeToMap(coder, nbtComponent, map);
                    }
                    default -> new Result.Error("Unknown component type: " + String.valueOf(value.getClass()));
                };
                return baseResult.map(ignored -> childrenCodec.encodeToMap(coder, value.children(), map)).map(ignored -> STYLE.encodeToMap(coder, value.style(), map)).mapResult(ignored -> map.build());
            }
        };
    });

    @Nullable
    private static Boolean stateToBool(@NotNull TextDecoration.State state) {
        return switch (state) {
            default -> throw new MatchException(null, null);
            case TextDecoration.State.NOT_SET -> null;
            case TextDecoration.State.FALSE -> false;
            case TextDecoration.State.TRUE -> true;
        };
    }

    private static StructCodec<? extends HoverEvent<?>> hoverEventCodec(@NotNull HoverEvent.Action<?> action) {
        if (action == HoverEvent.Action.SHOW_TEXT) {
            return SHOW_TEXT;
        }
        if (action == HoverEvent.Action.SHOW_ITEM) {
            return SHOW_ITEM;
        }
        if (action == HoverEvent.Action.SHOW_ENTITY) {
            return SHOW_ENTITY;
        }
        throw new IllegalStateException("Unknown hover event action: " + String.valueOf(action));
    }
}

