/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.codec;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.Style;
import net.minestom.server.codec.CodecImpl;
import net.minestom.server.codec.ComponentCodecs;
import net.minestom.server.codec.Decoder;
import net.minestom.server.codec.Encoder;
import net.minestom.server.codec.Result;
import net.minestom.server.codec.StructCodec;
import net.minestom.server.codec.Transcoder;
import net.minestom.server.coordinate.Point;
import net.minestom.server.registry.Registries;
import net.minestom.server.registry.Registry;
import net.minestom.server.utils.Either;
import net.minestom.server.utils.ThrowingFunction;
import net.minestom.server.utils.UUIDUtils;
import net.minestom.server.utils.Unit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public interface Codec<T>
extends Encoder<T>,
Decoder<T> {
    @NotNull
    public static final Codec<RawValue> RAW_VALUE = new CodecImpl.RawValueCodecImpl();
    @NotNull
    public static final Codec<Unit> UNIT = StructCodec.struct(() -> Unit.INSTANCE);
    @NotNull
    public static final Codec<Boolean> BOOLEAN = new CodecImpl.PrimitiveImpl<Boolean>(Transcoder::createBoolean, Transcoder::getBoolean);
    @NotNull
    public static final Codec<Byte> BYTE = new CodecImpl.PrimitiveImpl<Byte>(Transcoder::createByte, Transcoder::getByte);
    @NotNull
    public static final Codec<Short> SHORT = new CodecImpl.PrimitiveImpl<Short>(Transcoder::createShort, Transcoder::getShort);
    @NotNull
    public static final Codec<Integer> INT = new CodecImpl.PrimitiveImpl<Integer>(Transcoder::createInt, Transcoder::getInt);
    @NotNull
    public static final Codec<Long> LONG = new CodecImpl.PrimitiveImpl<Long>(Transcoder::createLong, Transcoder::getLong);
    @NotNull
    public static final Codec<Float> FLOAT = new CodecImpl.PrimitiveImpl<Float>(Transcoder::createFloat, Transcoder::getFloat);
    @NotNull
    public static final Codec<Double> DOUBLE = new CodecImpl.PrimitiveImpl<Double>(Transcoder::createDouble, Transcoder::getDouble);
    @NotNull
    public static final Codec<String> STRING = new CodecImpl.PrimitiveImpl<String>(Transcoder::createString, Transcoder::getString);
    @NotNull
    public static final Codec<Key> KEY = STRING.transform(Key::key, Key::asString);
    @NotNull
    public static final Codec<byte[]> BYTE_ARRAY = new CodecImpl.PrimitiveImpl<byte[]>(Transcoder::createByteArray, Transcoder::getByteArray);
    @NotNull
    public static final Codec<int[]> INT_ARRAY = new CodecImpl.PrimitiveImpl<int[]>(Transcoder::createIntArray, Transcoder::getIntArray);
    @NotNull
    public static final Codec<long[]> LONG_ARRAY = new CodecImpl.PrimitiveImpl<long[]>(Transcoder::createLongArray, Transcoder::getLongArray);
    @NotNull
    public static final Codec<UUID> UUID = INT_ARRAY.transform(UUIDUtils::intArrayToUuid, UUIDUtils::uuidToIntArray);
    @NotNull
    public static final Codec<UUID> UUID_COERCED = UUID.orElse(STRING.transform(UUID::fromString, UUID::toString));
    @NotNull
    public static final Codec<Component> COMPONENT = ComponentCodecs.COMPONENT;
    @NotNull
    public static final Codec<Style> COMPONENT_STYLE = ComponentCodecs.STYLE;
    @NotNull
    public static final Codec<Point> BLOCK_POSITION = new CodecImpl.BlockPositionImpl();
    @NotNull
    public static final Codec<Point> VECTOR3D = new CodecImpl.Vector3DImpl();
    @NotNull
    public static final Codec<BinaryTag> NBT = RAW_VALUE.transform(value -> value.convertTo(Transcoder.NBT).orElseThrow(), value -> RawValue.of(Transcoder.NBT, value));
    @NotNull
    public static final Codec<CompoundBinaryTag> NBT_COMPOUND = NBT.transform(value -> {
        if (!(value instanceof CompoundBinaryTag)) {
            throw new IllegalArgumentException("Not a compound: " + String.valueOf(value));
        }
        CompoundBinaryTag compound = (CompoundBinaryTag)value;
        return compound;
    }, compound -> compound);

    @NotNull
    public static <E extends Enum<E>> Codec<E> Enum(@NotNull Class<E> enumClass) {
        return STRING.transform(value -> Enum.valueOf(enumClass, value.toUpperCase(Locale.ROOT)), value -> value.name().toLowerCase(Locale.ROOT));
    }

    @NotNull
    public static <T> Codec<T> Recursive(@NotNull Function<Codec<T>, Codec<T>> func) {
        return new CodecImpl.RecursiveImpl<T>(func).delegate;
    }

    @NotNull
    public static <T> Codec<T> ForwardRef(@NotNull Supplier<Codec<T>> func) {
        return new CodecImpl.ForwardRefImpl<T>(func);
    }

    @NotNull
    public static <T> StructCodec<T> RegistryTaggedUnion(@NotNull Registry<StructCodec<? extends T>> registry, @NotNull Function<T, StructCodec<? extends T>> serializerGetter, @NotNull String key) {
        return Codec.RegistryTaggedUnion((Registries ignored) -> registry, serializerGetter, key);
    }

    @NotNull
    public static <T> StructCodec<T> RegistryTaggedUnion(@NotNull Registries.Selector<StructCodec<? extends T>> registrySelector, @NotNull Function<T, StructCodec<? extends T>> serializerGetter, @NotNull String key) {
        return new CodecImpl.RegistryTaggedUnionImpl<T>(registrySelector, serializerGetter, key);
    }

    @NotNull
    public static <L, R> Codec<Either<L, R>> Either(@NotNull Codec<L> leftCodec, @NotNull Codec<R> rightCodec) {
        return new CodecImpl.EitherImpl<L, R>(leftCodec, rightCodec);
    }

    default public @NotNull Codec<@Nullable T> optional() {
        return new CodecImpl.OptionalImpl<Object>(this, null);
    }

    @NotNull
    default public Codec<T> optional(@NotNull T defaultValue) {
        return new CodecImpl.OptionalImpl<T>(this, defaultValue);
    }

    @NotNull
    default public <S> Codec<S> transform(@NotNull ThrowingFunction<T, S> to, @NotNull ThrowingFunction<S, T> from) {
        return new CodecImpl.TransformImpl<T, S>(this, to, from);
    }

    @NotNull
    default public Codec<List<T>> list(int maxSize) {
        return new CodecImpl.ListImpl(this, maxSize);
    }

    @NotNull
    default public Codec<List<T>> list() {
        return this.list(Integer.MAX_VALUE);
    }

    @NotNull
    default public Codec<List<T>> listOrSingle(int maxSize) {
        return this.list(maxSize).orElse(this.transform(List::of, list -> list.isEmpty() ? null : list.getFirst()));
    }

    @NotNull
    default public Codec<List<T>> listOrSingle() {
        return this.listOrSingle(Integer.MAX_VALUE);
    }

    @NotNull
    default public Codec<Set<T>> set(int maxSize) {
        return new CodecImpl.SetImpl(this, maxSize);
    }

    @NotNull
    default public Codec<Set<T>> set() {
        return this.set(Integer.MAX_VALUE);
    }

    @NotNull
    default public <V> Codec<Map<T, V>> mapValue(@NotNull Codec<V> valueCodec, int maxSize) {
        return new CodecImpl.MapImpl(this, valueCodec, maxSize);
    }

    @NotNull
    default public <V> Codec<Map<T, V>> mapValue(@NotNull Codec<V> valueCodec) {
        return this.mapValue(valueCodec, Integer.MAX_VALUE);
    }

    default public <R, T1 extends T, TR extends R> StructCodec<R> unionType(@NotNull Function<T, StructCodec<TR>> serializers, @NotNull Function<R, T1> keyFunc) {
        return this.unionType("type", serializers, keyFunc);
    }

    default public <R, T1 extends T, TR extends R> StructCodec<R> unionType(@NotNull String keyField, @NotNull Function<T, StructCodec<TR>> serializers, @NotNull Function<R, T1> keyFunc) {
        return new CodecImpl.UnionImpl<T, R, T1, TR>(keyField, this, serializers, keyFunc);
    }

    default public Codec<T> orElse(@NotNull Codec<T> other) {
        return new CodecImpl.OrElseImpl<T>(this, other);
    }

    public static sealed interface RawValue
    permits CodecImpl.RawValueImpl {
        @NotNull
        public static <D> RawValue of(@NotNull Transcoder<D> coder, @NotNull D value) {
            return new CodecImpl.RawValueImpl<D>(coder, value);
        }

        @NotNull
        public <D> Result<D> convertTo(@NotNull Transcoder<D> var1);
    }
}

