/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.adventure;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import java.util.function.BiFunction;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.TagStringIO;
import net.kyori.adventure.nbt.api.BinaryTagHolder;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.translation.GlobalTranslator;
import net.kyori.adventure.util.Codec;
import net.minestom.server.adventure.BinaryTagHolderImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MinestomAdventure {
    private static final TagStringIO tagStringIO = TagStringIO.builder().emitHeterogeneousLists(true).acceptHeterogeneousLists(true).build();
    public static final Codec<CompoundBinaryTag, String, IOException, IOException> NBT_CODEC = Codec.codec(arg_0 -> ((TagStringIO)tagStringIO).asCompound(arg_0), arg_0 -> ((TagStringIO)tagStringIO).asString(arg_0));
    public static boolean AUTOMATIC_COMPONENT_TRANSLATION = false;
    public static BiFunction<Component, Locale, Component> COMPONENT_TRANSLATOR = GlobalTranslator::render;
    private static Locale defaultLocale = Locale.getDefault();

    private MinestomAdventure() {
    }

    @NotNull
    public static TagStringIO tagStringIO() {
        return tagStringIO;
    }

    @NotNull
    public static Locale getDefaultLocale() {
        return defaultLocale;
    }

    public static void setDefaultLocale(@Nullable Locale defaultLocale) {
        MinestomAdventure.defaultLocale = Objects.requireNonNullElseGet(defaultLocale, Locale::getDefault);
    }

    @NotNull
    public static BinaryTagHolder wrapNbt(@NotNull BinaryTag nbt) {
        return new BinaryTagHolderImpl(nbt);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static BinaryTag unwrapNbt(@NotNull BinaryTagHolder holder) {
        if (holder instanceof BinaryTagHolderImpl) {
            BinaryTagHolderImpl binaryTagHolderImpl = (BinaryTagHolderImpl)holder;
            try {
                BinaryTag binaryTag = binaryTagHolderImpl.nbt();
                return binaryTag;
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        }
        try {
            return (BinaryTag)holder.get(NBT_CODEC);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to unwrap BinaryTagHolder", e);
        }
    }
}

