/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.utils.time;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import org.jetbrains.annotations.NotNull;

public final class Cooldown {
    private final Duration duration;
    private final TemporalUnit temporalUnit;
    private boolean hasLastUpdate;
    private long lastUpdate;

    public Cooldown(@NotNull Duration duration) {
        this(duration, ChronoUnit.MILLIS);
    }

    public Cooldown(@NotNull Duration duration, @NotNull TemporalUnit temporalUnit) {
        this.duration = duration;
        this.temporalUnit = temporalUnit;
        this.hasLastUpdate = false;
    }

    @NotNull
    public TemporalUnit getTemporalUnit() {
        return this.temporalUnit;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public void refreshLastUpdate(long lastUpdate) {
        this.hasLastUpdate = true;
        this.lastUpdate = lastUpdate;
    }

    public boolean isReady(long time) {
        if (!this.hasLastUpdate) {
            return true;
        }
        return !Cooldown.hasCooldown(this.temporalUnit, time, this.lastUpdate, this.duration);
    }

    public static boolean hasCooldown(long currentTime, long lastUpdate, @NotNull TemporalUnit cooldownUnit, long cooldown) {
        return Cooldown.hasCooldown(currentTime, lastUpdate, Duration.of(cooldown, cooldownUnit));
    }

    public static boolean hasCooldown(long currentTime, long lastUpdate, @NotNull Duration duration) {
        return Cooldown.hasCooldown(ChronoUnit.MILLIS, currentTime, lastUpdate, duration);
    }

    public static boolean hasCooldown(@NotNull TemporalUnit temporalUnit, long currentTime, long lastUpdate, @NotNull TemporalUnit cooldownUnit, long cooldown) {
        return Cooldown.hasCooldown(temporalUnit, currentTime, lastUpdate, Duration.of(cooldown, cooldownUnit));
    }

    public static boolean hasCooldown(@NotNull TemporalUnit temporalUnit, long currentTime, long lastUpdate, @NotNull Duration duration) {
        return Duration.of(currentTime - lastUpdate, temporalUnit).compareTo(duration) < 0;
    }

    public static boolean hasCooldown(long lastUpdate, @NotNull TemporalUnit temporalUnit, int cooldown) {
        return Cooldown.hasCooldown(ChronoUnit.NANOS, System.nanoTime(), lastUpdate, temporalUnit, cooldown);
    }
}

