/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.UUID;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.util.RGBLike;
import net.minestom.server.color.Color;
import net.minestom.server.coordinate.Point;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.NetworkBufferTemplate;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.utils.Either;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record TrackedWaypointPacket(@NotNull Operation operation, @NotNull Waypoint waypoint) implements ServerPacket.Configuration,
ServerPacket.Play
{
    public static final NetworkBuffer.Type<TrackedWaypointPacket> SERIALIZER = NetworkBufferTemplate.template(Operation.NETWORK_TYPE, TrackedWaypointPacket::operation, Waypoint.NETWORK_TYPE, TrackedWaypointPacket::waypoint, TrackedWaypointPacket::new);

    public static enum Operation {
        TRACK,
        UNTRACK,
        UPDATE;

        public static final NetworkBuffer.Type<Operation> NETWORK_TYPE;

        static {
            NETWORK_TYPE = NetworkBuffer.Enum(Operation.class);
        }
    }

    public record Waypoint(@NotNull Either<UUID, String> id, @NotNull Icon icon, @NotNull Target target) {
        public static final NetworkBuffer.Type<Waypoint> NETWORK_TYPE = NetworkBufferTemplate.template(NetworkBuffer.Either(NetworkBuffer.UUID, NetworkBuffer.STRING), Waypoint::id, Icon.NETWORK_TYPE, Waypoint::icon, Target.NETWORK_TYPE, Waypoint::target, Waypoint::new);
    }

    public static sealed interface Target {
        @NotNull
        public static final NetworkBuffer.Type<Target> NETWORK_TYPE = Type.NETWORK_TYPE.unionType(Target::dataSerializer, Target::targetToType);

        private static NetworkBuffer.Type<Target> dataSerializer(@NotNull Type type) {
            return switch (type.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> Empty.NETWORK_TYPE;
                case 1 -> Vec3i.NETWORK_TYPE;
                case 2 -> Chunk.NETWORK_TYPE;
                case 3 -> Azimuth.NETWORK_TYPE;
            };
        }

        @NotNull
        private static Type targetToType(@NotNull Target target) {
            Target target2 = target;
            Objects.requireNonNull(target2);
            Target target3 = target2;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Empty.class, Vec3i.class, Chunk.class, Azimuth.class}, (Object)target3, n)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    Empty ignored = (Empty)target3;
                    yield Type.EMPTY;
                }
                case 1 -> {
                    Vec3i ignored = (Vec3i)target3;
                    yield Type.VEC3I;
                }
                case 2 -> {
                    Chunk ignored = (Chunk)target3;
                    yield Type.CHUNK;
                }
                case 3 -> {
                    Azimuth ignored = (Azimuth)target3;
                    yield Type.AZIMUTH;
                }
            };
        }

        public static enum Type {
            EMPTY,
            VEC3I,
            CHUNK,
            AZIMUTH;

            public static final NetworkBuffer.Type<Type> NETWORK_TYPE;

            static {
                NETWORK_TYPE = NetworkBuffer.Enum(Type.class);
            }
        }

        public record Empty() implements Target
        {
            public static final NetworkBuffer.Type<Empty> NETWORK_TYPE = NetworkBufferTemplate.template(Empty::new);
        }

        public record Vec3i(@NotNull Point point) implements Target
        {
            public static final NetworkBuffer.Type<Vec3i> NETWORK_TYPE = NetworkBufferTemplate.template(NetworkBuffer.VECTOR3I, Vec3i::point, Vec3i::new);
        }

        public record Chunk(int chunkX, int chunkZ) implements Target
        {
            public static final NetworkBuffer.Type<Chunk> NETWORK_TYPE = NetworkBufferTemplate.template(NetworkBuffer.VAR_INT, Chunk::chunkX, NetworkBuffer.VAR_INT, Chunk::chunkZ, Chunk::new);
        }

        public record Azimuth(float angle) implements Target
        {
            public static final NetworkBuffer.Type<Azimuth> NETWORK_TYPE = NetworkBufferTemplate.template(NetworkBuffer.FLOAT, Azimuth::angle, Azimuth::new);
        }
    }

    public record Icon(@NotNull Key style, @Nullable RGBLike color) {
        public static final Key DEFAULT_STYLE = Key.key((String)"default");
        public static final Icon DEFAULT = new Icon(DEFAULT_STYLE, null);
        public static final NetworkBuffer.Type<Icon> NETWORK_TYPE = NetworkBufferTemplate.template(NetworkBuffer.KEY, Icon::style, Color.NETWORK_TYPE.optional(), Icon::color, Icon::new);

        public Icon(@NotNull Key style) {
            this(style, null);
        }
    }
}

