/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item.component;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.minestom.server.codec.Codec;
import net.minestom.server.codec.StructCodec;
import net.minestom.server.entity.EquipmentSlotGroup;
import net.minestom.server.entity.attribute.Attribute;
import net.minestom.server.entity.attribute.AttributeModifier;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.NetworkBufferTemplate;
import org.jetbrains.annotations.NotNull;

public record AttributeList(@NotNull List<Modifier> modifiers) {
    public static final AttributeList EMPTY = new AttributeList(List.of());
    public static final NetworkBuffer.Type<AttributeList> NETWORK_TYPE = Modifier.NETWORK_TYPE.list(Short.MAX_VALUE).transform(AttributeList::new, AttributeList::modifiers);
    public static final Codec<AttributeList> CODEC = Modifier.CODEC.list(Short.MAX_VALUE).transform(AttributeList::new, AttributeList::modifiers);

    public AttributeList(@NotNull List<Modifier> modifiers) {
        modifiers = List.copyOf(modifiers);
    }

    public AttributeList(@NotNull Modifier modifier) {
        this(List.of(modifier));
    }

    @NotNull
    public AttributeList with(@NotNull Modifier modifier) {
        ArrayList<Modifier> newModifiers = new ArrayList<Modifier>(this.modifiers);
        newModifiers.add(modifier);
        return new AttributeList(newModifiers);
    }

    @NotNull
    public AttributeList remove(@NotNull Modifier modifier) {
        ArrayList<Modifier> newModifiers = new ArrayList<Modifier>(this.modifiers);
        newModifiers.remove(modifier);
        return new AttributeList(newModifiers);
    }

    public record Modifier(@NotNull Attribute attribute, @NotNull AttributeModifier modifier, @NotNull EquipmentSlotGroup slot, @NotNull Display display) {
        public static final NetworkBuffer.Type<Modifier> NETWORK_TYPE = NetworkBufferTemplate.template(Attribute.NETWORK_TYPE, Modifier::attribute, AttributeModifier.NETWORK_TYPE, Modifier::modifier, NetworkBuffer.Enum(EquipmentSlotGroup.class), Modifier::slot, Display.NETWORK_TYPE, Modifier::display, Modifier::new);
        public static final Codec<Modifier> CODEC = StructCodec.struct("type", Attribute.CODEC, Modifier::attribute, "$$inline$$", AttributeModifier.CODEC, Modifier::modifier, "slot", EquipmentSlotGroup.CODEC.optional(EquipmentSlotGroup.ANY), Modifier::slot, "display", Display.CODEC.optional(Display.Default.INSTANCE), Modifier::display, Modifier::new);

        public Modifier(@NotNull Attribute attribute, @NotNull AttributeModifier modifier, @NotNull EquipmentSlotGroup slot) {
            this(attribute, modifier, slot, Display.Default.INSTANCE);
        }
    }

    public static sealed interface Display {
        @NotNull
        public static final NetworkBuffer.Type<Display> NETWORK_TYPE = Type.NETWORK_TYPE.unionType(Display::dataSerializer, Display::targetToType);
        @NotNull
        public static final Codec<Display> CODEC = Type.CODEC.unionType(Display::codec, Display::targetToType);

        private static NetworkBuffer.Type<Display> dataSerializer(@NotNull Type type) {
            return switch (type.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> Default.NETWORK_TYPE;
                case 1 -> Hidden.NETWORK_TYPE;
                case 2 -> Override.NETWORK_TYPE;
            };
        }

        private static StructCodec<? extends Display> codec(@NotNull Type type) {
            return switch (type.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> Default.CODEC;
                case 1 -> Hidden.CODEC;
                case 2 -> Override.CODEC;
            };
        }

        @NotNull
        private static Type targetToType(@NotNull Display display) {
            Display display2 = display;
            Objects.requireNonNull(display2);
            Display display3 = display2;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Default.class, Hidden.class, Override.class}, (Object)display3, n)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    Default ignored = (Default)display3;
                    yield Type.DEFAULT;
                }
                case 1 -> {
                    Hidden ignored = (Hidden)display3;
                    yield Type.HIDDEN;
                }
                case 2 -> {
                    Override ignored = (Override)display3;
                    yield Type.OVERRIDE;
                }
            };
        }

        public static enum Type {
            DEFAULT,
            HIDDEN,
            OVERRIDE;

            public static final NetworkBuffer.Type<Type> NETWORK_TYPE;
            public static final Codec<Type> CODEC;

            static {
                NETWORK_TYPE = NetworkBuffer.Enum(Type.class);
                CODEC = Codec.Enum(Type.class);
            }
        }

        public record Default() implements Display
        {
            public static final Default INSTANCE = new Default();
            public static final NetworkBuffer.Type<Default> NETWORK_TYPE = NetworkBufferTemplate.template(() -> INSTANCE);
            public static final StructCodec<Default> CODEC = StructCodec.struct(() -> INSTANCE);
        }

        public record Hidden() implements Display
        {
            public static final Hidden INSTANCE = new Hidden();
            public static final NetworkBuffer.Type<Hidden> NETWORK_TYPE = NetworkBufferTemplate.template(() -> INSTANCE);
            public static final StructCodec<Hidden> CODEC = StructCodec.struct(() -> INSTANCE);
        }

        public record Override(@NotNull Component component) implements Display
        {
            public static final NetworkBuffer.Type<Override> NETWORK_TYPE = NetworkBufferTemplate.template(NetworkBuffer.COMPONENT, Override::component, Override::new);
            public static final StructCodec<Override> CODEC = StructCodec.struct("value", Codec.COMPONENT, Override::component, Override::new);
        }
    }
}

