/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.command;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.kyori.adventure.key.Key;
import net.minestom.server.codec.Codec;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.StaticProtocolObject;
import org.jetbrains.annotations.NotNull;

public enum ArgumentParserType implements StaticProtocolObject<ArgumentParserType>
{
    BOOL(Key.key((String)"brigadier:bool")),
    FLOAT(Key.key((String)"brigadier:float")),
    DOUBLE(Key.key((String)"brigadier:double")),
    INTEGER(Key.key((String)"brigadier:integer")),
    LONG(Key.key((String)"brigadier:long")),
    STRING(Key.key((String)"brigadier:string")),
    ENTITY(Key.key((String)"entity")),
    GAME_PROFILE(Key.key((String)"game_profile")),
    BLOCK_POS(Key.key((String)"block_pos")),
    COLUMN_POS(Key.key((String)"column_pos")),
    VEC3(Key.key((String)"vec3")),
    VEC2(Key.key((String)"vec2")),
    BLOCK_STATE(Key.key((String)"block_state")),
    BLOCK_PREDICATE(Key.key((String)"block_predicate")),
    ITEM_STACK(Key.key((String)"item_stack")),
    ITEM_PREDICATE(Key.key((String)"item_predicate")),
    COLOR(Key.key((String)"color")),
    HEX_COLOR(Key.key((String)"hex_color")),
    COMPONENT(Key.key((String)"component")),
    STYLE(Key.key((String)"style")),
    MESSAGE(Key.key((String)"message")),
    NBT_COMPOUND_TAG(Key.key((String)"nbt_compound_tag")),
    NBT_TAG(Key.key((String)"nbt_tag")),
    NBT_PATH(Key.key((String)"nbt_path")),
    OBJECTIVE(Key.key((String)"objective")),
    OBJECTIVE_CRITERIA(Key.key((String)"objective_criteria")),
    OPERATION(Key.key((String)"operation")),
    PARTICLE(Key.key((String)"particle")),
    ANGLE(Key.key((String)"angle")),
    ROTATION(Key.key((String)"rotation")),
    SCOREBOARD_SLOT(Key.key((String)"scoreboard_slot")),
    SCORE_HOLDER(Key.key((String)"score_holder")),
    SWIZZLE(Key.key((String)"swizzle")),
    TEAM(Key.key((String)"team")),
    ITEM_SLOT(Key.key((String)"item_slot")),
    ITEM_SLOTS(Key.key((String)"item_slots")),
    RESOURCE_LOCATION(Key.key((String)"resource_location")),
    FUNCTION(Key.key((String)"function")),
    ENTITY_ANCHOR(Key.key((String)"entity_anchor")),
    INT_RANGE(Key.key((String)"int_range")),
    FLOAT_RANGE(Key.key((String)"float_range")),
    DIMENSION(Key.key((String)"dimension")),
    GAMEMODE(Key.key((String)"gamemode")),
    TIME(Key.key((String)"time")),
    RESOURCE_OR_TAG(Key.key((String)"resource_or_tag")),
    RESOURCE_OR_TAG_KEY(Key.key((String)"resource_or_tag_key")),
    RESOURCE(Key.key((String)"resource")),
    RESOURCE_KEY(Key.key((String)"resource_key")),
    RESOURCE_SELECTOR(Key.key((String)"resource_selector")),
    TEMPLATE_MIRROR(Key.key((String)"template_mirror")),
    TEMPLATE_ROTATION(Key.key((String)"template_rotation")),
    HEIGHTMAP(Key.key((String)"heightmap")),
    LOOT_TABLE(Key.key((String)"loot_table")),
    LOOT_PREDICATE(Key.key((String)"loot_predicate")),
    LOOT_MODIFIER(Key.key((String)"loot_modifier")),
    DIALOG(Key.key((String)"dialog")),
    UUID(Key.key((String)"uuid"));

    private static final Map<Key, ArgumentParserType> BY_KEY;
    public static final NetworkBuffer.Type<ArgumentParserType> NETWORK_TYPE;
    public static final Codec<ArgumentParserType> CODEC;
    private final Key key;

    private ArgumentParserType(Key key) {
        this.key = key;
    }

    @Override
    @NotNull
    public Key key() {
        return this.key;
    }

    @Override
    public int id() {
        return this.ordinal();
    }

    static {
        BY_KEY = Arrays.stream(ArgumentParserType.values()).collect(Collectors.toMap(ArgumentParserType::key, Function.identity()));
        NETWORK_TYPE = NetworkBuffer.Enum(ArgumentParserType.class);
        CODEC = Codec.KEY.transform(BY_KEY::get, ArgumentParserType::key);
    }
}

