/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item.book;

import net.kyori.adventure.text.Component;
import net.minestom.server.codec.Codec;
import net.minestom.server.codec.StructCodec;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.NetworkBufferTemplate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record FilteredText<T>(@NotNull T text, @Nullable T filtered) {
    @NotNull
    public static NetworkBuffer.Type<FilteredText<String>> STRING_NETWORK_TYPE = FilteredText.createNetworkType(NetworkBuffer.STRING);
    @NotNull
    public static Codec<FilteredText<String>> STRING_CODEC = FilteredText.createCodec(Codec.STRING);
    @NotNull
    public static NetworkBuffer.Type<FilteredText<Component>> COMPONENT_NETWORK_TYPE = FilteredText.createNetworkType(NetworkBuffer.COMPONENT);
    @NotNull
    public static Codec<FilteredText<Component>> COMPONENT_CODEC = FilteredText.createCodec(Codec.COMPONENT);

    private static <T> @NotNull NetworkBuffer.Type<FilteredText<T>> createNetworkType(@NotNull NetworkBuffer.Type<T> inner) {
        return NetworkBufferTemplate.template(inner, FilteredText::text, inner.optional(), FilteredText::filtered, FilteredText::new);
    }

    @NotNull
    private static <T> Codec<FilteredText<T>> createCodec(@NotNull Codec<T> inner) {
        return StructCodec.struct("raw", inner, FilteredText::text, "filtered", inner.optional(), FilteredText::filtered, FilteredText::new);
    }
}

