/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.metadata.other;

import net.minestom.server.component.DataComponent;
import net.minestom.server.component.DataComponents;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.MetadataDef;
import net.minestom.server.entity.MetadataHolder;
import net.minestom.server.entity.metadata.EntityMeta;
import net.minestom.server.entity.metadata.ObjectDataProvider;
import net.minestom.server.entity.metadata.other.PaintingVariant;
import net.minestom.server.registry.Holder;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PaintingMeta
extends EntityMeta
implements ObjectDataProvider {
    private Orientation orientation = null;

    public PaintingMeta(@NotNull Entity entity, @NotNull MetadataHolder metadata) {
        super(entity, metadata);
    }

    @Deprecated
    @NotNull
    public Holder<PaintingVariant> getVariant() {
        return this.metadata.get(MetadataDef.Painting.VARIANT);
    }

    @Deprecated
    public void setVariant(@NotNull Holder<PaintingVariant> value) {
        this.metadata.set(MetadataDef.Painting.VARIANT, value);
    }

    @NotNull
    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(@NotNull Orientation orientation) {
        this.orientation = orientation;
    }

    @Override
    public int getObjectData() {
        Check.stateCondition(this.orientation == null, "Painting orientation must be set before spawn");
        return this.orientation.id();
    }

    @Override
    public boolean requiresVelocityPacketAtSpawn() {
        return false;
    }

    @Override
    @Nullable
    protected <T> T get(@NotNull DataComponent<T> component) {
        if (component == DataComponents.PAINTING_VARIANT) {
            return (T)this.getVariant();
        }
        return super.get(component);
    }

    @Override
    protected <T> void set(@NotNull DataComponent<T> component, @NotNull T value) {
        if (component == DataComponents.PAINTING_VARIANT) {
            this.setVariant((Holder)value);
        } else {
            super.set(component, value);
        }
    }

    public static enum Orientation {
        NORTH(2),
        SOUTH(3),
        WEST(4),
        EAST(5);

        private final int id;

        private Orientation(int id) {
            this.id = id;
        }

        public int id() {
            return this.id;
        }
    }
}

