/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.command;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.kyori.adventure.key.Key;
import net.minestom.server.codec.Codec;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.StaticProtocolObject;
import org.jetbrains.annotations.NotNull;

public enum ArgumentParserType implements StaticProtocolObject
{
    BOOL(Key.key((String)"brigadier:bool")),
    FLOAT(Key.key((String)"brigadier:float")),
    DOUBLE(Key.key((String)"brigadier:double")),
    INTEGER(Key.key((String)"brigadier:integer")),
    LONG(Key.key((String)"brigadier:long")),
    STRING(Key.key((String)"brigadier:string")),
    ENTITY(Key.key((String)"minecraft:entity")),
    GAME_PROFILE(Key.key((String)"minecraft:game_profile")),
    BLOCK_POS(Key.key((String)"minecraft:block_pos")),
    COLUMN_POS(Key.key((String)"minecraft:column_pos")),
    VEC3(Key.key((String)"minecraft:vec3")),
    VEC2(Key.key((String)"minecraft:vec2")),
    BLOCK_STATE(Key.key((String)"minecraft:block_state")),
    BLOCK_PREDICATE(Key.key((String)"minecraft:block_predicate")),
    ITEM_STACK(Key.key((String)"minecraft:item_stack")),
    ITEM_PREDICATE(Key.key((String)"minecraft:item_predicate")),
    COLOR(Key.key((String)"minecraft:color")),
    COMPONENT(Key.key((String)"minecraft:component")),
    STYLE(Key.key((String)"minecraft:style")),
    MESSAGE(Key.key((String)"minecraft:message")),
    NBT_COMPOUND_TAG(Key.key((String)"minecraft:nbt_compound_tag")),
    NBT_TAG(Key.key((String)"minecraft:nbt_tag")),
    NBT_PATH(Key.key((String)"minecraft:nbt_path")),
    OBJECTIVE(Key.key((String)"minecraft:objective")),
    OBJECTIVE_CRITERIA(Key.key((String)"minecraft:objective_criteria")),
    OPERATION(Key.key((String)"minecraft:operation")),
    PARTICLE(Key.key((String)"minecraft:particle")),
    ANGLE(Key.key((String)"minecraft:angle")),
    ROTATION(Key.key((String)"minecraft:rotation")),
    SCOREBOARD_SLOT(Key.key((String)"minecraft:scoreboard_slot")),
    SCORE_HOLDER(Key.key((String)"minecraft:score_holder")),
    SWIZZLE(Key.key((String)"minecraft:swizzle")),
    TEAM(Key.key((String)"minecraft:team")),
    ITEM_SLOT(Key.key((String)"minecraft:item_slot")),
    ITEM_SLOTS(Key.key((String)"minecraft:item_slots")),
    RESOURCE_LOCATION(Key.key((String)"minecraft:resource_location")),
    FUNCTION(Key.key((String)"minecraft:function")),
    ENTITY_ANCHOR(Key.key((String)"minecraft:entity_anchor")),
    INT_RANGE(Key.key((String)"minecraft:int_range")),
    FLOAT_RANGE(Key.key((String)"minecraft:float_range")),
    DIMENSION(Key.key((String)"minecraft:dimension")),
    GAMEMODE(Key.key((String)"minecraft:gamemode")),
    TIME(Key.key((String)"minecraft:time")),
    RESOURCE_OR_TAG(Key.key((String)"minecraft:resource_or_tag")),
    RESOURCE_OR_TAG_KEY(Key.key((String)"minecraft:resource_or_tag_key")),
    RESOURCE(Key.key((String)"minecraft:resource")),
    RESOURCE_KEY(Key.key((String)"minecraft:resource_key")),
    RESOURCE_SELECTOR(Key.key((String)"minecraft:resource_selector")),
    TEMPLATE_MIRROR(Key.key((String)"minecraft:template_mirror")),
    TEMPLATE_ROTATION(Key.key((String)"minecraft:template_rotation")),
    HEIGHTMAP(Key.key((String)"minecraft:heightmap")),
    LOOT_TABLE(Key.key((String)"minecraft:loot_table")),
    LOOT_PREDICATE(Key.key((String)"minecraft:loot_predicate")),
    LOOT_MODIFIER(Key.key((String)"minecraft:loot_modifier")),
    UUID(Key.key((String)"minecraft:uuid"));

    private static final Map<Key, ArgumentParserType> BY_KEY;
    public static final NetworkBuffer.Type<ArgumentParserType> NETWORK_TYPE;
    public static final Codec<ArgumentParserType> CODEC;
    private final Key key;

    private ArgumentParserType(Key key) {
        this.key = key;
    }

    @Override
    @NotNull
    public Key key() {
        return this.key;
    }

    @Override
    public int id() {
        return this.ordinal();
    }

    static {
        BY_KEY = Arrays.stream(ArgumentParserType.values()).collect(Collectors.toMap(ArgumentParserType::key, Function.identity()));
        NETWORK_TYPE = NetworkBuffer.Enum(ArgumentParserType.class);
        CODEC = Codec.KEY.transform(BY_KEY::get, ArgumentParserType::key);
    }
}

