/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import net.minestom.server.MinecraftConstants;
import net.minestom.server.ServerFlag;
import net.minestom.server.ServerProcess;
import net.minestom.server.ServerProcessImpl;
import net.minestom.server.advancements.AdvancementManager;
import net.minestom.server.adventure.bossbar.BossBarManager;
import net.minestom.server.codec.StructCodec;
import net.minestom.server.command.CommandManager;
import net.minestom.server.entity.damage.DamageType;
import net.minestom.server.entity.metadata.animal.tameable.WolfVariant;
import net.minestom.server.entity.metadata.other.PaintingVariant;
import net.minestom.server.event.GlobalEventHandler;
import net.minestom.server.exception.ExceptionManager;
import net.minestom.server.instance.InstanceManager;
import net.minestom.server.instance.block.BlockManager;
import net.minestom.server.instance.block.banner.BannerPattern;
import net.minestom.server.instance.block.jukebox.JukeboxSong;
import net.minestom.server.item.armor.TrimMaterial;
import net.minestom.server.item.armor.TrimPattern;
import net.minestom.server.item.enchant.Enchantment;
import net.minestom.server.item.enchant.EntityEffect;
import net.minestom.server.item.enchant.LevelBasedValue;
import net.minestom.server.item.enchant.LocationEffect;
import net.minestom.server.item.enchant.ValueEffect;
import net.minestom.server.item.instrument.Instrument;
import net.minestom.server.listener.manager.PacketListenerManager;
import net.minestom.server.message.ChatType;
import net.minestom.server.monitoring.BenchmarkManager;
import net.minestom.server.network.ConnectionManager;
import net.minestom.server.network.packet.PacketParser;
import net.minestom.server.network.packet.client.ClientPacket;
import net.minestom.server.network.packet.server.common.PluginMessagePacket;
import net.minestom.server.network.packet.server.play.ServerDifficultyPacket;
import net.minestom.server.network.socket.Server;
import net.minestom.server.recipe.RecipeManager;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.scoreboard.TeamManager;
import net.minestom.server.thread.TickSchedulerThread;
import net.minestom.server.timer.SchedulerManager;
import net.minestom.server.utils.PacketSendingUtils;
import net.minestom.server.utils.validate.Check;
import net.minestom.server.world.Difficulty;
import net.minestom.server.world.DimensionType;
import net.minestom.server.world.biome.Biome;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnknownNullability;

public final class MinecraftServer
implements MinecraftConstants {
    public static final ComponentLogger LOGGER = ComponentLogger.logger(MinecraftServer.class);
    public static final String THREAD_NAME_BENCHMARK = "Ms-Benchmark";
    public static final String THREAD_NAME_TICK_SCHEDULER = "Ms-TickScheduler";
    public static final String THREAD_NAME_TICK = "Ms-Tick";
    @Deprecated
    public static final int TICK_PER_SECOND = ServerFlag.SERVER_TICKS_PER_SECOND;
    public static final int TICK_MS = 1000 / TICK_PER_SECOND;
    private static final boolean IMMUTABLE_SERVER_PROCESS = !ServerFlag.ALLOW_MULTIPLE_INITIALIZATIONS && !ServerFlag.INSIDE_TEST;
    private static volatile ServerProcess serverProcess;
    private static int compressionThreshold;
    private static String brandName;
    private static Difficulty difficulty;

    public static MinecraftServer init() {
        Check.notNull(MinecraftServer.updateProcess(), "Server process cannot be null.");
        return new MinecraftServer();
    }

    @ApiStatus.Internal
    public static ServerProcess updateProcess() {
        if (serverProcess != null && IMMUTABLE_SERVER_PROCESS) {
            LOGGER.warn("The server process is likely already initialized, but you are trying to initialize it again.\nThis is not allowed in immutable mode. If you want to change the server process,\nyou will need to restart the JVM and or set ServerFlag.ALLOW_MULTIPLE_INITIALIZATIONS to true.\n");
            return serverProcess;
        }
        serverProcess = new ServerProcessImpl();
        return MinecraftServer.process();
    }

    @NotNull
    public static String getBrandName() {
        return brandName;
    }

    public static void setBrandName(@NotNull String brandName) {
        MinecraftServer.brandName = brandName;
        PacketSendingUtils.broadcastPlayPacket(PluginMessagePacket.brandPacket(brandName));
    }

    @NotNull
    public static Difficulty getDifficulty() {
        return difficulty;
    }

    public static void setDifficulty(@NotNull Difficulty difficulty) {
        MinecraftServer.difficulty = difficulty;
        PacketSendingUtils.broadcastPlayPacket(new ServerDifficultyPacket(difficulty, true));
    }

    public static @UnknownNullability ServerProcess process() {
        if (IMMUTABLE_SERVER_PROCESS) {
            return ImmutableServerProcessHolder.SERVER_PROCESS;
        }
        return serverProcess;
    }

    @NotNull
    public static GlobalEventHandler getGlobalEventHandler() {
        return MinecraftServer.process().eventHandler();
    }

    @NotNull
    public static PacketListenerManager getPacketListenerManager() {
        return MinecraftServer.process().packetListener();
    }

    @NotNull
    public static InstanceManager getInstanceManager() {
        return MinecraftServer.process().instance();
    }

    @NotNull
    public static BlockManager getBlockManager() {
        return MinecraftServer.process().block();
    }

    @NotNull
    public static CommandManager getCommandManager() {
        return MinecraftServer.process().command();
    }

    @NotNull
    public static RecipeManager getRecipeManager() {
        return MinecraftServer.process().recipe();
    }

    @NotNull
    public static TeamManager getTeamManager() {
        return MinecraftServer.process().team();
    }

    @NotNull
    public static SchedulerManager getSchedulerManager() {
        return MinecraftServer.process().scheduler();
    }

    @NotNull
    public static BenchmarkManager getBenchmarkManager() {
        return MinecraftServer.process().benchmark();
    }

    @NotNull
    public static ExceptionManager getExceptionManager() {
        return MinecraftServer.process().exception();
    }

    @NotNull
    public static ConnectionManager getConnectionManager() {
        return MinecraftServer.process().connection();
    }

    @NotNull
    public static BossBarManager getBossBarManager() {
        return MinecraftServer.process().bossBar();
    }

    @NotNull
    public static PacketParser<ClientPacket> getPacketParser() {
        return MinecraftServer.process().packetParser();
    }

    public static boolean isStarted() {
        return MinecraftServer.process().isAlive();
    }

    public static boolean isStopping() {
        return !MinecraftServer.isStarted();
    }

    @Deprecated
    public static int getChunkViewDistance() {
        return ServerFlag.CHUNK_VIEW_DISTANCE;
    }

    @Deprecated
    public static int getEntityViewDistance() {
        return ServerFlag.ENTITY_VIEW_DISTANCE;
    }

    public static int getCompressionThreshold() {
        return compressionThreshold;
    }

    public static void setCompressionThreshold(int compressionThreshold) {
        Check.stateCondition(serverProcess != null && serverProcess.isAlive(), "The compression threshold cannot be changed after the server has been started.");
        MinecraftServer.compressionThreshold = compressionThreshold;
    }

    public static AdvancementManager getAdvancementManager() {
        return MinecraftServer.process().advancement();
    }

    @NotNull
    public static DynamicRegistry<ChatType> getChatTypeRegistry() {
        return MinecraftServer.process().chatType();
    }

    @NotNull
    public static DynamicRegistry<DimensionType> getDimensionTypeRegistry() {
        return MinecraftServer.process().dimensionType();
    }

    @NotNull
    public static DynamicRegistry<Biome> getBiomeRegistry() {
        return MinecraftServer.process().biome();
    }

    @NotNull
    public static DynamicRegistry<DamageType> getDamageTypeRegistry() {
        return MinecraftServer.process().damageType();
    }

    @NotNull
    public static DynamicRegistry<TrimMaterial> getTrimMaterialRegistry() {
        return MinecraftServer.process().trimMaterial();
    }

    @NotNull
    public static DynamicRegistry<TrimPattern> getTrimPatternRegistry() {
        return MinecraftServer.process().trimPattern();
    }

    @NotNull
    public static DynamicRegistry<BannerPattern> getBannerPatternRegistry() {
        return MinecraftServer.process().bannerPattern();
    }

    @NotNull
    public static DynamicRegistry<WolfVariant> getWolfVariantRegistry() {
        return MinecraftServer.process().wolfVariant();
    }

    @NotNull
    public static DynamicRegistry<Enchantment> getEnchantmentRegistry() {
        return MinecraftServer.process().enchantment();
    }

    @NotNull
    public static DynamicRegistry<PaintingVariant> getPaintingVariantRegistry() {
        return MinecraftServer.process().paintingVariant();
    }

    @NotNull
    public static DynamicRegistry<JukeboxSong> getJukeboxSongRegistry() {
        return MinecraftServer.process().jukeboxSong();
    }

    @NotNull
    public static DynamicRegistry<Instrument> getInstrumentRegistry() {
        return MinecraftServer.process().instrument();
    }

    @NotNull
    public static DynamicRegistry<StructCodec<? extends LevelBasedValue>> enchantmentLevelBasedValues() {
        return MinecraftServer.process().enchantmentLevelBasedValues();
    }

    @NotNull
    public static DynamicRegistry<StructCodec<? extends ValueEffect>> enchantmentValueEffects() {
        return MinecraftServer.process().enchantmentValueEffects();
    }

    @NotNull
    public static DynamicRegistry<StructCodec<? extends EntityEffect>> enchantmentEntityEffects() {
        return MinecraftServer.process().enchantmentEntityEffects();
    }

    @NotNull
    public static DynamicRegistry<StructCodec<? extends LocationEffect>> enchantmentLocationEffects() {
        return MinecraftServer.process().enchantmentLocationEffects();
    }

    public static Server getServer() {
        return MinecraftServer.process().server();
    }

    public void start(@NotNull SocketAddress address) {
        MinecraftServer.process().start(address);
        new TickSchedulerThread(MinecraftServer.process()).start();
    }

    public void start(@NotNull String address, int port) {
        this.start(new InetSocketAddress(address, port));
    }

    public static void stopCleanly() {
        MinecraftServer.process().stop();
    }

    static {
        compressionThreshold = 256;
        brandName = "Minestom";
        difficulty = Difficulty.NORMAL;
    }

    private static final class ImmutableServerProcessHolder {
        private static final ServerProcess SERVER_PROCESS;

        private ImmutableServerProcessHolder() {
        }

        static {
            Check.stateCondition(!IMMUTABLE_SERVER_PROCESS, "ServerProcessHolder.Immutable should only be initialized when the server process is immutable.");
            Check.notNull(serverProcess, "The server is not initialized yet; Did you forget to use MinecraftServer.init()?");
            SERVER_PROCESS = serverProcess;
        }
    }
}

