/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item.component;

import java.util.List;
import net.kyori.adventure.text.Component;
import net.minestom.server.codec.Codec;
import net.minestom.server.codec.StructCodec;
import net.minestom.server.item.book.FilteredText;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.NetworkBufferTemplate;
import org.jetbrains.annotations.NotNull;

public record WrittenBookContent(@NotNull FilteredText<String> title, @NotNull String author, int generation, @NotNull List<FilteredText<Component>> pages, boolean resolved) {
    public static final WrittenBookContent EMPTY = new WrittenBookContent(new FilteredText<Object>("", null), "", 0, List.of(), true);
    public static final NetworkBuffer.Type<WrittenBookContent> NETWORK_TYPE = NetworkBufferTemplate.template(FilteredText.STRING_NETWORK_TYPE, WrittenBookContent::title, NetworkBuffer.STRING, WrittenBookContent::author, NetworkBuffer.VAR_INT, WrittenBookContent::generation, FilteredText.COMPONENT_NETWORK_TYPE.list(100), WrittenBookContent::pages, NetworkBuffer.BOOLEAN, WrittenBookContent::resolved, WrittenBookContent::new);
    public static final Codec<WrittenBookContent> CODEC = StructCodec.struct("title", FilteredText.STRING_CODEC, WrittenBookContent::title, "author", Codec.STRING, WrittenBookContent::author, "generation", Codec.INT.optional(0), WrittenBookContent::generation, "pages", FilteredText.COMPONENT_CODEC.list(100).optional(List.of()), WrittenBookContent::pages, "resolved", Codec.BOOLEAN.optional(false), WrittenBookContent::resolved, WrittenBookContent::new);

    public WrittenBookContent(@NotNull FilteredText<String> title, @NotNull String author, int generation, @NotNull List<FilteredText<Component>> pages, boolean resolved) {
        pages = List.copyOf(pages);
    }

    public WrittenBookContent(@NotNull String title, @NotNull String author, @NotNull List<Component> pages) {
        this(title, author, 0, pages, true);
    }

    public WrittenBookContent(@NotNull String title, @NotNull String author, int generation, @NotNull List<Component> pages, boolean resolved) {
        this(new FilteredText<Object>(title, null), author, generation, pages.stream().map(page -> new FilteredText<Object>(page, null)).toList(), resolved);
    }
}

