/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minestom.server.codec.Transcoder;
import net.minestom.server.component.DataComponent;
import net.minestom.server.item.ItemStack;
import net.minestom.server.item.Material;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.NetworkBufferTemplate;
import org.jetbrains.annotations.NotNull;

final class ItemStackHashImpl {
    public static final NetworkBuffer.Type<ItemStack.Hash> NETWORK_TYPE = new NetworkBuffer.Type<ItemStack.Hash>(){

        @Override
        public void write(@NotNull NetworkBuffer buffer, ItemStack.Hash value) {
            if (!(value instanceof Item)) {
                buffer.write(NetworkBuffer.BOOLEAN, false);
                return;
            }
            Item item = (Item)value;
            buffer.write(NetworkBuffer.BOOLEAN, true);
            buffer.write(Item.NETWORK_TYPE, item);
        }

        @Override
        public ItemStack.Hash read(@NotNull NetworkBuffer buffer) {
            if (!buffer.read(NetworkBuffer.BOOLEAN).booleanValue()) {
                return ItemStack.Hash.AIR;
            }
            return buffer.read(Item.NETWORK_TYPE);
        }
    };

    ItemStackHashImpl() {
    }

    @NotNull
    public static ItemStack.Hash of(@NotNull Transcoder<Integer> hashCoder, @NotNull ItemStack itemStack) {
        if (itemStack.isAir()) {
            return ItemStack.Hash.AIR;
        }
        HashMap addedComponents = new HashMap();
        HashSet removedComponents = new HashSet();
        for (Map.Entry<DataComponent<?>, Object> entry : itemStack.componentPatch().entrySet()) {
            if (entry.getValue() != null) {
                addedComponents.put(entry.getKey(), (Integer)entry.getKey().encode(hashCoder, entry.getValue()).orElseThrow());
                continue;
            }
            removedComponents.add(entry.getKey());
        }
        return new Item(itemStack.material(), itemStack.amount(), addedComponents, removedComponents);
    }

    record Item(@NotNull Material material, int amount, @NotNull Map<DataComponent<?>, Integer> addedComponents, @NotNull Set<DataComponent<?>> removedComponents) implements ItemStack.Hash
    {
        private static final int MAX_COMPONENTS = 256;
        public static final NetworkBuffer.Type<Item> NETWORK_TYPE = NetworkBufferTemplate.template(Material.NETWORK_TYPE, Item::material, NetworkBuffer.VAR_INT, Item::amount, DataComponent.NETWORK_TYPE.mapValue(NetworkBuffer.INT, 256), Item::addedComponents, DataComponent.NETWORK_TYPE.set(256), Item::removedComponents, Item::new);
    }

    record Air() implements ItemStack.Hash
    {
    }
}

