/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance.block.predicate;

import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.minestom.server.codec.Codec;
import net.minestom.server.instance.block.Block;
import net.minestom.server.instance.block.predicate.BlockTypeFilter;
import net.minestom.server.instance.block.predicate.PropertiesPredicate;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.NetworkBufferTemplate;
import net.minestom.server.utils.Unit;
import net.minestom.server.utils.block.BlockUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record BlockPredicate(@Nullable BlockTypeFilter blocks, @Nullable PropertiesPredicate state, @Nullable CompoundBinaryTag nbt) implements Predicate<Block>
{
    public static final BlockPredicate ALL = new BlockPredicate(null, null, null);
    public static final BlockPredicate NONE = new BlockPredicate(null, new PropertiesPredicate(Map.of("no_such_property", new PropertiesPredicate.ValuePredicate.Exact("never"))), null);
    public static final NetworkBuffer.Type<BlockPredicate> NETWORK_TYPE = NetworkBufferTemplate.template(BlockTypeFilter.NETWORK_TYPE.optional(), BlockPredicate::blocks, PropertiesPredicate.NETWORK_TYPE.optional(), BlockPredicate::state, NetworkBuffer.NBT_COMPOUND.optional(), BlockPredicate::nbt, BlockPredicate::new);
    public static final Codec<BlockPredicate> CODEC = Codec.UNIT.transform(ignored -> NONE, ignored -> Unit.INSTANCE);

    public BlockPredicate(@NotNull BlockTypeFilter blocks) {
        this(blocks, null, null);
    }

    public BlockPredicate(Block ... blocks) {
        this(new BlockTypeFilter.Blocks(blocks));
    }

    public BlockPredicate(@NotNull PropertiesPredicate state) {
        this(null, state, null);
    }

    public BlockPredicate(@NotNull CompoundBinaryTag nbt) {
        this(null, null, nbt);
    }

    @Override
    public boolean test(@NotNull Block block) {
        if (this.blocks != null && !this.blocks.test(block)) {
            return false;
        }
        if (this.state != null && !this.state.test(block)) {
            return false;
        }
        return this.nbt == null || Objects.equals(this.nbt, BlockUtils.extractClientNbt(block));
    }
}

