/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.metadata.animal.tameable;

import net.minestom.server.color.DyeColor;
import net.minestom.server.component.DataComponent;
import net.minestom.server.component.DataComponents;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.MetadataDef;
import net.minestom.server.entity.MetadataHolder;
import net.minestom.server.entity.metadata.animal.tameable.TameableAnimalMeta;
import net.minestom.server.network.NetworkBuffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CatMeta
extends TameableAnimalMeta {
    private static final DyeColor[] DYE_VALUES = DyeColor.values();

    public CatMeta(@NotNull Entity entity, @NotNull MetadataHolder metadata) {
        super(entity, metadata);
    }

    @Deprecated
    @NotNull
    public Variant getVariant() {
        return this.metadata.get(MetadataDef.Cat.VARIANT);
    }

    @Deprecated
    public void setVariant(@NotNull Variant value) {
        this.metadata.set(MetadataDef.Cat.VARIANT, value);
    }

    public boolean isLying() {
        return this.metadata.get(MetadataDef.Cat.IS_LYING);
    }

    public void setLying(boolean value) {
        this.metadata.set(MetadataDef.Cat.IS_LYING, value);
    }

    public boolean isRelaxed() {
        return this.metadata.get(MetadataDef.Cat.IS_RELAXED);
    }

    public void setRelaxed(boolean value) {
        this.metadata.set(MetadataDef.Cat.IS_RELAXED, value);
    }

    @Deprecated
    @NotNull
    public DyeColor getCollarColor() {
        return DYE_VALUES[this.metadata.get(MetadataDef.Cat.COLLAR_COLOR)];
    }

    @Deprecated
    public void setCollarColor(@NotNull DyeColor value) {
        this.metadata.set(MetadataDef.Cat.COLLAR_COLOR, value.ordinal());
    }

    @Override
    @Nullable
    protected <T> T get(@NotNull DataComponent<T> component) {
        if (component == DataComponents.CAT_VARIANT) {
            return (T)((Object)this.getVariant());
        }
        if (component == DataComponents.CAT_COLLAR) {
            return (T)((Object)this.getCollarColor());
        }
        return super.get(component);
    }

    @Override
    protected <T> void set(@NotNull DataComponent<T> component, @NotNull T value) {
        if (component == DataComponents.CAT_VARIANT) {
            this.setVariant((Variant)((Object)value));
        } else if (component == DataComponents.CAT_COLLAR) {
            this.setCollarColor((DyeColor)((Object)value));
        } else {
            super.set(component, value);
        }
    }

    public static enum Variant {
        TABBY,
        BLACK,
        RED,
        SIAMESE,
        BRITISH_SHORTHAIR,
        CALICO,
        PERSIAN,
        RAGDOLL,
        WHITE,
        JELLIE,
        ALL_BLACK;

        public static final NetworkBuffer.Type<Variant> NETWORK_TYPE;

        static {
            NETWORK_TYPE = NetworkBuffer.Enum(Variant.class);
        }
    }
}

