/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.codec;

import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.KeybindComponent;
import net.kyori.adventure.text.NBTComponent;
import net.kyori.adventure.text.ScoreComponent;
import net.kyori.adventure.text.SelectorComponent;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.ShadowColor;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.StyleBuilderApplicable;
import net.kyori.adventure.text.format.StyleGetter;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.util.ARGBLike;
import net.kyori.adventure.util.Index;
import net.minestom.server.codec.Codec;
import net.minestom.server.codec.CodecImpl;
import net.minestom.server.codec.Result;
import net.minestom.server.codec.StructCodec;
import net.minestom.server.codec.Transcoder;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ComponentCodecs {
    private static final Codec<Component> COMPONENT_FORWARD = Codec.ForwardRef(() -> Codec.COMPONENT);
    public static final Codec<TextColor> TEXT_COLOR = new Codec<TextColor>(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        @NotNull
        public <D> Result<TextColor> decode(@NotNull Transcoder<D> coder, @NotNull D value) {
            String colorString;
            Result<String> colorResult = coder.getString(value);
            if (!(colorResult instanceof Result.Ok)) return colorResult.cast();
            Result.Ok ok = (Result.Ok)colorResult;
            try {
                String string;
                colorString = string = (String)ok.value();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            if (colorString.startsWith("#")) {
                TextColor color = TextColor.fromHexString((String)colorString);
                if (color != null) return new Result.Ok<TextColor>(color);
                return new Result.Error<TextColor>("Unknown color: " + colorString);
            }
            NamedTextColor namedColor = (NamedTextColor)NamedTextColor.NAMES.value((Object)colorString);
            if (namedColor != null) return new Result.Ok<NamedTextColor>(namedColor);
            return new Result.Error<TextColor>("Unknown color: " + colorString);
        }

        @Override
        @NotNull
        public <D> Result<D> encode(@NotNull Transcoder<D> coder, @Nullable TextColor value) {
            if (value == null) {
                return new Result.Error("null");
            }
            if (value instanceof NamedTextColor) {
                NamedTextColor namedColor = (NamedTextColor)value;
                return new Result.Ok<D>(coder.createString(namedColor.toString()));
            }
            return new Result.Ok<D>(coder.createString(value.asHexString()));
        }
    };
    public static final Codec<ShadowColor> SHADOW_COLOR = Codec.INT.transform(ShadowColor::shadowColor, ShadowColor::value);
    public static final Codec<ClickEvent> CLICK_EVENT = Codec.Enum(ClickEvent.Action.class).unionType(ComponentCodecs::clickEventCodec, ClickEvent::action);
    private static final StructCodec<ClickEvent> CLICK_EVENT_OPEN_URL = StructCodec.struct("url", Codec.STRING, ClickEvent::value, ClickEvent::openUrl);
    private static final StructCodec<ClickEvent> CLICK_EVENT_OPEN_FILE = StructCodec.struct("path", Codec.STRING, ClickEvent::value, ClickEvent::openFile);
    private static final StructCodec<ClickEvent> CLICK_EVENT_RUN_COMMAND = StructCodec.struct("command", Codec.STRING, ClickEvent::value, ClickEvent::openUrl);
    private static final StructCodec<ClickEvent> CLICK_EVENT_SUGGEST_COMMAND = StructCodec.struct("command", Codec.STRING, ClickEvent::value, ClickEvent::openUrl);
    private static final StructCodec<ClickEvent> CLICK_EVENT_CHANGE_PAGE = StructCodec.struct("url", new CodecImpl.IntAsStringImpl(), ClickEvent::value, ClickEvent::openUrl);
    private static final StructCodec<ClickEvent> CLICK_EVENT_COPY_TO_CLIPBOARD = StructCodec.struct("value", Codec.STRING, ClickEvent::value, ClickEvent::openUrl);
    private static final Codec<HoverEvent.Action<?>> HOVER_EVENT_ACTION = Codec.STRING.transform(arg_0 -> ((Index)HoverEvent.Action.NAMES).value(arg_0), HoverEvent.Action::toString);
    private static final Codec<HoverEvent<?>> HOVER_EVENT = HOVER_EVENT_ACTION.unionType(ComponentCodecs::hoverEventCodec, HoverEvent::action);
    private static final StructCodec<HoverEvent<?>> SHOW_TEXT = StructCodec.struct("value", COMPONENT_FORWARD, hoverEvent -> (Component)hoverEvent.value(), HoverEvent::showText);
    private static final StructCodec<HoverEvent<?>> SHOW_ITEM = StructCodec.struct("id", Codec.KEY, hoverEvent -> ((HoverEvent.ShowItem)hoverEvent.value()).item(), "count", Codec.INT.optional(1), hoverEvent -> ((HoverEvent.ShowItem)hoverEvent.value()).count(), HoverEvent::showItem);
    private static final StructCodec<HoverEvent<?>> SHOW_ENTITY = StructCodec.struct("id", Codec.KEY, hoverEvent -> ((HoverEvent.ShowEntity)hoverEvent.value()).type(), "uuid", Codec.UUID_COERCED, hoverEvent -> ((HoverEvent.ShowEntity)hoverEvent.value()).id(), "name", COMPONENT_FORWARD, hoverEvent -> ((HoverEvent.ShowEntity)hoverEvent.value()).name(), HoverEvent::showEntity);
    public static final StructCodec<Style> STYLE = StructCodec.struct("color", TEXT_COLOR.optional(), Style::color, "shadow_color", SHADOW_COLOR.optional(), StyleGetter::shadowColor, "bold", Codec.BOOLEAN.optional(), s -> ComponentCodecs.stateToBool(s.decoration(TextDecoration.BOLD)), "italic", Codec.BOOLEAN.optional(), s -> ComponentCodecs.stateToBool(s.decoration(TextDecoration.ITALIC)), "underlined", Codec.BOOLEAN.optional(), s -> ComponentCodecs.stateToBool(s.decoration(TextDecoration.UNDERLINED)), "strikethrough", Codec.BOOLEAN.optional(), s -> ComponentCodecs.stateToBool(s.decoration(TextDecoration.STRIKETHROUGH)), "obfuscated", Codec.BOOLEAN.optional(), s -> ComponentCodecs.stateToBool(s.decoration(TextDecoration.OBFUSCATED)), "click_event", CLICK_EVENT.optional(), Style::clickEvent, "hover_event", HOVER_EVENT.optional(), Style::hoverEvent, "insertion", Codec.STRING.optional(), Style::insertion, "font", Codec.KEY.optional(), Style::font, (color, shadowColor, bold, italic, underlined, strikethrough, obfuscated, clickEvent, hoverEvent, insertion, font) -> ((Style.Builder)Style.style().color(color).shadowColor((ARGBLike)shadowColor)).decoration(TextDecoration.BOLD, TextDecoration.State.byBoolean((Boolean)bold)).decoration(TextDecoration.ITALIC, TextDecoration.State.byBoolean((Boolean)italic)).decoration(TextDecoration.UNDERLINED, TextDecoration.State.byBoolean((Boolean)underlined)).decoration(TextDecoration.STRIKETHROUGH, TextDecoration.State.byBoolean((Boolean)strikethrough)).decoration(TextDecoration.OBFUSCATED, TextDecoration.State.byBoolean((Boolean)obfuscated)).clickEvent(clickEvent).hoverEvent((HoverEventSource)hoverEvent).insertion(insertion).font(font).build());
    private static final StructCodec<TextComponent> TEXT_CONTENT = StructCodec.struct("text", Codec.STRING, TextComponent::content, Component::text);
    private static final StructCodec<TranslatableComponent> TRANSLATABLE_CONTENT = StructCodec.struct("translate", Codec.STRING, TranslatableComponent::key, "fallback", Codec.STRING.optional(), TranslatableComponent::fallback, "with", COMPONENT_FORWARD.list().optional(List.of()), TranslatableComponent::args, (x$0, x$1, x$2) -> Component.translatable((String)x$0, (String)x$1, (List)x$2, (StyleBuilderApplicable[])new StyleBuilderApplicable[0]));
    private static final StructCodec<ScoreComponent> SCORE_INNER_CONTENT = StructCodec.struct("name", Codec.STRING, ScoreComponent::name, "objective", Codec.STRING, ScoreComponent::objective, Component::score);
    private static final StructCodec<ScoreComponent> SCORE_CONTENT = StructCodec.struct("score", SCORE_INNER_CONTENT, component -> component, component -> component);
    private static final StructCodec<SelectorComponent> SELECTOR_CONTENT = StructCodec.struct("selector", Codec.STRING, SelectorComponent::pattern, "separator", COMPONENT_FORWARD.optional(), SelectorComponent::separator, Component::selector);
    private static final StructCodec<KeybindComponent> KEYBIND_CONTENT = StructCodec.struct("keybind", Codec.STRING, component -> component.keybind(), Component::keybind);
    private static final StructCodec<NBTComponent<?, ?>> NBT_CONTENT = new StructCodec<NBTComponent<?, ?>>(){

        @Override
        @NotNull
        public <D> Result<NBTComponent<?, ?>> decodeFromMap(@NotNull Transcoder<D> coder, @NotNull Transcoder.MapLike<D> map) {
            return new Result.Error("NBTComponent not yet supported");
        }

        @Override
        @NotNull
        public <D> Result<D> encodeToMap(@NotNull Transcoder<D> coder, @NotNull NBTComponent<?, ?> value, @NotNull Transcoder.MapBuilder<D> map) {
            return new Result.Error("NBTComponent not yet supported");
        }
    };
    private static final Codec<Component> INNER_COMPONENT = Codec.Recursive(componentCodec -> {
        final Codec componentListCodec = componentCodec.list();
        final StructCodec<List> childrenCodec = StructCodec.struct("extra", componentListCodec.optional(List.of()), children -> children, children -> children);
        return new Codec<Component>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            @NotNull
            public <D> Result<Component> decode(@NotNull Transcoder<D> coder, @NotNull D value) {
                String maybeType;
                Transcoder.MapLike map;
                Result<String> stringResult = coder.getString(value);
                if (stringResult instanceof Result.Ok) {
                    String string;
                    Result.Ok ok = (Result.Ok)stringResult;
                    String string2 = string = (String)ok.value();
                    return new Result.Ok<TextComponent>(Component.text((String)string2));
                }
                Result listResult = componentListCodec.decode(coder, value);
                if (listResult instanceof Result.Ok) {
                    List list;
                    Result.Ok string2 = (Result.Ok)listResult;
                    List list2 = list = (List)string2.value();
                    return new Result.Ok<Component>(Component.empty().children(list2));
                }
                Result<Transcoder.MapLike<D>> mapResult = coder.getMap(value);
                if (!(mapResult instanceof Result.Ok)) return mapResult.cast();
                Result.Ok ok = (Result.Ok)mapResult;
                try {
                    Transcoder.MapLike mapLike;
                    map = mapLike = (Transcoder.MapLike)ok.value();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                String string = maybeType = (String)map.getValue("type").map(coder::getString).orElse(null);
                int n = 0;
                Result.Error<Component> baseResult = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"text", "translatable", "score", "selector", "keybind", "nbt"}, (Object)string, n)) {
                    case 0 -> TEXT_CONTENT.decodeFromMap(coder, map);
                    case 1 -> TRANSLATABLE_CONTENT.decodeFromMap(coder, map);
                    case 2 -> SCORE_CONTENT.decodeFromMap(coder, map);
                    case 3 -> SELECTOR_CONTENT.decodeFromMap(coder, map);
                    case 4 -> KEYBIND_CONTENT.decodeFromMap(coder, map);
                    case 5 -> NBT_CONTENT.decodeFromMap(coder, map);
                    default -> {
                        Result<TextComponent> textResult = TEXT_CONTENT.decodeFromMap(coder, map);
                        if (textResult instanceof Result.Ok) {
                            yield textResult;
                        }
                        Result<TranslatableComponent> translatableResult = TRANSLATABLE_CONTENT.decodeFromMap(coder, map);
                        if (translatableResult instanceof Result.Ok) {
                            yield translatableResult;
                        }
                        Result<ScoreComponent> scoreResult = SCORE_CONTENT.decodeFromMap(coder, map);
                        if (scoreResult instanceof Result.Ok) {
                            yield scoreResult;
                        }
                        Result<SelectorComponent> selectorResult = SELECTOR_CONTENT.decodeFromMap(coder, map);
                        if (selectorResult instanceof Result.Ok) {
                            yield selectorResult;
                        }
                        Result<KeybindComponent> keybindResult = KEYBIND_CONTENT.decodeFromMap(coder, map);
                        if (keybindResult instanceof Result.Ok) {
                            yield keybindResult;
                        }
                        Result<NBTComponent<?, ?>> nbtResult = NBT_CONTENT.decodeFromMap(coder, map);
                        if (nbtResult instanceof Result.Ok) {
                            yield nbtResult;
                        }
                        yield new Result.Error<Component>("Unable to determine component type");
                    }
                };
                return baseResult.map(base -> childrenCodec.decodeFromMap(coder, map).mapResult(arg_0 -> ((Component)base).children(arg_0))).map(style -> STYLE.decodeFromMap(coder, map).mapResult(arg_0 -> ((Component)style).style(arg_0)));
            }

            @Override
            @NotNull
            public <D> Result<D> encode(@NotNull Transcoder<D> coder, @Nullable Component value) {
                if (value == null) {
                    return new Result.Error("null");
                }
                Transcoder.MapBuilder map = coder.createMap();
                Component component = value;
                Objects.requireNonNull(component);
                Component component2 = component;
                int n = 0;
                Result<Object> baseResult = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TextComponent.class, TranslatableComponent.class, ScoreComponent.class, SelectorComponent.class, KeybindComponent.class, NBTComponent.class}, (Object)component2, n)) {
                    case 0 -> {
                        TextComponent textComponent = (TextComponent)component2;
                        yield TEXT_CONTENT.encodeToMap(coder, textComponent, map);
                    }
                    case 1 -> {
                        TranslatableComponent translatableComponent = (TranslatableComponent)component2;
                        yield TRANSLATABLE_CONTENT.encodeToMap(coder, translatableComponent, map);
                    }
                    case 2 -> {
                        ScoreComponent scoreComponent = (ScoreComponent)component2;
                        yield SCORE_CONTENT.encodeToMap(coder, scoreComponent, map);
                    }
                    case 3 -> {
                        SelectorComponent selectorComponent = (SelectorComponent)component2;
                        yield SELECTOR_CONTENT.encodeToMap(coder, selectorComponent, map);
                    }
                    case 4 -> {
                        KeybindComponent keybindComponent = (KeybindComponent)component2;
                        yield KEYBIND_CONTENT.encodeToMap(coder, keybindComponent, map);
                    }
                    case 5 -> {
                        NBTComponent nbtComponent = (NBTComponent)component2;
                        yield NBT_CONTENT.encodeToMap(coder, nbtComponent, map);
                    }
                    default -> new Result.Error("Unknown component type: " + String.valueOf(value.getClass()));
                };
                return baseResult.map(ignored -> childrenCodec.encodeToMap(coder, value.children(), map)).map(ignored -> STYLE.encodeToMap(coder, value.style(), map)).mapResult(ignored -> map.build());
            }
        };
    });
    public static final Codec<Component> COMPONENT = new Codec<Component>(){

        @Override
        @NotNull
        public <D> Result<Component> decode(@NotNull Transcoder<D> coder, @NotNull D value) {
            return INNER_COMPONENT.decode(coder, value);
        }

        @Override
        @NotNull
        public <D> Result<D> encode(@NotNull Transcoder<D> coder, @Nullable Component value) {
            if (value == null) {
                return new Result.Error("null");
            }
            if (value instanceof TextComponent) {
                TextComponent text = (TextComponent)value;
                if (value.children().isEmpty() && value.style().isEmpty()) {
                    return new Result.Ok<D>(coder.createString(text.content()));
                }
            }
            return INNER_COMPONENT.encode(coder, value);
        }
    };

    @Nullable
    private static final Boolean stateToBool(@NotNull TextDecoration.State state) {
        return switch (state) {
            default -> throw new MatchException(null, null);
            case TextDecoration.State.NOT_SET -> null;
            case TextDecoration.State.FALSE -> false;
            case TextDecoration.State.TRUE -> true;
        };
    }

    private static StructCodec<ClickEvent> clickEventCodec(@NotNull ClickEvent.Action action) {
        return switch (action) {
            default -> throw new MatchException(null, null);
            case ClickEvent.Action.OPEN_URL -> CLICK_EVENT_OPEN_URL;
            case ClickEvent.Action.OPEN_FILE -> CLICK_EVENT_OPEN_FILE;
            case ClickEvent.Action.RUN_COMMAND -> CLICK_EVENT_RUN_COMMAND;
            case ClickEvent.Action.SUGGEST_COMMAND -> CLICK_EVENT_SUGGEST_COMMAND;
            case ClickEvent.Action.CHANGE_PAGE -> CLICK_EVENT_CHANGE_PAGE;
            case ClickEvent.Action.COPY_TO_CLIPBOARD -> CLICK_EVENT_COPY_TO_CLIPBOARD;
        };
    }

    private static StructCodec<HoverEvent<?>> hoverEventCodec(@NotNull HoverEvent.Action<?> action) {
        if (action == HoverEvent.Action.SHOW_TEXT) {
            return SHOW_TEXT;
        }
        if (action == HoverEvent.Action.SHOW_ITEM) {
            return SHOW_ITEM;
        }
        if (action == HoverEvent.Action.SHOW_ENTITY) {
            return SHOW_ENTITY;
        }
        throw new IllegalStateException("Unknown hover event action: " + String.valueOf(action));
    }
}

