/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item.component;

import java.util.List;
import net.minestom.server.codec.Codec;
import net.minestom.server.codec.StructCodec;
import net.minestom.server.instance.block.Block;
import net.minestom.server.instance.block.predicate.BlockTypeFilter;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.NetworkBufferTemplate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record Tool(@NotNull List<Rule> rules, float defaultMiningSpeed, int damagePerBlock, boolean canDestroyBlocksInCreative) {
    public static final float DEFAULT_MINING_SPEED = 1.0f;
    public static final int DEFAULT_DAMAGE_PER_BLOCK = 1;
    public static final NetworkBuffer.Type<Tool> NETWORK_TYPE = NetworkBufferTemplate.template(Rule.NETWORK_TYPE.list(Short.MAX_VALUE), Tool::rules, NetworkBuffer.FLOAT, Tool::defaultMiningSpeed, NetworkBuffer.VAR_INT, Tool::damagePerBlock, NetworkBuffer.BOOLEAN, Tool::canDestroyBlocksInCreative, Tool::new);
    public static final Codec<Tool> CODEC = StructCodec.struct("rules", Rule.CODEC.list(), Tool::rules, "default_mining_speed", Codec.FLOAT.optional(Float.valueOf(1.0f)), Tool::defaultMiningSpeed, "damage_per_block", Codec.INT.optional(1), Tool::damagePerBlock, "can_destroy_blocks_in_creative", Codec.BOOLEAN.optional(true), Tool::canDestroyBlocksInCreative, Tool::new);

    public boolean isCorrectForDrops(@NotNull Block block) {
        for (Rule rule : this.rules) {
            if (rule.correctForDrops == null || !rule.blocks.test(block)) continue;
            return rule.correctForDrops;
        }
        return false;
    }

    public float getSpeed(@NotNull Block block) {
        for (Rule rule : this.rules) {
            if (rule.speed == null || !rule.blocks.test(block)) continue;
            return rule.speed.floatValue();
        }
        return this.defaultMiningSpeed;
    }

    public record Rule(@NotNull BlockTypeFilter blocks, @Nullable Float speed, @Nullable Boolean correctForDrops) {
        public static final NetworkBuffer.Type<Rule> NETWORK_TYPE = NetworkBufferTemplate.template(BlockTypeFilter.NETWORK_TYPE, Rule::blocks, NetworkBuffer.FLOAT.optional(), Rule::speed, NetworkBuffer.BOOLEAN.optional(), Rule::correctForDrops, Rule::new);
        public static final Codec<Rule> CODEC = StructCodec.struct("blocks", BlockTypeFilter.CODEC, Rule::blocks, "speed", Codec.FLOAT.optional(), Rule::speed, "correct_for_drops", Codec.BOOLEAN.optional(), Rule::correctForDrops, Rule::new);
    }
}

