/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.pathfinding.generators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.OptionalDouble;
import java.util.Set;
import net.minestom.server.collision.BoundingBox;
import net.minestom.server.collision.CollisionUtils;
import net.minestom.server.collision.PhysicsResult;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Pos;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.entity.pathfinding.PNode;
import net.minestom.server.entity.pathfinding.generators.NodeGenerator;
import net.minestom.server.instance.block.Block;
import org.jetbrains.annotations.NotNull;

public class PreciseGroundNodeGenerator
implements NodeGenerator {
    private PNode tempNode = null;
    private static final int MAX_FALL_DISTANCE = 5;

    @Override
    @NotNull
    public Collection<? extends PNode> getWalkable(@NotNull Block.Getter getter, @NotNull Set<PNode> visited, @NotNull PNode current, @NotNull Point goal, @NotNull BoundingBox boundingBox) {
        ArrayList<PNode> nearby = new ArrayList<PNode>();
        this.tempNode = new PNode(0.0, 0.0, 0.0, 0.0, 0.0, current);
        int stepSize = (int)Math.max(Math.floor(boundingBox.width() / 2.0), 1.0);
        if (stepSize < 1) {
            stepSize = 1;
        }
        for (int x = -stepSize; x <= stepSize; ++x) {
            for (int z = -stepSize; z <= stepSize; ++z) {
                double floorPointZ;
                double floorPointY;
                if (x == 0 && z == 0) continue;
                double cost = Math.sqrt(x * x + z * z) * 0.98;
                double floorPointX = (double)current.blockX() + 0.5 + (double)x;
                OptionalDouble optionalFloorPointY = this.gravitySnap(getter, floorPointX, floorPointY = current.y(), floorPointZ = (double)current.blockZ() + 0.5 + (double)z, boundingBox, 5.0);
                if (optionalFloorPointY.isEmpty()) continue;
                floorPointY = optionalFloorPointY.getAsDouble();
                Vec floorPoint = new Vec(floorPointX, floorPointY, floorPointZ);
                PNode nodeWalk = this.createWalk(getter, floorPoint, boundingBox, cost, current, goal, visited);
                if (nodeWalk != null && !visited.contains(nodeWalk)) {
                    nearby.add(nodeWalk);
                }
                for (int i = 1; i <= 1; ++i) {
                    PNode nodeJump;
                    Point jumpPoint = new Vec((double)current.blockX() + 0.5 + (double)x, current.y() + (double)i, (double)current.blockZ() + 0.5 + (double)z);
                    OptionalDouble jumpPointY = this.gravitySnap(getter, jumpPoint.x(), jumpPoint.y(), jumpPoint.z(), boundingBox, 5.0);
                    if (jumpPointY.isEmpty() || floorPoint.sameBlock(jumpPoint = jumpPoint.withY(jumpPointY.getAsDouble())) || (nodeJump = this.createJump(getter, jumpPoint, boundingBox, cost + 0.8, current, goal, visited)) == null || visited.contains(nodeJump)) continue;
                    nearby.add(nodeJump);
                }
            }
        }
        return nearby;
    }

    private PNode createWalk(Block.Getter getter, Point point, BoundingBox boundingBox, double cost, PNode start, Point goal, Set<PNode> closed) {
        OptionalDouble snapped = this.gravitySnap(getter, point.x(), point.y(), point.z(), boundingBox, 5.0);
        if (snapped.isPresent()) {
            Vec snappedPoint = new Vec(point.x(), snapped.getAsDouble(), point.z());
            PNode n = this.newNode(start, cost, snappedPoint, goal);
            if (closed.contains(n)) {
                return null;
            }
            if (Math.abs(snappedPoint.y() - start.y()) > 1.0E-6 && snappedPoint.y() < start.y()) {
                if (start.y() - snappedPoint.y() > 5.0) {
                    return null;
                }
                if (!this.canMoveTowards(getter, new Vec(start.x(), start.y(), start.z()), snappedPoint.withY(start.y()), boundingBox)) {
                    return null;
                }
                n.setType(PNode.Type.FALL);
            } else if (!this.canMoveTowards(getter, new Vec(start.x(), start.y(), start.z()), snappedPoint, boundingBox)) {
                return null;
            }
            return n;
        }
        return null;
    }

    private PNode createJump(Block.Getter getter, Point point, BoundingBox boundingBox, double cost, PNode start, Point goal, Set<PNode> closed) {
        if (Math.abs(point.y() - start.y()) < 1.0E-6) {
            return null;
        }
        if (point.y() - start.y() > 2.0) {
            return null;
        }
        if (point.blockX() != start.blockX() && point.blockZ() != start.blockZ()) {
            return null;
        }
        PNode n = this.newNode(start, cost, point, goal);
        if (closed.contains(n)) {
            return null;
        }
        if (this.pointInvalid(getter, point, boundingBox)) {
            return null;
        }
        if (this.pointInvalid(getter, new Vec(start.x(), start.y() + 1.0, start.z()), boundingBox)) {
            return null;
        }
        n.setType(PNode.Type.JUMP);
        return n;
    }

    private PNode newNode(PNode current, double cost, Point point, Point goal) {
        this.tempNode.setG(current.g() + cost);
        this.tempNode.setH(this.heuristic(point, goal));
        this.tempNode.setPoint(point.x(), point.y(), point.z());
        PNode newNode = this.tempNode;
        this.tempNode = new PNode(0.0, 0.0, 0.0, 0.0, 0.0, PNode.Type.WALK, current);
        return newNode;
    }

    @Override
    public boolean hasGravitySnap() {
        return true;
    }

    @Override
    @NotNull
    public OptionalDouble gravitySnap(@NotNull Block.Getter getter, double pointOrgX, double pointOrgY, double pointOrgZ, @NotNull BoundingBox boundingBox, double maxFall) {
        double pointX = (double)((int)Math.floor(pointOrgX)) + 0.5;
        double pointZ = (double)((int)Math.floor(pointOrgZ)) + 0.5;
        PhysicsResult res = CollisionUtils.handlePhysics(getter, boundingBox, new Pos(pointX, pointOrgY, pointZ), new Vec(0.0, -5.0, 0.0), null, true);
        return OptionalDouble.of(res.newPosition().y());
    }

    @Override
    public boolean canMoveTowards(@NotNull Block.Getter getter, @NotNull Point startOrg, @NotNull Point endOrg, @NotNull BoundingBox boundingBox) {
        Point end = endOrg.add(0.0, 1.0E-6, 0.0);
        Point start = startOrg.add(0.0, 1.0E-6, 0.0);
        Point diff = end.sub(start);
        PhysicsResult res = CollisionUtils.handlePhysics(getter, boundingBox, Pos.fromPoint(start), Vec.fromPoint(diff), null, false);
        return !res.collisionZ() && !res.collisionY() && !res.collisionX();
    }
}

