/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.metadata.animal;

import net.kyori.adventure.key.Key;
import net.minestom.server.codec.Codec;
import net.minestom.server.codec.StructCodec;
import net.minestom.server.entity.metadata.animal.PigVariantImpl;
import net.minestom.server.entity.metadata.animal.PigVariants;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.registry.Registries;
import net.minestom.server.registry.Registry;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public sealed interface PigVariant
extends PigVariants
permits PigVariantImpl {
    @NotNull
    public static final Codec<PigVariant> REGISTRY_CODEC = StructCodec.struct("model", Model.CODEC.optional(Model.NORMAL), PigVariant::model, "asset_id", Codec.KEY, PigVariant::assetId, PigVariantImpl::new);
    @NotNull
    public static final NetworkBuffer.Type<DynamicRegistry.Key<PigVariant>> NETWORK_TYPE = NetworkBuffer.RegistryKey(Registries::pigVariant, false);
    @NotNull
    public static final Codec<DynamicRegistry.Key<PigVariant>> CODEC = Codec.RegistryKey(Registries::pigVariant);

    @ApiStatus.Internal
    public static DynamicRegistry<PigVariant> createDefaultRegistry() {
        return DynamicRegistry.create("minecraft:pig_variant", REGISTRY_CODEC, Registry.Resource.PIG_VARIANTS);
    }

    @NotNull
    public static PigVariant create(@NotNull Model model, @NotNull Key assetId) {
        return new PigVariantImpl(model, assetId);
    }

    @NotNull
    public Model model();

    @NotNull
    public Key assetId();

    public static enum Model {
        NORMAL,
        COLD;

        public static final Codec<Model> CODEC;

        static {
            CODEC = Codec.Enum(Model.class);
        }
    }
}

