/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.metadata.animal;

import net.kyori.adventure.key.Key;
import net.minestom.server.codec.Codec;
import net.minestom.server.codec.StructCodec;
import net.minestom.server.entity.metadata.animal.ChickenVariantImpl;
import net.minestom.server.entity.metadata.animal.ChickenVariants;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.registry.Registries;
import net.minestom.server.registry.Registry;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public sealed interface ChickenVariant
extends ChickenVariants
permits ChickenVariantImpl {
    public static final Codec<ChickenVariant> REGISTRY_CODEC = StructCodec.struct("model", Model.CODEC.optional(Model.NORMAL), ChickenVariant::model, "asset_id", Codec.KEY, ChickenVariant::assetId, ChickenVariantImpl::new);
    @NotNull
    public static final NetworkBuffer.Type<DynamicRegistry.Key<ChickenVariant>> NETWORK_TYPE = new NetworkBuffer.Type<DynamicRegistry.Key<ChickenVariant>>(){
        private final NetworkBuffer.Type<DynamicRegistry.Key<ChickenVariant>> idCodec = NetworkBuffer.RegistryKey(Registries::chickenVariant, false);

        @Override
        public void write(@NotNull NetworkBuffer buffer, DynamicRegistry.Key<ChickenVariant> value) {
            int id;
            Registries registries = buffer.registries();
            int n = id = registries != null ? registries.chickenVariant().getId(value) : -1;
            if (id == -1) {
                buffer.write(NetworkBuffer.BOOLEAN, false);
                buffer.write(NetworkBuffer.KEY, value.key());
            } else {
                buffer.write(NetworkBuffer.BOOLEAN, true);
                buffer.write(NetworkBuffer.VAR_INT, id);
            }
        }

        @Override
        public DynamicRegistry.Key<ChickenVariant> read(@NotNull NetworkBuffer buffer) {
            if (buffer.read(NetworkBuffer.BOOLEAN).booleanValue()) {
                return buffer.read(this.idCodec);
            }
            return DynamicRegistry.Key.of(buffer.read(NetworkBuffer.KEY));
        }
    };
    @NotNull
    public static final Codec<DynamicRegistry.Key<ChickenVariant>> CODEC = Codec.RegistryKey(Registries::chickenVariant);

    @NotNull
    public static ChickenVariant create(@NotNull Model model, @NotNull Key assetId) {
        return new ChickenVariantImpl(model, assetId);
    }

    @ApiStatus.Internal
    public static DynamicRegistry<ChickenVariant> createDefaultRegistry() {
        return DynamicRegistry.create("minecraft:chicken_variant", REGISTRY_CODEC, Registry.Resource.CHICKEN_VARIANTS);
    }

    @NotNull
    public Model model();

    @NotNull
    public Key assetId();

    public static enum Model {
        NORMAL,
        COLD;

        public static final Codec<Model> CODEC;

        static {
            CODEC = Codec.Enum(Model.class);
        }
    }
}

