package net.minestom.server.recipe;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.kyori.adventure.key.Key;
import net.minestom.server.codec.Codec;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.StaticProtocolObject;
import org.jetbrains.annotations.NotNull;

/**
 * AUTOGENERATED by GenericEnumGenerator
 */
public enum RecipeBookCategory implements StaticProtocolObject {
    CRAFTING_BUILDING_BLOCKS(Key.key("minecraft:crafting_building_blocks")),

    CRAFTING_REDSTONE(Key.key("minecraft:crafting_redstone")),

    CRAFTING_EQUIPMENT(Key.key("minecraft:crafting_equipment")),

    CRAFTING_MISC(Key.key("minecraft:crafting_misc")),

    FURNACE_FOOD(Key.key("minecraft:furnace_food")),

    FURNACE_BLOCKS(Key.key("minecraft:furnace_blocks")),

    FURNACE_MISC(Key.key("minecraft:furnace_misc")),

    BLAST_FURNACE_BLOCKS(Key.key("minecraft:blast_furnace_blocks")),

    BLAST_FURNACE_MISC(Key.key("minecraft:blast_furnace_misc")),

    SMOKER_FOOD(Key.key("minecraft:smoker_food")),

    STONECUTTER(Key.key("minecraft:stonecutter")),

    SMITHING(Key.key("minecraft:smithing")),

    CAMPFIRE(Key.key("minecraft:campfire"));

    private static final Map<Key, RecipeBookCategory> BY_KEY = Arrays.stream(values()).collect(Collectors.toMap(RecipeBookCategory::key, Function.identity()));

    public static final NetworkBuffer.Type<RecipeBookCategory> NETWORK_TYPE = NetworkBuffer.Enum(RecipeBookCategory.class);

    public static final Codec<RecipeBookCategory> CODEC = Codec.KEY.transform(BY_KEY::get, RecipeBookCategory::key);

    private final Key key;

    RecipeBookCategory(@NotNull Key key) {
        this.key = key;
    }

    @NotNull
    @Override
    public Key key() {
        return this.key;
    }

    @Override
    public int id() {
        return this.ordinal();
    }
}
