/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.recipe.display;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.kyori.adventure.key.Key;
import net.minestom.server.codec.Codec;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.StaticProtocolObject;
import org.jetbrains.annotations.NotNull;

public enum RecipeDisplayType implements StaticProtocolObject
{
    CRAFTING_SHAPELESS(Key.key((String)"minecraft:crafting_shapeless")),
    CRAFTING_SHAPED(Key.key((String)"minecraft:crafting_shaped")),
    FURNACE(Key.key((String)"minecraft:furnace")),
    STONECUTTER(Key.key((String)"minecraft:stonecutter")),
    SMITHING(Key.key((String)"minecraft:smithing"));

    private static final Map<Key, RecipeDisplayType> BY_KEY;
    public static final NetworkBuffer.Type<RecipeDisplayType> NETWORK_TYPE;
    public static final Codec<RecipeDisplayType> CODEC;
    private final Key key;

    private RecipeDisplayType(Key key) {
        this.key = key;
    }

    @Override
    @NotNull
    public Key key() {
        return this.key;
    }

    @Override
    public int id() {
        return this.ordinal();
    }

    static {
        BY_KEY = Arrays.stream(RecipeDisplayType.values()).collect(Collectors.toMap(RecipeDisplayType::key, Function.identity()));
        NETWORK_TYPE = NetworkBuffer.Enum(RecipeDisplayType.class);
        CODEC = Codec.KEY.transform(BY_KEY::get, RecipeDisplayType::key);
    }
}

