/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.listener;

import net.minestom.server.ServerFlag;
import net.minestom.server.collision.BoundingBox;
import net.minestom.server.coordinate.Pos;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.LivingEntity;
import net.minestom.server.entity.Player;
import net.minestom.server.entity.attribute.Attribute;
import net.minestom.server.event.EventDispatcher;
import net.minestom.server.event.entity.EntityAttackEvent;
import net.minestom.server.event.player.PlayerEntityInteractEvent;
import net.minestom.server.network.packet.client.play.ClientInteractEntityPacket;

public class UseEntityListener {
    public static void useEntityListener(ClientInteractEntityPacket packet, Player player) {
        ClientInteractEntityPacket.Type type;
        Entity entity = player.getInstance().getEntityById(packet.targetId());
        if (entity == null || !entity.isViewer(player)) {
            return;
        }
        if (ServerFlag.ENFORCE_INTERACTION_LIMIT) {
            double maxDistanceSquared = Math.pow(player.getAttributeValue(Attribute.ENTITY_INTERACTION_RANGE) + 1.0, 2.0);
            double distSquared = UseEntityListener.getDistSquared(player, entity);
            if (distSquared > maxDistanceSquared) {
                return;
            }
        }
        if ((type = packet.type()) instanceof ClientInteractEntityPacket.Attack) {
            if (entity instanceof LivingEntity && ((LivingEntity)entity).isDead()) {
                return;
            }
            EventDispatcher.call(new EntityAttackEvent(player, entity));
        } else if (type instanceof ClientInteractEntityPacket.InteractAt) {
            ClientInteractEntityPacket.InteractAt interactAt = (ClientInteractEntityPacket.InteractAt)type;
            Vec interactPosition = new Vec(interactAt.targetX(), interactAt.targetY(), interactAt.targetZ());
            EventDispatcher.call(new PlayerEntityInteractEvent(player, entity, interactAt.hand(), interactPosition));
        }
    }

    private static double getDistSquared(Player player, Entity entity) {
        Pos playerPos = player.getPosition();
        double eyeHeight = player.getEyeHeight();
        double px = playerPos.x();
        double py = playerPos.y() + eyeHeight;
        double pz = playerPos.z();
        BoundingBox box = entity.getBoundingBox();
        double halfWidth = box.width() / 2.0;
        double height = box.height();
        Pos entityPos = entity.getPosition();
        double minX = entityPos.x() - halfWidth;
        double maxX = entityPos.x() + halfWidth;
        double minY = entityPos.y();
        double maxY = entityPos.y() + height;
        double minZ = entityPos.z() - halfWidth;
        double maxZ = entityPos.z() + halfWidth;
        double clampX = Math.max(minX, Math.min(px, maxX));
        double clampY = Math.max(minY, Math.min(py, maxY));
        double clampZ = Math.max(minZ, Math.min(pz, maxZ));
        double dx = px - clampX;
        double dy = py - clampY;
        double dz = pz - clampZ;
        return dx * dx + dy * dy + dz * dz;
    }
}

