/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.coordinate;

import net.minestom.server.coordinate.Point;
import org.jetbrains.annotations.NotNull;

public final class ChunkRange {
    public static int chunksCount(int range) {
        if (range < 0) {
            throw new IllegalArgumentException("Range cannot be negative");
        }
        int square = range * 2 + 1;
        return square * square;
    }

    public static void chunksInRangeDiffering(int newChunkX, int newChunkZ, int oldChunkX, int oldChunkZ, int range, @NotNull ChunkConsumer callback) {
        for (int x = newChunkX - range; x <= newChunkX + range; ++x) {
            for (int z = newChunkZ - range; z <= newChunkZ + range; ++z) {
                if (Math.abs(x - oldChunkX) <= range && Math.abs(z - oldChunkZ) <= range) continue;
                callback.accept(x, z);
            }
        }
    }

    public static void chunksInRangeDiffering(int newChunkX, int newChunkZ, int oldChunkX, int oldChunkZ, int range, @NotNull ChunkConsumer newCallback, @NotNull ChunkConsumer oldCallback) {
        ChunkRange.chunksInRangeDiffering(newChunkX, newChunkZ, oldChunkX, oldChunkZ, range, newCallback);
        ChunkRange.chunksInRangeDiffering(oldChunkX, oldChunkZ, newChunkX, newChunkZ, range, oldCallback);
    }

    public static void chunksInRange(int chunkX, int chunkZ, int range, ChunkConsumer consumer) {
        consumer.accept(chunkX, chunkZ);
        block6: for (int id = 1; id < (range * 2 + 1) * (range * 2 + 1); ++id) {
            int index = id - 1;
            int radius = (int)Math.floor((Math.sqrt((double)index + 1.0) - 1.0) / 2.0) + 1;
            int p = 8 * radius * (radius - 1) / 2;
            int en = radius * 2;
            int a = (1 + index - p) % (radius * 8);
            switch (a / (radius * 2)) {
                case 0: {
                    consumer.accept(a - radius + chunkX, -radius + chunkZ);
                    continue block6;
                }
                case 1: {
                    consumer.accept(radius + chunkX, a % en - radius + chunkZ);
                    continue block6;
                }
                case 2: {
                    consumer.accept(radius - a % en + chunkX, radius + chunkZ);
                    continue block6;
                }
                case 3: {
                    consumer.accept(-radius + chunkX, radius - a % en + chunkZ);
                    continue block6;
                }
                default: {
                    throw new IllegalStateException("unreachable");
                }
            }
        }
    }

    public static void chunksInRange(@NotNull Point point, int range, ChunkConsumer consumer) {
        ChunkRange.chunksInRange(point.chunkX(), point.chunkZ(), range, consumer);
    }

    @FunctionalInterface
    public static interface ChunkConsumer {
        public void accept(int var1, int var2);
    }
}

