/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.utils.time;

import java.time.Duration;
import java.time.temporal.TemporalUnit;
import org.jetbrains.annotations.NotNull;

public final class Cooldown {
    private final Duration duration;
    private long lastUpdate;

    public Cooldown(Duration duration) {
        this.duration = duration;
        this.lastUpdate = System.currentTimeMillis();
    }

    public Duration getDuration() {
        return this.duration;
    }

    public void refreshLastUpdate(long lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public boolean isReady(long time) {
        return !Cooldown.hasCooldown(time, this.lastUpdate, this.duration);
    }

    public static boolean hasCooldown(long currentTime, long lastUpdate, @NotNull TemporalUnit temporalUnit, long cooldown) {
        return Cooldown.hasCooldown(currentTime, lastUpdate, Duration.of(cooldown, temporalUnit));
    }

    public static boolean hasCooldown(long currentTime, long lastUpdate, @NotNull Duration duration) {
        long cooldownMs = duration.toMillis();
        return currentTime - lastUpdate < cooldownMs;
    }

    public static boolean hasCooldown(long lastUpdate, @NotNull TemporalUnit temporalUnit, int cooldown) {
        return Cooldown.hasCooldown(System.currentTimeMillis(), lastUpdate, temporalUnit, cooldown);
    }
}

