/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.utils.entity;

import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMaps;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import net.minestom.server.MinecraftServer;
import net.minestom.server.command.CommandSender;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Pos;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.EntityType;
import net.minestom.server.entity.GameMode;
import net.minestom.server.entity.Player;
import net.minestom.server.instance.Instance;
import net.minestom.server.network.ConnectionManager;
import net.minestom.server.utils.MathUtils;
import net.minestom.server.utils.Range;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityFinder {
    private static final ConnectionManager CONNECTION_MANAGER = MinecraftServer.getConnectionManager();
    private TargetSelector targetSelector;
    private EntitySort entitySort = EntitySort.ARBITRARY;
    private Point startPosition;
    private Float dx;
    private Float dy;
    private Float dz;
    private Range.Int distance;
    private Integer limit;
    private final ToggleableMap<EntityType> entityTypes = new ToggleableMap();
    private String constantName;
    private UUID constantUuid;
    private final ToggleableMap<String> names = new ToggleableMap();
    private final ToggleableMap<UUID> uuids = new ToggleableMap();
    private final ToggleableMap<GameMode> gameModes = new ToggleableMap();
    private Range.Int level;

    public EntityFinder setTargetSelector(@NotNull TargetSelector targetSelector) {
        this.targetSelector = targetSelector;
        return this;
    }

    public EntityFinder setEntitySort(@NotNull EntitySort entitySort) {
        this.entitySort = entitySort;
        return this;
    }

    public EntityFinder setStartPosition(@NotNull Point startPosition) {
        this.startPosition = startPosition;
        return this;
    }

    public EntityFinder setDistance(@NotNull Range.Int distance) {
        this.distance = distance;
        return this;
    }

    public EntityFinder setLimit(int limit) {
        this.limit = limit;
        return this;
    }

    public EntityFinder setLevel(@NotNull Range.Int level) {
        this.level = level;
        return this;
    }

    public EntityFinder setEntity(@NotNull EntityType entityType, @NotNull ToggleableType toggleableType) {
        this.entityTypes.put(entityType, toggleableType.getValue());
        return this;
    }

    public EntityFinder setConstantName(@NotNull String constantName) {
        this.constantName = constantName;
        return this;
    }

    public EntityFinder setConstantUuid(@NotNull UUID constantUuid) {
        this.constantUuid = constantUuid;
        return this;
    }

    public EntityFinder setName(@NotNull String name, @NotNull ToggleableType toggleableType) {
        this.names.put(name, toggleableType.getValue());
        return this;
    }

    public EntityFinder setUuid(@NotNull UUID uuid, @NotNull ToggleableType toggleableType) {
        this.uuids.put(uuid, toggleableType.getValue());
        return this;
    }

    public EntityFinder setGameMode(@NotNull GameMode gameMode, @NotNull ToggleableType toggleableType) {
        this.gameModes.put((Object)gameMode, toggleableType.getValue());
        return this;
    }

    public EntityFinder setDifference(float dx, float dy, float dz) {
        this.dx = Float.valueOf(dx);
        this.dy = Float.valueOf(dy);
        this.dz = Float.valueOf(dz);
        return this;
    }

    @NotNull
    public @NotNull List<@NotNull Entity> find(@Nullable Instance instance, @Nullable Entity self) {
        if (this.targetSelector == TargetSelector.MINESTOM_USERNAME) {
            Check.notNull(this.constantName, "The player name should not be null when searching for it");
            Player player = MinecraftServer.getConnectionManager().getOnlinePlayerByUsername(this.constantName);
            return player != null ? List.of(player) : List.of();
        }
        if (this.targetSelector == TargetSelector.MINESTOM_UUID) {
            Check.notNull(this.constantUuid, "The UUID should not be null when searching for it");
            Check.notNull(instance, "The instance should not be null when searching by UUID");
            Entity entity2 = instance.getEntityByUuid(this.constantUuid);
            return entity2 != null ? List.of(entity2) : List.of();
        }
        Object pos = this.startPosition != null ? this.startPosition : (self != null ? self.getPosition() : Vec.ZERO);
        List<Entity> result = EntityFinder.findTarget(instance, this.targetSelector, (Point)pos, self);
        if (result.isEmpty()) {
            return result;
        }
        if (this.distance != null) {
            int minDistance = this.distance.min();
            int maxDistance = this.distance.max();
            result = result.stream().filter(arg_0 -> EntityFinder.lambda$find$0((Point)pos, minDistance, maxDistance, arg_0)).toList();
        }
        if (this.dx != null || this.dy != null || this.dz != null) {
            result = result.stream().filter(arg_0 -> this.lambda$find$1((Point)pos, arg_0)).toList();
        }
        if (!this.entityTypes.isEmpty()) {
            result = result.stream().filter(entity -> EntityFinder.filterToggleableMap(entity.getEntityType(), this.entityTypes)).toList();
        }
        if (!this.gameModes.isEmpty()) {
            result = result.stream().filter(Player.class::isInstance).filter(entity -> EntityFinder.filterToggleableMap(((Player)entity).getGameMode(), this.gameModes)).toList();
        }
        if (this.level != null) {
            int minLevel = this.level.min();
            int maxLevel = this.level.max();
            result = result.stream().filter(Player.class::isInstance).filter(entity -> MathUtils.isBetween(((Player)entity).getLevel(), minLevel, maxLevel)).toList();
        }
        if (!this.names.isEmpty()) {
            result = result.stream().filter(Player.class::isInstance).filter(entity -> EntityFinder.filterToggleableMap(((Player)entity).getUsername(), this.names)).toList();
        }
        if (!this.uuids.isEmpty()) {
            result = result.stream().filter(entity -> EntityFinder.filterToggleableMap(entity.getUuid(), this.uuids)).toList();
        }
        if (this.entitySort != EntitySort.ARBITRARY || this.limit != null) {
            result = result.stream().sorted((arg_0, arg_1) -> this.lambda$find$7((Point)pos, arg_0, arg_1)).limit(this.limit != null ? (long)this.limit.intValue() : Integer.MAX_VALUE).toList();
            if (this.entitySort == EntitySort.RANDOM) {
                Collections.shuffle(result);
            }
        }
        return result;
    }

    @NotNull
    public @NotNull List<@NotNull Entity> find(@NotNull CommandSender sender) {
        List<Entity> list;
        if (sender instanceof Player) {
            Player player = (Player)sender;
            list = this.find(player.getInstance(), player);
        } else {
            list = this.find(null, null);
        }
        return list;
    }

    @Nullable
    public Player findFirstPlayer(@Nullable Instance instance, @Nullable Entity self) {
        List<Entity> entities = this.find(instance, self);
        for (Entity entity : entities) {
            if (!(entity instanceof Player)) continue;
            Player player = (Player)entity;
            return player;
        }
        return null;
    }

    @Nullable
    public Player findFirstPlayer(@NotNull CommandSender sender) {
        Player player;
        if (sender instanceof Player) {
            Player player2 = (Player)sender;
            player = this.findFirstPlayer(player2.getInstance(), player2);
        } else {
            player = this.findFirstPlayer(null, null);
        }
        return player;
    }

    @Nullable
    public Entity findFirstEntity(@Nullable Instance instance, @Nullable Entity self) {
        List<Entity> entities = this.find(instance, self);
        return entities.isEmpty() ? null : entities.get(0);
    }

    @Nullable
    public Entity findFirstEntity(@NotNull CommandSender sender) {
        Entity entity;
        if (sender instanceof Player) {
            Player player = (Player)sender;
            entity = this.findFirstEntity(player.getInstance(), player);
        } else {
            entity = this.findFirstEntity(null, null);
        }
        return entity;
    }

    @NotNull
    private static @NotNull List<@NotNull Entity> findTarget(@Nullable Instance instance, @NotNull TargetSelector targetSelector, @NotNull Point startPosition, @Nullable Entity self) {
        Collection<Player> players;
        Collection<Player> collection = players = instance != null ? instance.getPlayers() : CONNECTION_MANAGER.getOnlinePlayers();
        if (targetSelector == TargetSelector.NEAREST_PLAYER) {
            return players.stream().min(Comparator.comparingDouble(p -> p.getPosition().distanceSquared(startPosition))).map(Collections::singletonList).orElse(List.of());
        }
        if (targetSelector == TargetSelector.NEAREST_ENTITY) {
            List<Entity> entities = EntityFinder.findTarget(instance, TargetSelector.ALL_ENTITIES, startPosition, self);
            return entities.stream().min(Comparator.comparingDouble(p -> p.getPosition().distanceSquared(startPosition))).map(Collections::singletonList).orElse(List.of());
        }
        if (targetSelector == TargetSelector.RANDOM_PLAYER) {
            int index = ThreadLocalRandom.current().nextInt(players.size());
            Player player = players.stream().skip(index).findFirst().orElseThrow();
            return List.of(player);
        }
        if (targetSelector == TargetSelector.ALL_PLAYERS) {
            return List.copyOf(players);
        }
        if (targetSelector == TargetSelector.ALL_ENTITIES) {
            if (instance != null) {
                return List.copyOf(instance.getEntities());
            }
            Set<Instance> instances = MinecraftServer.getInstanceManager().getInstances();
            ArrayList<Entity> entities = new ArrayList<Entity>();
            for (Instance inst : instances) {
                entities.addAll(inst.getEntities());
            }
            return entities;
        }
        if (targetSelector == TargetSelector.SELF) {
            return self != null ? List.of(self) : List.of();
        }
        throw new IllegalStateException("Weird thing happened: " + String.valueOf((Object)targetSelector));
    }

    private static <T> boolean filterToggleableMap(@NotNull T value, @NotNull ToggleableMap<T> map) {
        for (Object2BooleanMap.Entry entry : Object2BooleanMaps.fastIterable(map)) {
            if (entry.getBooleanValue() == Objects.equals(value, entry.getKey())) continue;
            return false;
        }
        return true;
    }

    private /* synthetic */ int lambda$find$7(Point pos, Entity ent1, Entity ent2) {
        return switch (this.entitySort.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0, 3 -> 1;
            case 1 -> {
                if (pos.distanceSquared(ent1.getPosition()) > pos.distanceSquared(ent2.getPosition())) {
                    yield 1;
                }
                yield 0;
            }
            case 2 -> pos.distanceSquared(ent1.getPosition()) < pos.distanceSquared(ent2.getPosition()) ? 1 : 0;
        };
    }

    private /* synthetic */ boolean lambda$find$1(Point pos, Entity entity) {
        Pos entityPosition = entity.getPosition();
        if (this.dx != null && !MathUtils.isBetweenUnordered(entityPosition.x(), pos.x(), (double)this.dx.floatValue())) {
            return false;
        }
        if (this.dy != null && !MathUtils.isBetweenUnordered(entityPosition.y(), pos.y(), (double)this.dy.floatValue())) {
            return false;
        }
        return this.dz == null || MathUtils.isBetweenUnordered(entityPosition.z(), pos.z(), (double)this.dz.floatValue());
    }

    private static /* synthetic */ boolean lambda$find$0(Point pos, int minDistance, int maxDistance, Entity entity) {
        return MathUtils.isBetween(entity.getPosition().distanceSquared(pos), (double)(minDistance * minDistance), (double)(maxDistance * maxDistance));
    }

    public static enum EntitySort {
        ARBITRARY,
        FURTHEST,
        NEAREST,
        RANDOM;

    }

    private static class ToggleableMap<T>
    extends Object2BooleanOpenHashMap<T> {
        private ToggleableMap() {
        }
    }

    public static enum TargetSelector {
        NEAREST_PLAYER,
        RANDOM_PLAYER,
        ALL_PLAYERS,
        ALL_ENTITIES,
        SELF,
        MINESTOM_USERNAME,
        MINESTOM_UUID,
        NEAREST_ENTITY;

    }

    public static enum ToggleableType {
        INCLUDE(true),
        EXCLUDE(false);

        private final boolean value;

        private ToggleableType(boolean value) {
            this.value = value;
        }

        public boolean getValue() {
            return this.value;
        }
    }
}

