/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item.armor;

import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.minestom.server.codec.Codec;
import net.minestom.server.codec.StructCodec;
import net.minestom.server.item.armor.TrimPatternImpl;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.NetworkBufferTemplate;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.registry.Holder;
import net.minestom.server.registry.ProtocolObject;
import net.minestom.server.registry.Registries;
import net.minestom.server.registry.Registry;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public sealed interface TrimPattern
extends ProtocolObject
permits TrimPatternImpl {
    @NotNull
    public static final NetworkBuffer.Type<TrimPattern> REGISTRY_NETWORK_TYPE = NetworkBufferTemplate.template(NetworkBuffer.KEY, TrimPattern::assetId, NetworkBuffer.COMPONENT, TrimPattern::description, NetworkBuffer.BOOLEAN, TrimPattern::isDecal, TrimPattern::create);
    @NotNull
    public static final Codec<TrimPattern> REGISTRY_CODEC = StructCodec.struct("asset_id", Codec.KEY, TrimPattern::assetId, "description", Codec.COMPONENT, TrimPattern::description, "decal", Codec.BOOLEAN, TrimPattern::isDecal, TrimPattern::create);
    @NotNull
    public static final NetworkBuffer.Type<Holder<TrimPattern>> NETWORK_TYPE = Holder.networkType(Registries::trimPattern, REGISTRY_NETWORK_TYPE);
    @NotNull
    public static final Codec<Holder<TrimPattern>> CODEC = Holder.codec(Registries::trimPattern, REGISTRY_CODEC);

    @NotNull
    public static TrimPattern create(@NotNull Key assetId, @NotNull Component description, boolean decal) {
        return new TrimPatternImpl(assetId, description, decal);
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    @ApiStatus.Internal
    @NotNull
    public static DynamicRegistry<TrimPattern> createDefaultRegistry() {
        return DynamicRegistry.create("minecraft:trim_pattern", REGISTRY_CODEC, Registry.Resource.TRIM_PATTERNS);
    }

    @NotNull
    public Key assetId();

    @NotNull
    public Component description();

    public boolean isDecal();

    public static final class Builder {
        private Key assetId;
        private Component description;
        private boolean decal;

        private Builder() {
        }

        @Contract(value="_ -> this", pure=true)
        @NotNull
        public Builder assetId(@NotNull String assetId) {
            return this.assetId(Key.key((String)assetId));
        }

        @Contract(value="_ -> this", pure=true)
        @NotNull
        public Builder assetId(@NotNull Key assetId) {
            this.assetId = assetId;
            return this;
        }

        @Contract(value="_ -> this", pure=true)
        @NotNull
        public Builder description(@NotNull Component description) {
            this.description = description;
            return this;
        }

        @Contract(value="_ -> this", pure=true)
        @NotNull
        public Builder decal(boolean decal) {
            this.decal = decal;
            return this;
        }

        @Contract(pure=true)
        @NotNull
        public TrimPattern build() {
            return new TrimPatternImpl(this.assetId, this.description, this.decal);
        }
    }
}

