/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.component;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.IntFunction;
import net.minestom.server.codec.Codec;
import net.minestom.server.codec.Result;
import net.minestom.server.codec.Transcoder;
import net.minestom.server.component.DataComponent;
import net.minestom.server.component.DataComponentMap;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

record DataComponentMapImpl(@NotNull Int2ObjectMap<Object> components) implements DataComponentMap
{
    private static final char REMOVAL_PREFIX = '!';

    @Override
    public boolean isEmpty() {
        return this.components.isEmpty();
    }

    @Override
    public boolean has(@NotNull DataComponent<?> component) {
        return this.components.containsKey(component.id()) && this.components.get(component.id()) != null;
    }

    @Override
    @Nullable
    public <T> T get(@NotNull DataComponent<T> component) {
        return (T)this.components.get(component.id());
    }

    @Override
    public boolean has(@NotNull DataComponentMap prototype, @NotNull DataComponent<?> component) {
        if (this.components.containsKey(component.id())) {
            return this.components.get(component.id()) != null;
        }
        return prototype.has(component);
    }

    @Override
    @Nullable
    public <T> T get(@NotNull DataComponentMap prototype, @NotNull DataComponent<T> component) {
        if (this.components.containsKey(component.id())) {
            return (T)this.components.get(component.id());
        }
        return prototype.get(component);
    }

    @Override
    @NotNull
    public <T> DataComponentMap set(@NotNull DataComponent<T> component, @NotNull T value) {
        Int2ObjectArrayMap newComponents = new Int2ObjectArrayMap(this.components);
        newComponents.put(component.id(), value);
        return new DataComponentMapImpl((Int2ObjectMap<Object>)newComponents);
    }

    @Override
    @NotNull
    public DataComponentMap remove(@NotNull DataComponent<?> component) {
        Int2ObjectArrayMap newComponents = new Int2ObjectArrayMap(this.components);
        newComponents.put(component.id(), null);
        return new DataComponentMapImpl((Int2ObjectMap<Object>)newComponents);
    }

    @Override
    @NotNull
    public Collection<DataComponent.Value> entrySet() {
        if (this.components.isEmpty()) {
            return List.of();
        }
        ArrayList<DataComponent.Value> entries = new ArrayList<DataComponent.Value>(this.components.size());
        for (Int2ObjectMap.Entry entry : this.components.int2ObjectEntrySet()) {
            entries.add(new DataComponent.Value(DataComponent.fromId(entry.getIntKey()), entry.getValue()));
        }
        return entries;
    }

    @Override
    @NotNull
    public DataComponentMap.Builder toBuilder() {
        return new BuilderImpl((Int2ObjectMap<Object>)new Int2ObjectArrayMap(this.components));
    }

    @Override
    @NotNull
    public DataComponentMap.PatchBuilder toPatchBuilder() {
        return new PatchBuilderImpl((Int2ObjectMap<Object>)new Int2ObjectArrayMap(this.components));
    }

    record BuilderImpl(@NotNull Int2ObjectMap<Object> components) implements DataComponentMap.Builder
    {
        @Override
        public boolean has(@NotNull DataComponent<?> component) {
            return this.components.get(component.id()) != null;
        }

        @Override
        @Nullable
        public <T> T get(@NotNull DataComponent<T> component) {
            return (T)this.components.get(component.id());
        }

        @Override
        @NotNull
        public <T> DataComponentMap.Builder set(@NotNull DataComponent<T> component, @NotNull T value) {
            this.components.put(component.id(), value);
            return this;
        }

        @Override
        @NotNull
        public DataComponentMap build() {
            return new DataComponentMapImpl((Int2ObjectMap<Object>)new Int2ObjectArrayMap(this.components));
        }
    }

    record PatchBuilderImpl(@NotNull Int2ObjectMap<Object> components) implements DataComponentMap.PatchBuilder
    {
        @Override
        public boolean has(@NotNull DataComponent<?> component) {
            return this.components.get(component.id()) != null;
        }

        @Override
        @Nullable
        public <T> T get(@NotNull DataComponent<T> component) {
            return (T)this.components.get(component.id());
        }

        @Override
        @NotNull
        public <T> DataComponentMap.PatchBuilder set(@NotNull DataComponent<T> component, @NotNull T value) {
            this.components.put(component.id(), value);
            return this;
        }

        @Override
        @NotNull
        public DataComponentMap.PatchBuilder remove(@NotNull DataComponent<?> component) {
            this.components.put(component.id(), null);
            return this;
        }

        @Override
        @NotNull
        public DataComponentMap build() {
            return new DataComponentMapImpl((Int2ObjectMap<Object>)new Int2ObjectArrayMap(this.components));
        }
    }

    record CodecImpl(@NotNull IntFunction<DataComponent<?>> idToType, @NotNull Function<String, DataComponent<?>> nameToType, boolean isPatch) implements Codec<DataComponentMap>
    {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        @NotNull
        public <D> Result<DataComponentMap> decode(@NotNull Transcoder<D> coder, @NotNull D value) {
            Transcoder.MapLike map;
            Result<Transcoder.MapLike<D>> mapResult = coder.getMap(value);
            if (!(mapResult instanceof Result.Ok)) return mapResult.cast();
            Result.Ok ok = (Result.Ok)mapResult;
            try {
                Transcoder.MapLike mapLike = (Transcoder.MapLike)ok.value();
                map = mapLike;
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            if (map.isEmpty()) {
                return new Result.Ok<DataComponentMap>(DataComponentMap.EMPTY);
            }
            Int2ObjectArrayMap patch = new Int2ObjectArrayMap(map.size());
            block8: for (String key : map.keys()) {
                String string;
                Result.Error error;
                Result result;
                DataComponent<?> type;
                boolean remove = false;
                if (!key.isEmpty() && key.charAt(0) == '!') {
                    key = key.substring(1);
                    remove = true;
                }
                if ((type = this.nameToType.apply(key)) == null) {
                    return new Result.Error<DataComponentMap>("unknown data component: " + key);
                }
                if (remove) {
                    if (!this.isPatch) continue;
                    patch.put(type.id(), null);
                    continue;
                }
                Objects.requireNonNull(map.getValue(key).map(v -> type.decode(coder, v)));
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Result.Ok.class, Result.Error.class}, result, n)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        ok = (Result.Ok)result;
                        Result.Error componentData = error = ok.value();
                        patch.put(type.id(), (Object)componentData);
                        continue block8;
                    }
                    case 1: 
                }
                error = (Result.Error)result;
                String message = string = error.message();
                return new Result.Error<DataComponentMap>(type.name() + ": " + message);
            }
            return new Result.Ok<DataComponentMap>(new DataComponentMapImpl((Int2ObjectMap<Object>)patch));
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        @NotNull
        public <D> Result<D> encode(@NotNull Transcoder<D> coder, @Nullable DataComponentMap value) {
            Result.Error error;
            Result result;
            DataComponent<?> type;
            DataComponentMapImpl patch = (DataComponentMapImpl)value;
            Transcoder.MapBuilder<D> map = coder.createMap();
            ObjectIterator objectIterator = patch.components.int2ObjectEntrySet().iterator();
            block7: while (true) {
                if (!objectIterator.hasNext()) {
                    return new Result.Ok<D>(map.build());
                }
                Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)objectIterator.next();
                type = this.idToType.apply(entry.getIntKey());
                if (type == null) {
                    return new Result.Error("unknown data component id: " + entry.getIntKey());
                }
                if (entry.getValue() == null) {
                    if (!this.isPatch) continue;
                    map.put("!" + type.name(), coder.createMap().build());
                    continue;
                }
                Objects.requireNonNull(type.encode(coder, entry.getValue()));
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Result.Ok.class, Result.Error.class}, (Object)result, n)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        Result.Ok ok = (Result.Ok)result;
                        Result.Error componentValue = error = ok.value();
                        map.put(type.name(), (D)componentValue);
                        continue block7;
                    }
                    case 1: 
                }
                break;
            }
            error = (Result.Error)result;
            try {
                String string;
                String message = string = error.message();
                return new Result.Error(type.name() + ": " + message);
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        }
    }

    record NetworkTypeImpl(@NotNull IntFunction<DataComponent<?>> idToType, boolean isPatch, boolean isTrusted) implements NetworkBuffer.Type<DataComponentMap>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, DataComponentMap value) {
            DataComponentMapImpl patch = (DataComponentMapImpl)value;
            int added = 0;
            for (Object o : patch.components.values()) {
                if (o == null) continue;
                ++added;
            }
            buffer.write(NetworkBuffer.VAR_INT, added);
            if (this.isPatch) {
                buffer.write(NetworkBuffer.VAR_INT, patch.components.size() - added);
            }
            for (Int2ObjectMap.Entry entry : patch.components.int2ObjectEntrySet()) {
                if (entry.getValue() == null) continue;
                buffer.write(NetworkBuffer.VAR_INT, entry.getIntKey());
                DataComponent<?> type = this.idToType.apply(entry.getIntKey());
                assert (type != null);
                if (this.isTrusted) {
                    type.write(buffer, entry.getValue());
                    continue;
                }
                byte[] componentData = NetworkBuffer.makeArray(b -> type.write((NetworkBuffer)b, entry.getValue()), buffer.registries());
                buffer.write(NetworkBuffer.BYTE_ARRAY, componentData);
            }
            if (this.isPatch) {
                for (Int2ObjectMap.Entry entry : patch.components.int2ObjectEntrySet()) {
                    if (entry.getValue() != null) continue;
                    buffer.write(NetworkBuffer.VAR_INT, entry.getIntKey());
                }
            }
        }

        @Override
        public DataComponentMap read(@NotNull NetworkBuffer buffer) {
            int id;
            int i;
            int added = buffer.read(NetworkBuffer.VAR_INT);
            int removed = this.isPatch ? buffer.read(NetworkBuffer.VAR_INT) : 0;
            Check.stateCondition(added + removed > 256, "Data component map too large: {0}", added + removed);
            Int2ObjectArrayMap patch = new Int2ObjectArrayMap(added + removed);
            for (i = 0; i < added; ++i) {
                id = buffer.read(NetworkBuffer.VAR_INT);
                DataComponent<?> type = this.idToType.apply(id);
                Check.notNull(type, "Unknown component: {0}", id);
                if (this.isTrusted) {
                    patch.put(type.id(), type.read(buffer));
                    continue;
                }
                byte[] array = buffer.read(NetworkBuffer.BYTE_ARRAY);
                NetworkBuffer tempBuffer = NetworkBuffer.wrap(array, 0, array.length);
                patch.put(type.id(), type.read(tempBuffer));
            }
            for (i = 0; i < removed; ++i) {
                id = buffer.read(NetworkBuffer.VAR_INT);
                patch.put(id, null);
            }
            return new DataComponentMapImpl((Int2ObjectMap<Object>)patch);
        }
    }
}

