/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item.component;

import java.util.HashMap;
import java.util.Map;
import net.minestom.server.codec.Codec;
import net.minestom.server.codec.StructCodec;
import org.jetbrains.annotations.NotNull;

public record MapDecorations(@NotNull Map<String, Entry> decorations) {
    public static final Codec<MapDecorations> CODEC = Codec.STRING.mapValue(Entry.CODEC).transform(MapDecorations::new, MapDecorations::decorations);

    public MapDecorations(@NotNull Map<String, Entry> decorations) {
        decorations = Map.copyOf(decorations);
    }

    @NotNull
    public MapDecorations with(@NotNull String id, @NotNull String type, double x, double z, float rotation) {
        return this.with(id, new Entry(type, x, z, rotation));
    }

    @NotNull
    public MapDecorations with(@NotNull String id, @NotNull Entry entry) {
        HashMap<String, Entry> newDecorations = new HashMap<String, Entry>(this.decorations);
        newDecorations.put(id, entry);
        return new MapDecorations(newDecorations);
    }

    @NotNull
    public MapDecorations remove(@NotNull String id) {
        HashMap<String, Entry> newDecorations = new HashMap<String, Entry>(this.decorations);
        newDecorations.remove(id);
        return new MapDecorations(newDecorations);
    }

    public record Entry(@NotNull String type, double x, double z, float rotation) {
        public static final Codec<Entry> CODEC = StructCodec.struct("type", Codec.STRING, Entry::type, "x", Codec.DOUBLE, Entry::x, "z", Codec.DOUBLE, Entry::z, "rotation", Codec.FLOAT, Entry::rotation, Entry::new);
    }
}

