/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.utils.block;

import java.util.Objects;
import net.minestom.server.MinecraftServer;
import net.minestom.server.component.DataComponents;
import net.minestom.server.coordinate.Pos;
import net.minestom.server.entity.GameMode;
import net.minestom.server.entity.Player;
import net.minestom.server.entity.attribute.Attribute;
import net.minestom.server.gamedata.tags.Tag;
import net.minestom.server.instance.Instance;
import net.minestom.server.instance.block.Block;
import net.minestom.server.item.ItemStack;
import net.minestom.server.item.component.Tool;
import net.minestom.server.potion.PotionEffect;
import net.minestom.server.registry.Registry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockBreakCalculation {
    public static final int UNBREAKABLE = -1;
    private static final Tag WATER_TAG = Objects.requireNonNull(MinecraftServer.getTagManager().getTag(Tag.BasicType.FLUIDS, "minecraft:water"));
    private static final Tag SWORD_TAG = Objects.requireNonNull(MinecraftServer.getTagManager().getTag(Tag.BasicType.ITEMS, "minecraft:swords"));

    public static int breakTicks(@NotNull Block block, @NotNull Player player) {
        float speedMultiplier;
        if (player.getGameMode() == GameMode.CREATIVE) {
            return 0;
        }
        Registry.BlockEntry registry = block.registry();
        double blockHardness = registry.hardness();
        if (blockHardness == -1.0) {
            return -1;
        }
        ItemStack item = player.getItemInMainHand();
        if ((block.id() == Block.BAMBOO.id() || block.id() == Block.BAMBOO_SAPLING.id()) && SWORD_TAG.contains(item.material().key())) {
            return 0;
        }
        Tool tool = item.get(DataComponents.TOOL);
        boolean isBestTool = BlockBreakCalculation.canBreakBlock(tool, block);
        if (isBestTool) {
            speedMultiplier = BlockBreakCalculation.getMiningSpeed(tool, block);
            if (speedMultiplier > 1.0f) {
                speedMultiplier += (float)player.getAttributeValue(Attribute.MINING_EFFICIENCY);
            }
        } else {
            speedMultiplier = 1.0f;
        }
        if (player.hasEffect(PotionEffect.HASTE) || player.hasEffect(PotionEffect.CONDUIT_POWER)) {
            speedMultiplier *= BlockBreakCalculation.getHasteMultiplier(player);
        }
        if (player.hasEffect(PotionEffect.MINING_FATIGUE)) {
            speedMultiplier *= BlockBreakCalculation.getMiningFatigueMultiplier(player);
        }
        speedMultiplier *= (float)player.getAttributeValue(Attribute.BLOCK_BREAK_SPEED);
        if (BlockBreakCalculation.isInWater(player)) {
            speedMultiplier *= (float)player.getAttributeValue(Attribute.SUBMERGED_MINING_SPEED);
        }
        if (!player.isOnGround()) {
            speedMultiplier /= 5.0f;
        }
        double damage = (double)speedMultiplier / blockHardness;
        damage = isBestTool ? (damage /= 30.0) : (damage /= 100.0);
        if (damage >= 1.0) {
            return 0;
        }
        return (int)Math.ceil(1.0 / damage);
    }

    private static boolean isInWater(@NotNull Player player) {
        Pos pos = player.getPosition();
        Instance instance = player.getInstance();
        double eyeY = pos.y() + player.getEyeHeight();
        int x = pos.blockX();
        int y = (int)Math.floor(eyeY);
        int z = pos.blockZ();
        Pos eye = player.getPosition().add(0.0, player.getEyeHeight(), 0.0);
        Block block = instance.getBlock(eye);
        if (!WATER_TAG.contains(block.key())) {
            return false;
        }
        float fluidHeight = BlockBreakCalculation.getFluidHeight(player.getInstance(), x, y, z, block);
        return eyeY < (double)((float)y + fluidHeight);
    }

    private static float getFluidHeight(Instance instance, int x, int y, int z, Block block) {
        int level;
        Block blockAbove = instance.getBlock(x, y + 1, z);
        if (blockAbove.id() == block.id()) {
            return 1.0f;
        }
        String levelString = block.getProperty("level");
        if (levelString == null) {
            return 1.0f;
        }
        try {
            level = Integer.parseInt(levelString);
        }
        catch (Throwable ignored) {
            return 1.0f;
        }
        if (level >= 8) {
            level = 0;
        }
        return (float)(8 - level) / 9.0f;
    }

    private static float getMiningFatigueMultiplier(@NotNull Player player) {
        int level = player.getEffectLevel(PotionEffect.MINING_FATIGUE) + 1;
        return switch (level) {
            case 0 -> 0.0f;
            case 1 -> 0.3f;
            case 2 -> 0.09f;
            case 3 -> 0.027f;
            default -> 0.0081f;
        };
    }

    private static float getHasteMultiplier(@NotNull Player player) {
        float level = Math.max(player.getEffectLevel(PotionEffect.HASTE), player.getEffectLevel(PotionEffect.CONDUIT_POWER)) + 1;
        return 1.0f + 0.2f * level;
    }

    private static float getMiningSpeed(@Nullable Tool tool, @NotNull Block block) {
        if (tool == null) {
            return 1.0f;
        }
        return tool.getSpeed(block);
    }

    private static boolean canBreakBlock(@Nullable Tool tool, @NotNull Block block) {
        return !block.registry().requiresTool() || BlockBreakCalculation.isEffective(tool, block);
    }

    private static boolean isEffective(@Nullable Tool tool, @NotNull Block block) {
        return tool != null && tool.isCorrectForDrops(block);
    }
}

