/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play.data;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.minestom.server.coordinate.CoordConversion;
import net.minestom.server.coordinate.Point;
import net.minestom.server.instance.block.Block;
import net.minestom.server.instance.heightmap.Heightmap;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.Registry;
import net.minestom.server.utils.block.BlockUtils;
import org.jetbrains.annotations.NotNull;

public record ChunkData(@NotNull Map<Heightmap.Type, long[]> heightmaps, byte @NotNull [] data, @NotNull Map<Integer, Block> blockEntities) {
    public static final NetworkBuffer.Type<ChunkData> NETWORK_TYPE = new NetworkBuffer.Type<ChunkData>(){
        private static final NetworkBuffer.Type<Map<Heightmap.Type, long[]>> HEIGHTMAPS = Heightmap.Type.NETWORK_TYPE.mapValue(NetworkBuffer.LONG_ARRAY, Heightmap.Type.values().length);

        @Override
        public void write(@NotNull NetworkBuffer buffer, ChunkData value) {
            buffer.write(HEIGHTMAPS, value.heightmaps);
            buffer.write(NetworkBuffer.BYTE_ARRAY, value.data);
            buffer.write(NetworkBuffer.VAR_INT, value.blockEntities.size());
            for (Map.Entry<Integer, Block> entry : value.blockEntities.entrySet()) {
                int index = entry.getKey();
                Block block = entry.getValue();
                Registry.BlockEntry registry = block.registry();
                Point point = CoordConversion.chunkBlockIndexGetGlobal(index, 0, 0);
                buffer.write(NetworkBuffer.BYTE, (byte)((point.blockX() & 0xF) << 4 | point.blockZ() & 0xF));
                buffer.write(NetworkBuffer.SHORT, (short)point.blockY());
                buffer.write(NetworkBuffer.VAR_INT, registry.blockEntityId());
                CompoundBinaryTag nbt = BlockUtils.extractClientNbt(block);
                assert (nbt != null);
                buffer.write(NetworkBuffer.NBT, nbt);
            }
        }

        @Override
        public ChunkData read(@NotNull NetworkBuffer buffer) {
            return new ChunkData(buffer.read(HEIGHTMAPS), buffer.read(NetworkBuffer.BYTE_ARRAY), ChunkData.readBlockEntities(buffer));
        }
    };

    public ChunkData(@NotNull Map<Heightmap.Type, long[]> heightmaps, byte[] data, @NotNull Map<Integer, Block> blockEntities) {
        heightmaps = Map.copyOf(heightmaps);
        blockEntities = blockEntities.entrySet().stream().filter(entry -> ((Block)entry.getValue()).registry().isBlockEntity()).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static Map<Integer, Block> readBlockEntities(@NotNull NetworkBuffer reader) {
        HashMap<Integer, Block> blockEntities = new HashMap<Integer, Block>();
        int size = reader.read(NetworkBuffer.VAR_INT);
        for (int i = 0; i < size; ++i) {
            byte xz = reader.read(NetworkBuffer.BYTE);
            short y = reader.read(NetworkBuffer.SHORT);
            int blockEntityId = reader.read(NetworkBuffer.VAR_INT);
            CompoundBinaryTag compoundBinaryTag = reader.read(NetworkBuffer.NBT_COMPOUND);
        }
        return blockEntities;
    }
}

