/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.listener;

import net.minestom.server.entity.GameMode;
import net.minestom.server.entity.Player;
import net.minestom.server.inventory.AbstractInventory;
import net.minestom.server.inventory.Inventory;
import net.minestom.server.item.ItemStack;
import net.minestom.server.network.packet.client.common.ClientPongPacket;
import net.minestom.server.network.packet.client.play.ClientClickWindowPacket;
import net.minestom.server.network.packet.client.play.ClientCloseWindowPacket;
import net.minestom.server.network.packet.server.common.PingPacket;
import net.minestom.server.network.packet.server.play.SetCursorItemPacket;

public class WindowListener {
    public static void clickWindowListener(ClientClickWindowPacket packet, Player player) {
        ItemStack cursorItem;
        AbstractInventory inventory;
        int windowId = packet.windowId();
        AbstractInventory abstractInventory = inventory = windowId == 0 ? player.getInventory() : player.getOpenInventory();
        if (inventory == null) {
            return;
        }
        short slot = packet.slot();
        byte button = packet.button();
        ClientClickWindowPacket.ClickType clickType = packet.clickType();
        boolean successful = false;
        if (slot == -1) {
            return;
        }
        if (clickType == ClientClickWindowPacket.ClickType.PICKUP) {
            if (button == 0) {
                successful = slot != -999 ? inventory.leftClick(player, slot) : inventory.drop(player, true, slot, button);
            } else if (button == 1) {
                successful = slot != -999 ? inventory.rightClick(player, slot) : inventory.drop(player, false, slot, button);
            }
        } else if (clickType == ClientClickWindowPacket.ClickType.QUICK_MOVE) {
            successful = inventory.shiftClick(player, slot);
        } else if (clickType == ClientClickWindowPacket.ClickType.SWAP) {
            if (slot < 0 || button < 0) {
                return;
            }
            successful = inventory.changeHeld(player, slot, button);
        } else if (clickType == ClientClickWindowPacket.ClickType.CLONE) {
            boolean bl = successful = player.getGameMode() == GameMode.CREATIVE;
            if (successful) {
                ItemStack cloneStack = inventory.getItemStack(slot);
                cloneStack = cloneStack.withAmount(cloneStack.maxStackSize());
                player.getInventory().setCursorItem(cloneStack, false);
            }
        } else if (clickType == ClientClickWindowPacket.ClickType.THROW) {
            successful = inventory.drop(player, false, slot, button);
        } else if (clickType == ClientClickWindowPacket.ClickType.QUICK_CRAFT) {
            successful = inventory.dragging(player, slot, button);
        } else if (clickType == ClientClickWindowPacket.ClickType.PICKUP_ALL) {
            successful = inventory.doubleClick(player, slot);
        }
        if (!successful) {
            player.getInventory().update();
            if (inventory instanceof Inventory) {
                inventory.update(player);
            }
        }
        if (!ItemStack.Hash.of(cursorItem = player.getInventory().getCursorItem()).equals(packet.clickedItem())) {
            player.sendPacket(new SetCursorItemPacket(cursorItem));
        }
        player.sendPacket(new PingPacket(0x40000000 | windowId << 16));
    }

    public static void pong(ClientPongPacket packet, Player player) {
    }

    public static void closeWindowListener(ClientCloseWindowPacket packet, Player player) {
        player.closeInventory(true);
    }
}

