/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item.component;

import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import net.minestom.server.codec.Codec;
import net.minestom.server.codec.StructCodec;
import net.minestom.server.gamedata.tags.Tag;
import net.minestom.server.item.component.ConsumeEffectType;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.NetworkBufferTemplate;
import net.minestom.server.potion.CustomPotionEffect;
import net.minestom.server.potion.PotionEffect;
import net.minestom.server.registry.ObjectSet;
import net.minestom.server.sound.SoundEvent;
import net.minestom.server.utils.Unit;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.NotNull;

public sealed interface ConsumeEffect {
    public static final NetworkBuffer.Type<ConsumeEffect> NETWORK_TYPE = ConsumeEffectType.NETWORK_TYPE.unionType(ConsumeEffect::networkType, ConsumeEffect::consumeEffectToType);
    public static final StructCodec<ConsumeEffect> CODEC = ConsumeEffectType.CODEC.unionType(ConsumeEffect::codec, ConsumeEffect::consumeEffectToType);

    private static NetworkBuffer.Type<ConsumeEffect> networkType(@NotNull ConsumeEffectType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case ConsumeEffectType.APPLY_EFFECTS -> ApplyEffects.NETWORK_TYPE;
            case ConsumeEffectType.REMOVE_EFFECTS -> RemoveEffects.NETWORK_TYPE;
            case ConsumeEffectType.CLEAR_ALL_EFFECTS -> ClearAllEffects.NETWORK_TYPE;
            case ConsumeEffectType.TELEPORT_RANDOMLY -> TeleportRandomly.NETWORK_TYPE;
            case ConsumeEffectType.PLAY_SOUND -> PlaySound.NETWORK_TYPE;
        };
    }

    private static StructCodec<ConsumeEffect> codec(@NotNull ConsumeEffectType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case ConsumeEffectType.APPLY_EFFECTS -> ApplyEffects.CODEC;
            case ConsumeEffectType.REMOVE_EFFECTS -> RemoveEffects.CODEC;
            case ConsumeEffectType.CLEAR_ALL_EFFECTS -> ClearAllEffects.CODEC;
            case ConsumeEffectType.TELEPORT_RANDOMLY -> TeleportRandomly.CODEC;
            case ConsumeEffectType.PLAY_SOUND -> PlaySound.CODEC;
        };
    }

    private static ConsumeEffectType consumeEffectToType(@NotNull ConsumeEffect consumeEffect) {
        ConsumeEffect consumeEffect2 = consumeEffect;
        Objects.requireNonNull(consumeEffect2);
        ConsumeEffect consumeEffect3 = consumeEffect2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ApplyEffects.class, RemoveEffects.class, ClearAllEffects.class, TeleportRandomly.class, PlaySound.class}, (Object)consumeEffect3, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                ApplyEffects ignored = (ApplyEffects)consumeEffect3;
                yield ConsumeEffectType.APPLY_EFFECTS;
            }
            case 1 -> {
                RemoveEffects ignored = (RemoveEffects)consumeEffect3;
                yield ConsumeEffectType.REMOVE_EFFECTS;
            }
            case 2 -> {
                ClearAllEffects ignored = (ClearAllEffects)consumeEffect3;
                yield ConsumeEffectType.CLEAR_ALL_EFFECTS;
            }
            case 3 -> {
                TeleportRandomly ignored = (TeleportRandomly)consumeEffect3;
                yield ConsumeEffectType.TELEPORT_RANDOMLY;
            }
            case 4 -> {
                PlaySound ignored = (PlaySound)consumeEffect3;
                yield ConsumeEffectType.PLAY_SOUND;
            }
        };
    }

    public record ApplyEffects(@NotNull List<CustomPotionEffect> effects, float probability) implements ConsumeEffect
    {
        private static final int MAX_EFFECTS = 256;
        public static final NetworkBuffer.Type<ApplyEffects> NETWORK_TYPE = NetworkBufferTemplate.template(CustomPotionEffect.NETWORK_TYPE.list(256), ApplyEffects::effects, NetworkBuffer.FLOAT, ApplyEffects::probability, ApplyEffects::new);
        public static final StructCodec<ApplyEffects> CODEC = StructCodec.struct("effects", CustomPotionEffect.CODEC.list(), ApplyEffects::effects, "probability", Codec.FLOAT.optional(Float.valueOf(1.0f)), ApplyEffects::probability, ApplyEffects::new);

        public ApplyEffects(@NotNull List<CustomPotionEffect> effects, float probability) {
            Check.argCondition(probability < 0.0f || probability > 1.0f, "Probability must be between 0 and 1");
            effects = List.copyOf(effects);
        }

        public ApplyEffects(@NotNull CustomPotionEffect effect, float probability) {
            this(List.of(effect), probability);
        }
    }

    public record RemoveEffects(@NotNull ObjectSet<PotionEffect> effects) implements ConsumeEffect
    {
        public static final NetworkBuffer.Type<RemoveEffects> NETWORK_TYPE = NetworkBufferTemplate.template(ObjectSet.networkType(Tag.BasicType.POTION_EFFECTS), RemoveEffects::effects, RemoveEffects::new);
        public static final StructCodec<RemoveEffects> CODEC = StructCodec.struct("effects", ObjectSet.codec(Tag.BasicType.POTION_EFFECTS), RemoveEffects::effects, RemoveEffects::new);
    }

    public static final class ClearAllEffects
    implements ConsumeEffect {
        public static final ClearAllEffects INSTANCE = new ClearAllEffects();
        public static final NetworkBuffer.Type<ClearAllEffects> NETWORK_TYPE = NetworkBuffer.UNIT.transform(buffer -> INSTANCE, ignored -> Unit.INSTANCE);
        public static final StructCodec<ClearAllEffects> CODEC = StructCodec.struct(() -> INSTANCE);

        private ClearAllEffects() {
        }
    }

    public record TeleportRandomly(float diameter) implements ConsumeEffect
    {
        public static final float DEFAULT_DIAMETER = 16.0f;
        public static final NetworkBuffer.Type<TeleportRandomly> NETWORK_TYPE = NetworkBufferTemplate.template(NetworkBuffer.FLOAT, TeleportRandomly::diameter, TeleportRandomly::new);
        public static final StructCodec<TeleportRandomly> CODEC = StructCodec.struct("diameter", Codec.FLOAT.optional(Float.valueOf(16.0f)), TeleportRandomly::diameter, TeleportRandomly::new);

        public TeleportRandomly() {
            this(16.0f);
        }
    }

    public record PlaySound(@NotNull SoundEvent sound) implements ConsumeEffect
    {
        public static final NetworkBuffer.Type<PlaySound> NETWORK_TYPE = NetworkBufferTemplate.template(SoundEvent.NETWORK_TYPE, PlaySound::sound, PlaySound::new);
        public static final StructCodec<PlaySound> CODEC = StructCodec.struct("sound", SoundEvent.CODEC, PlaySound::sound, PlaySound::new);
    }
}

