/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.gamedata.tags;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.kyori.adventure.key.Key;
import net.minestom.server.gamedata.tags.Tag;
import net.minestom.server.network.packet.server.common.TagsPacket;
import net.minestom.server.registry.Registries;
import net.minestom.server.registry.Registry;
import org.jetbrains.annotations.Nullable;

public final class TagManager {
    private final Map<Tag.BasicType, List<Tag>> tagMap = new ConcurrentHashMap<Tag.BasicType, List<Tag>>();

    public TagManager() {
        for (Tag.BasicType type : Tag.BasicType.values()) {
            if (type.getResource() == null || type.getFunction() == null) continue;
            Map<String, Map<String, Object>> json = Registry.load(type.getResource());
            List tagIdentifierMap = this.tagMap.computeIfAbsent(type, s -> new CopyOnWriteArrayList());
            json.keySet().forEach(tagName -> {
                Tag tag = new Tag(Key.key((String)tagName), this.getValues(json, (String)tagName));
                tagIdentifierMap.add(tag);
            });
        }
    }

    @Nullable
    public Tag getTag(Tag.BasicType type, String namespace) {
        List<Tag> tags = this.tagMap.get((Object)type);
        for (Tag tag : tags) {
            if (!tag.name().equals(namespace)) continue;
            return tag;
        }
        return null;
    }

    public Map<Tag.BasicType, List<Tag>> getTagMap() {
        return Collections.unmodifiableMap(this.tagMap);
    }

    public TagsPacket packet(Registries registries) {
        ArrayList<TagsPacket.Registry> registryList = new ArrayList<TagsPacket.Registry>();
        for (Map.Entry<Tag.BasicType, List<Tag>> entry : this.tagMap.entrySet()) {
            Tag.BasicType type = entry.getKey();
            String registry = type.getIdentifier();
            ArrayList<TagsPacket.Tag> tags = new ArrayList<TagsPacket.Tag>();
            for (Tag tag : entry.getValue()) {
                String identifier = tag.name();
                int[] values = tag.getValues().stream().mapToInt(value -> type.getFunction().apply(value.asString(), registries).orElse(null)).filter(Objects::nonNull).toArray();
                tags.add(new TagsPacket.Tag(identifier, values));
            }
            registryList.add(new TagsPacket.Registry(registry, tags));
        }
        return new TagsPacket(registryList);
    }

    private Set<Key> getValues(Map<String, Map<String, Object>> main, String value) {
        Map<String, Object> tagObject = main.get(value);
        List tagValues = (List)tagObject.get("values");
        HashSet<Key> result = new HashSet<Key>(tagValues.size());
        tagValues.forEach(tagString -> {
            if (tagString.startsWith("#")) {
                result.addAll(this.getValues(main, tagString.substring(1)));
            } else {
                result.add(Key.key((String)tagString));
            }
        });
        return result;
    }
}

