/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity;

import it.unimi.dsi.fastutil.longs.LongArrayPriorityQueue;
import it.unimi.dsi.fastutil.longs.LongPriorityQueue;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.audience.MessageType;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.identity.Identified;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.inventory.Book;
import net.kyori.adventure.key.Keyed;
import net.kyori.adventure.pointer.Pointers;
import net.kyori.adventure.resource.ResourcePackCallback;
import net.kyori.adventure.resource.ResourcePackInfo;
import net.kyori.adventure.resource.ResourcePackRequest;
import net.kyori.adventure.resource.ResourcePackStatus;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.sound.SoundStop;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.kyori.adventure.title.TitlePart;
import net.minestom.server.MinecraftServer;
import net.minestom.server.ServerFlag;
import net.minestom.server.advancements.AdvancementTab;
import net.minestom.server.advancements.Notification;
import net.minestom.server.adventure.AdventurePacketConvertor;
import net.minestom.server.adventure.audience.Audiences;
import net.minestom.server.collision.BoundingBox;
import net.minestom.server.command.CommandSender;
import net.minestom.server.coordinate.ChunkRange;
import net.minestom.server.coordinate.CoordConversion;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Pos;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.EntityPose;
import net.minestom.server.entity.EntityType;
import net.minestom.server.entity.EquipmentSlot;
import net.minestom.server.entity.ExperienceOrb;
import net.minestom.server.entity.GameMode;
import net.minestom.server.entity.LivingEntity;
import net.minestom.server.entity.PlayerHand;
import net.minestom.server.entity.PlayerSkin;
import net.minestom.server.entity.attribute.Attribute;
import net.minestom.server.entity.metadata.EntityMeta;
import net.minestom.server.entity.metadata.LivingEntityMeta;
import net.minestom.server.entity.metadata.PlayerMeta;
import net.minestom.server.entity.vehicle.PlayerInputs;
import net.minestom.server.event.EventDispatcher;
import net.minestom.server.event.inventory.InventoryCloseEvent;
import net.minestom.server.event.inventory.InventoryOpenEvent;
import net.minestom.server.event.item.ItemDropEvent;
import net.minestom.server.event.item.PickupExperienceEvent;
import net.minestom.server.event.item.PlayerFinishItemUseEvent;
import net.minestom.server.event.player.PlayerChunkLoadEvent;
import net.minestom.server.event.player.PlayerChunkUnloadEvent;
import net.minestom.server.event.player.PlayerDeathEvent;
import net.minestom.server.event.player.PlayerDisconnectEvent;
import net.minestom.server.event.player.PlayerGameModeChangeEvent;
import net.minestom.server.event.player.PlayerRespawnEvent;
import net.minestom.server.event.player.PlayerSkinInitEvent;
import net.minestom.server.event.player.PlayerSpawnEvent;
import net.minestom.server.event.player.PlayerStopFlyingWithElytraEvent;
import net.minestom.server.event.player.PlayerTickEvent;
import net.minestom.server.instance.Chunk;
import net.minestom.server.instance.EntityTracker;
import net.minestom.server.instance.Instance;
import net.minestom.server.instance.SharedInstance;
import net.minestom.server.instance.block.Block;
import net.minestom.server.inventory.AbstractInventory;
import net.minestom.server.inventory.Inventory;
import net.minestom.server.inventory.PlayerInventory;
import net.minestom.server.item.ItemComponent;
import net.minestom.server.item.ItemStack;
import net.minestom.server.item.Material;
import net.minestom.server.item.component.WrittenBookContent;
import net.minestom.server.listener.manager.PacketListenerManager;
import net.minestom.server.message.ChatPosition;
import net.minestom.server.message.Messenger;
import net.minestom.server.network.ConnectionManager;
import net.minestom.server.network.ConnectionState;
import net.minestom.server.network.packet.client.ClientPacket;
import net.minestom.server.network.packet.server.SendablePacket;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.common.PluginMessagePacket;
import net.minestom.server.network.packet.server.common.ResourcePackPopPacket;
import net.minestom.server.network.packet.server.common.ResourcePackPushPacket;
import net.minestom.server.network.packet.server.play.ActionBarPacket;
import net.minestom.server.network.packet.server.play.CameraPacket;
import net.minestom.server.network.packet.server.play.ChangeGameStatePacket;
import net.minestom.server.network.packet.server.play.ChunkBatchFinishedPacket;
import net.minestom.server.network.packet.server.play.ChunkBatchStartPacket;
import net.minestom.server.network.packet.server.play.ClearTitlesPacket;
import net.minestom.server.network.packet.server.play.DeathCombatEventPacket;
import net.minestom.server.network.packet.server.play.DestroyEntitiesPacket;
import net.minestom.server.network.packet.server.play.EntityHeadLookPacket;
import net.minestom.server.network.packet.server.play.FacePlayerPacket;
import net.minestom.server.network.packet.server.play.HeldItemChangePacket;
import net.minestom.server.network.packet.server.play.JoinGamePacket;
import net.minestom.server.network.packet.server.play.OpenBookPacket;
import net.minestom.server.network.packet.server.play.PlayerAbilitiesPacket;
import net.minestom.server.network.packet.server.play.PlayerInfoRemovePacket;
import net.minestom.server.network.packet.server.play.PlayerInfoUpdatePacket;
import net.minestom.server.network.packet.server.play.PlayerListHeaderAndFooterPacket;
import net.minestom.server.network.packet.server.play.PlayerPositionAndLookPacket;
import net.minestom.server.network.packet.server.play.RespawnPacket;
import net.minestom.server.network.packet.server.play.ServerDifficultyPacket;
import net.minestom.server.network.packet.server.play.SetExperiencePacket;
import net.minestom.server.network.packet.server.play.SetSlotPacket;
import net.minestom.server.network.packet.server.play.SpawnPositionPacket;
import net.minestom.server.network.packet.server.play.UnloadChunkPacket;
import net.minestom.server.network.packet.server.play.UpdateHealthPacket;
import net.minestom.server.network.packet.server.play.UpdateViewPositionPacket;
import net.minestom.server.network.packet.server.play.WorldEventPacket;
import net.minestom.server.network.packet.server.play.data.WorldPos;
import net.minestom.server.network.player.ClientSettings;
import net.minestom.server.network.player.GameProfile;
import net.minestom.server.network.player.PlayerConnection;
import net.minestom.server.recipe.RecipeManager;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.scoreboard.BelowNameTag;
import net.minestom.server.scoreboard.Team;
import net.minestom.server.snapshot.EntitySnapshot;
import net.minestom.server.snapshot.PlayerSnapshot;
import net.minestom.server.snapshot.SnapshotImpl;
import net.minestom.server.snapshot.SnapshotUpdater;
import net.minestom.server.statistic.PlayerStatistic;
import net.minestom.server.thread.Acquirable;
import net.minestom.server.timer.SchedulerManager;
import net.minestom.server.utils.MathUtils;
import net.minestom.server.utils.PacketSendingUtils;
import net.minestom.server.utils.async.AsyncUtils;
import net.minestom.server.utils.chunk.ChunkUpdateLimitChecker;
import net.minestom.server.utils.identity.NamedAndIdentified;
import net.minestom.server.utils.time.Cooldown;
import net.minestom.server.utils.time.TimeUnit;
import net.minestom.server.utils.validate.Check;
import net.minestom.server.world.DimensionType;
import net.minestom.server.worldevent.WorldEvent;
import org.jctools.queues.MpscArrayQueue;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Player
extends LivingEntity
implements CommandSender,
HoverEventSource<HoverEvent.ShowEntity>,
Identified,
NamedAndIdentified {
    private static final DynamicRegistry<DimensionType> DIMENSION_TYPE_REGISTRY = MinecraftServer.getDimensionTypeRegistry();
    private static final Component REMOVE_MESSAGE = Component.text((String)"You have been removed from the server without reason.", (TextColor)NamedTextColor.RED);
    private static final Component MISSING_REQUIRED_RESOURCE_PACK = Component.text((String)"Required resource pack was not loaded.", (TextColor)NamedTextColor.RED);
    private static final int DEFAULT_SEA_LEVEL = 63;
    private long lastKeepAlive;
    private boolean answerKeepAlive;
    private final GameProfile gameProfile;
    private String username;
    private Component usernameComponent;
    protected final PlayerConnection playerConnection;
    private volatile int latency;
    private Component displayName;
    private PlayerSkin skin;
    private Instance pendingInstance = null;
    private int dimensionTypeId;
    private GameMode gameMode;
    private WorldPos deathLocation;
    private Vec chunksLoadedByClient = Vec.ZERO;
    private final ReentrantLock chunkQueueLock = new ReentrantLock();
    private final LongPriorityQueue chunkQueue = new LongArrayPriorityQueue(this::compareChunkDistance);
    private boolean needsChunkPositionSync = true;
    private float targetChunksPerTick = 9.0f;
    private float pendingChunkCount = 0.0f;
    private int maxChunkBatchLead = 1;
    private int chunkBatchLead = 0;
    final ChunkRange.ChunkConsumer chunkAdder = (chunkX, chunkZ) -> this.instance.loadOptionalChunk(chunkX, chunkZ).thenAccept(this::sendChunk);
    final ChunkRange.ChunkConsumer chunkRemover = (chunkX, chunkZ) -> {
        this.sendPacket(new UnloadChunkPacket(chunkX, chunkZ));
        EventDispatcher.call(new PlayerChunkUnloadEvent(this, chunkX, chunkZ));
    };
    private final AtomicInteger teleportId = new AtomicInteger();
    private int receivedTeleportId;
    private final MpscArrayQueue<ClientPacket> packets = new MpscArrayQueue(ServerFlag.PLAYER_PACKET_QUEUE_SIZE);
    private final boolean levelFlat;
    private ClientSettings settings = ClientSettings.DEFAULT;
    private float exp;
    private int level;
    private int portalCooldown = 0;
    protected PlayerInventory inventory;
    private AbstractInventory openInventory;
    private boolean didCloseInventory;
    private byte heldSlot;
    private Pos respawnPoint;
    private int food;
    private float foodSaturation;
    private long startItemUseTime;
    private long itemUseTime;
    private PlayerHand itemUseHand;
    private boolean enableRespawnScreen;
    private final ChunkUpdateLimitChecker chunkUpdateLimitChecker = new ChunkUpdateLimitChecker(6);
    protected Cooldown experiencePickupCooldown = new Cooldown(Duration.of(10L, TimeUnit.SERVER_TICK));
    private BelowNameTag belowNameTag;
    private int permissionLevel;
    private boolean reducedDebugScreenInformation;
    private boolean hardcore;
    private boolean flying;
    private boolean allowFlying;
    private boolean instantBreak;
    private float flyingSpeed = 0.05f;
    private float fieldViewModifier = 0.1f;
    private final Map<PlayerStatistic, Integer> statisticValueMap = new Hashtable<PlayerStatistic, Integer>();
    private final PlayerInputs inputs = new PlayerInputs();
    private final Identity identity;
    private final Pointers pointers;
    private final Map<UUID, PendingResourcePack> pendingResourcePacks = new HashMap<UUID, PendingResourcePack>();
    private CompletableFuture<Void> resourcePackFuture = null;

    public Player(@NotNull PlayerConnection playerConnection, @NotNull GameProfile gameProfile) {
        super(EntityType.PLAYER, gameProfile.uuid());
        this.gameProfile = gameProfile;
        this.username = gameProfile.name();
        this.usernameComponent = Component.text((String)this.username);
        this.playerConnection = playerConnection;
        this.setRespawnPoint(Pos.ZERO);
        this.inventory = new PlayerInventory();
        this.setCanPickupItem(true);
        this.refreshAnswerKeepAlive(true);
        this.gameMode = GameMode.SURVIVAL;
        this.dimensionTypeId = DIMENSION_TYPE_REGISTRY.getId(DimensionType.OVERWORLD);
        this.levelFlat = true;
        this.getAttribute(Attribute.MOVEMENT_SPEED).setBaseValue(0.1);
        this.playerConnectionInit();
        this.identity = Identity.identity((UUID)gameProfile.uuid());
        this.pointers = (Pointers)Pointers.builder().withDynamic(Identity.UUID, this::getUuid).withDynamic(Identity.NAME, this::getUsername).withDynamic(Identity.DISPLAY_NAME, this::getDisplayName).build();
        this.metadata.setNotifyAboutChanges(false);
    }

    @ApiStatus.Internal
    public void setPendingOptions(@NotNull Instance pendingInstance, boolean hardcore) {
        this.pendingInstance = pendingInstance;
        this.hardcore = hardcore;
    }

    @ApiStatus.Internal
    public CompletableFuture<Void> UNSAFE_init() {
        Instance spawnInstance = this.pendingInstance;
        this.pendingInstance = null;
        this.removed = false;
        this.dimensionTypeId = DIMENSION_TYPE_REGISTRY.getId(spawnInstance.getDimensionType().namespace());
        JoinGamePacket joinGamePacket = new JoinGamePacket(this.getEntityId(), this.hardcore, List.of(), 0, ServerFlag.CHUNK_VIEW_DISTANCE, ServerFlag.CHUNK_VIEW_DISTANCE, false, true, false, this.dimensionTypeId, spawnInstance.getDimensionName(), 0L, this.gameMode, null, false, this.levelFlat, this.deathLocation, this.portalCooldown, 63, true);
        this.sendPacket(joinGamePacket);
        this.inventory.addViewer(this);
        this.sendPacket(new ServerDifficultyPacket(MinecraftServer.getDifficulty(), true));
        this.sendPacket(new SpawnPositionPacket(this.respawnPoint, 0.0f));
        this.metadata.setNotifyAboutChanges(true);
        this.sendPacket(this.getMetadataPacket());
        PlayerSkin profileSkin = null;
        for (GameProfile.Property property : this.gameProfile.properties()) {
            if (!property.name().equals("textures")) continue;
            profileSkin = new PlayerSkin(property.value(), property.signature());
            break;
        }
        PlayerSkinInitEvent skinInitEvent = new PlayerSkinInitEvent(this, profileSkin);
        EventDispatcher.call(skinInitEvent);
        this.skin = skinInitEvent.getSkin();
        PacketSendingUtils.broadcastPlayPacket(this.getAddPlayerToList());
        ConnectionManager connectionManager = MinecraftServer.getConnectionManager();
        for (Player player : connectionManager.getOnlinePlayers()) {
            if (player == this) continue;
            this.sendPacket(player.getAddPlayerToList());
            if (player.displayName == null) continue;
            this.sendPacket(new PlayerInfoUpdatePacket(PlayerInfoUpdatePacket.Action.UPDATE_DISPLAY_NAME, player.infoEntry()));
        }
        for (Team team : MinecraftServer.getTeamManager().getTeams()) {
            this.sendPacket(team.createTeamsCreationPacket());
        }
        this.refreshCommands();
        this.refreshRecipes();
        this.sendPacket(this.getPropertiesPacket());
        this.triggerStatus((byte)(24 + this.permissionLevel));
        this.refreshHealth();
        this.refreshAbilities();
        return this.setInstance(spawnInstance);
    }

    public void startConfigurationPhase() {
        Check.stateCondition(this.playerConnection.getConnectionState() != ConnectionState.PLAY, "Player must be in the play state for reconfiguration.");
        this.remove(false);
        MinecraftServer.getConnectionManager().transitionPlayToConfig(this);
    }

    protected void playerConnectionInit() {
        PlayerConnection connection = this.playerConnection;
        if (connection != null) {
            connection.setPlayer(this);
        }
    }

    @Override
    public void update(long time) {
        this.interpretPacketQueue();
        if (this.isRemoved()) {
            return;
        }
        this.sendPendingChunks();
        super.update(time);
        if (this.experiencePickupCooldown.isReady(time)) {
            this.experiencePickupCooldown.refreshLastUpdate(time);
            Pos loweredPosition = this.position.sub(0.0, 0.5, 0.0);
            this.instance.getEntityTracker().nearbyEntities(this.position, this.expandedBoundingBox.width(), EntityTracker.Target.EXPERIENCE_ORBS, experienceOrb -> {
                if (this.expandedBoundingBox.intersectEntity(loweredPosition, (Entity)experienceOrb)) {
                    PickupExperienceEvent pickupExperienceEvent = new PickupExperienceEvent(this, (ExperienceOrb)experienceOrb);
                    EventDispatcher.callCancellable(pickupExperienceEvent, () -> {
                        short experienceCount = pickupExperienceEvent.getExperienceCount();
                        experienceOrb.remove();
                    });
                }
            });
        }
        if (this.isUsingItem()) {
            PlayerHand itemUseHand = this.itemUseHand;
            if (this.itemUseTime > 0L && this.getCurrentItemUseTime() >= this.itemUseTime) {
                ItemStack itemStack = this.getItemInHand(itemUseHand);
                PlayerFinishItemUseEvent finishUseEvent = new PlayerFinishItemUseEvent(this, itemUseHand, itemStack, this.itemUseTime);
                EventDispatcher.call(finishUseEvent);
                this.triggerStatus((byte)9);
                boolean isOffHand = itemUseHand == PlayerHand.OFF;
                this.refreshActiveHand(false, isOffHand, finishUseEvent.isRiptideSpinAttack());
                this.clearItemUse();
                if (itemStack.equals(this.getItemInHand(itemUseHand))) {
                    int slot = isOffHand ? 45 : (int)this.getHeldSlot();
                    this.inventory.sendSlotRefresh(slot, itemStack, itemStack);
                }
            }
        }
        this.updatePose();
        EventDispatcher.call(new PlayerTickEvent(this));
    }

    @Override
    public void kill() {
        if (!this.isDead()) {
            Object deathText = this.lastDamage != null ? this.lastDamage.buildDeathScreenText(this) : Component.text((String)"Killed by poor programming.");
            Object chatMessage = this.lastDamage != null ? this.lastDamage.buildDeathMessage(this) : Component.text((String)(this.getUsername() + " was killed by poor programming."));
            PlayerDeathEvent playerDeathEvent = new PlayerDeathEvent(this, (Component)deathText, (Component)chatMessage);
            EventDispatcher.call(playerDeathEvent);
            deathText = playerDeathEvent.getDeathText();
            chatMessage = playerDeathEvent.getChatMessage();
            if (deathText != null) {
                this.sendPacket(new DeathCombatEventPacket(this.getEntityId(), (Component)deathText));
            }
            if (chatMessage != null) {
                Audiences.players().sendMessage(chatMessage);
            }
            if (this.getInstance() != null) {
                this.setDeathLocation(this.getInstance().getDimensionName(), this.getPosition());
            }
        }
        super.kill();
    }

    public void respawn() {
        if (!this.isDead()) {
            return;
        }
        this.setFireTicks(0);
        this.entityMeta.setOnFire(false);
        this.refreshHealth();
        this.sendPacket(new RespawnPacket(this.dimensionTypeId, this.instance.getDimensionName(), 0L, this.gameMode, this.gameMode, false, this.levelFlat, this.deathLocation, this.portalCooldown, 3, 63));
        this.refreshClientStateAfterRespawn();
        PlayerRespawnEvent respawnEvent = new PlayerRespawnEvent(this);
        EventDispatcher.call(respawnEvent);
        this.refreshIsDead(false);
        this.updatePose();
        Pos respawnPosition = respawnEvent.getRespawnPosition();
        ChunkRange.chunksInRange(respawnPosition, this.settings.effectiveViewDistance(), this.chunkAdder);
        this.chunksLoadedByClient = new Vec(respawnPosition.chunkX(), respawnPosition.chunkZ());
        this.instance.getEntityTracker().nearbyEntitiesByChunkRange(respawnPosition, this.settings.effectiveViewDistance(), EntityTracker.Target.ENTITIES, entity -> {
            if (!entity.getUuid().equals(this.getUuid()) && entity.isViewer(this)) {
                entity.updateNewViewer(this);
            }
        });
        this.teleport(respawnPosition).thenRun(this::refreshAfterTeleport);
    }

    private void refreshClientStateAfterRespawn() {
        this.sendPacket(new ChangeGameStatePacket(ChangeGameStatePacket.Reason.LEVEL_CHUNKS_LOAD_START, 0.0f));
        this.sendPacket(new ServerDifficultyPacket(MinecraftServer.getDifficulty(), false));
        this.sendPacket(new UpdateHealthPacket(this.getHealth(), this.food, this.foodSaturation));
        this.sendPacket(new SetExperiencePacket(this.exp, this.level, 0));
        this.triggerStatus((byte)(24 + this.permissionLevel));
        this.refreshAbilities();
    }

    public void refreshCommands() {
        this.sendPacket(MinecraftServer.getCommandManager().createDeclareCommandsPacket(this));
    }

    public void refreshRecipes() {
        RecipeManager recipeManager = MinecraftServer.getRecipeManager();
        this.sendPackets(recipeManager.getDeclareRecipesPacket(), recipeManager.createRecipeBookResetPacket(this));
    }

    @Override
    public boolean isOnGround() {
        return this.onGround;
    }

    @Override
    public void remove(boolean permanent) {
        if (this.isRemoved()) {
            return;
        }
        if (permanent) {
            this.packets.clear();
            EventDispatcher.call(new PlayerDisconnectEvent(this));
        }
        super.remove(permanent);
        AbstractInventory currentInventory = this.getOpenInventory();
        if (currentInventory != null) {
            currentInventory.removeViewer(this);
        }
        MinecraftServer.getBossBarManager().removeAllBossBars(this);
        Set<AdvancementTab> advancementTabs = AdvancementTab.getTabs(this);
        if (advancementTabs != null) {
            for (AdvancementTab advancementTab : advancementTabs) {
                advancementTab.removeViewer(this);
            }
        }
        Pos position = this.position;
        int chunkX = position.chunkX();
        int chunkZ = position.chunkZ();
        ChunkRange.chunksInRange(chunkX, chunkZ, this.settings.effectiveViewDistance(), this.chunkRemover);
        PacketSendingUtils.broadcastPlayPacket(this.getRemovePlayerToList());
        if (permanent && this.playerConnection.isOnline()) {
            this.kick(REMOVE_MESSAGE);
        }
    }

    @Override
    public void sendPacketToViewersAndSelf(@NotNull SendablePacket packet) {
        this.sendPacket(packet);
        super.sendPacketToViewersAndSelf(packet);
    }

    @Override
    public CompletableFuture<Void> setInstance(@NotNull Instance instance, @NotNull Pos spawnPosition) {
        Instance currentInstance = this.instance;
        Check.argCondition(currentInstance == instance, "Instance should be different than the current one");
        if (SharedInstance.areLinked(currentInstance, instance) && spawnPosition.sameChunk(this.position)) {
            this.spawnPlayer(instance, spawnPosition, false, false, false);
            return AsyncUtils.VOID_FUTURE;
        }
        this.chunkUpdateLimitChecker.clearHistory();
        boolean dimensionChange = currentInstance != null && !Objects.equals(currentInstance.getDimensionName(), instance.getDimensionName());
        Consumer<Instance> runnable = i -> this.spawnPlayer((Instance)i, spawnPosition, currentInstance == null, dimensionChange, true);
        this.needsChunkPositionSync = true;
        this.targetChunksPerTick = 9.0f;
        this.pendingChunkCount = 0.0f;
        ArrayList futures = new ArrayList();
        ChunkRange.chunksInRange(spawnPosition, this.settings.effectiveViewDistance(), (chunkX, chunkZ) -> {
            CompletableFuture<Chunk> future = instance.loadOptionalChunk(chunkX, chunkZ);
            if (!future.isDone()) {
                futures.add(future);
            }
        });
        if (futures.isEmpty()) {
            runnable.accept(instance);
            return AsyncUtils.VOID_FUTURE;
        }
        final Thread runThread = Thread.currentThread();
        final CountDownLatch latch = new CountDownLatch(1);
        final SchedulerManager scheduler = MinecraftServer.getSchedulerManager();
        CompletableFuture<Void> future = new CompletableFuture<Void>(this){

            @Override
            public Void join() {
                if (runThread == Thread.currentThread()) {
                    try {
                        latch.await();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    scheduler.process();
                    assert (this.isDone());
                }
                return (Void)super.join();
            }
        };
        CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new)).thenRun(() -> {
            scheduler.scheduleNextProcess(() -> {
                runnable.accept(instance);
                future.complete(null);
            });
            latch.countDown();
        });
        return future;
    }

    @Override
    public CompletableFuture<Void> setInstance(@NotNull Instance instance) {
        return this.setInstance(instance, this.instance != null ? this.getPosition() : this.getRespawnPoint());
    }

    private void spawnPlayer(@NotNull Instance instance, @NotNull Pos spawnPosition, boolean firstSpawn, boolean dimensionChange, boolean updateChunks) {
        if (!firstSpawn && !dimensionChange && updateChunks) {
            ChunkRange.chunksInRange(spawnPosition, this.settings.effectiveViewDistance(), this.chunkRemover);
        }
        if (dimensionChange) {
            this.sendDimension(instance.getDimensionType(), instance.getDimensionName());
        }
        super.setInstance(instance, spawnPosition);
        if (updateChunks) {
            int chunkX = spawnPosition.chunkX();
            int chunkZ = spawnPosition.chunkZ();
            this.chunksLoadedByClient = new Vec(chunkX, chunkZ);
            this.chunkUpdateLimitChecker.addToHistory(this.getChunk());
            this.sendPacket(new UpdateViewPositionPacket(chunkX, chunkZ));
            ChunkRange.chunksInRange(spawnPosition, this.settings.effectiveViewDistance(), this.chunkAdder);
            this.sendPendingChunks();
        }
        this.synchronizePositionAfterTeleport(spawnPosition, Vec.ZERO, 0, true);
        if (dimensionChange) {
            this.sendPacket(new SpawnPositionPacket(spawnPosition, 0.0f));
            this.sendPacket(instance.createInitializeWorldBorderPacket());
            this.sendPacket(instance.createTimePacket());
        }
        if (dimensionChange || firstSpawn) {
            this.inventory.update();
            this.sendPacket(new HeldItemChangePacket(this.heldSlot));
            this.sendPacket(new ChangeGameStatePacket(ChangeGameStatePacket.Reason.LEVEL_CHUNKS_LOAD_START, 0.0f));
        }
        EventDispatcher.call(new PlayerSpawnEvent(this, instance, firstSpawn));
    }

    @ApiStatus.Internal
    public void onChunkBatchReceived(float newTargetChunksPerTick) {
        --this.chunkBatchLead;
        float f = this.targetChunksPerTick = Float.isNaN(newTargetChunksPerTick) ? ServerFlag.MIN_CHUNKS_PER_TICK : MathUtils.clamp(newTargetChunksPerTick * ServerFlag.CHUNKS_PER_TICK_MULTIPLIER, ServerFlag.MIN_CHUNKS_PER_TICK, ServerFlag.MAX_CHUNKS_PER_TICK);
        if (this.maxChunkBatchLead == 1) {
            this.maxChunkBatchLead = 10;
        }
    }

    public void sendChunk(@NotNull Chunk chunk) {
        if (!chunk.isLoaded()) {
            return;
        }
        this.chunkQueueLock.lock();
        try {
            this.chunkQueue.enqueue(CoordConversion.chunkIndex(chunk.getChunkX(), chunk.getChunkZ()));
        }
        finally {
            this.chunkQueueLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPendingChunks() {
        if (this.chunkQueue.isEmpty() || this.chunkBatchLead >= this.maxChunkBatchLead) {
            return;
        }
        this.pendingChunkCount = Math.min(this.pendingChunkCount + this.targetChunksPerTick, ServerFlag.MAX_CHUNKS_PER_TICK);
        if (this.pendingChunkCount < 1.0f) {
            return;
        }
        this.chunkQueueLock.lock();
        try {
            int batchSize = 0;
            this.sendPacket(new ChunkBatchStartPacket());
            while (!this.chunkQueue.isEmpty() && this.pendingChunkCount >= 1.0f) {
                int chunkZ;
                long chunkIndex = this.chunkQueue.dequeueLong();
                int chunkX = CoordConversion.chunkIndexGetX(chunkIndex);
                Chunk chunk = this.instance.getChunk(chunkX, chunkZ = CoordConversion.chunkIndexGetZ(chunkIndex));
                if (chunk == null || !chunk.isLoaded()) continue;
                this.sendPacket(chunk.getFullDataPacket());
                EventDispatcher.call(new PlayerChunkLoadEvent(this, chunkX, chunkZ));
                this.pendingChunkCount -= 1.0f;
                ++batchSize;
            }
            this.sendPacket(new ChunkBatchFinishedPacket(batchSize));
            ++this.chunkBatchLead;
            if (this.needsChunkPositionSync) {
                this.synchronizePositionAfterTeleport(this.getPosition(), Vec.ZERO, 0, true);
                this.needsChunkPositionSync = false;
            }
        }
        finally {
            this.chunkQueueLock.unlock();
        }
    }

    @Override
    protected void updatePose() {
        LivingEntityMeta livingMeta;
        EntityPose oldPose = this.getPose();
        EntityMeta meta = this.getEntityMeta();
        EntityPose newPose = meta.isFlyingWithElytra() ? EntityPose.FALL_FLYING : (meta.isSwimming() ? EntityPose.SWIMMING : (meta instanceof LivingEntityMeta && (livingMeta = (LivingEntityMeta)meta).isInRiptideSpinAttack() ? EntityPose.SPIN_ATTACK : (this.isSneaking() && !this.isFlying() ? EntityPose.SNEAKING : EntityPose.STANDING)));
        if (!this.canFitWithBoundingBox(newPose)) {
            newPose = this.canFitWithBoundingBox(EntityPose.SNEAKING) ? EntityPose.SNEAKING : (this.canFitWithBoundingBox(EntityPose.SWIMMING) ? EntityPose.SWIMMING : EntityPose.STANDING);
        }
        if (newPose != oldPose) {
            this.setPose(newPose);
        }
    }

    private boolean canFitWithBoundingBox(@NotNull EntityPose pose) {
        BoundingBox bb;
        BoundingBox boundingBox = bb = pose == EntityPose.STANDING ? this.boundingBox : BoundingBox.fromPose(pose);
        if (bb == null) {
            return false;
        }
        Pos position = this.getPosition();
        BoundingBox.PointIterator iter = bb.getBlocks(this.getPosition());
        while (iter.hasNext()) {
            boolean hit;
            Block block;
            BoundingBox.MutablePoint pos = iter.next();
            try {
                block = this.instance.getBlock(pos.blockX(), pos.blockY(), pos.blockZ(), Block.Getter.Condition.TYPE);
            }
            catch (NullPointerException ignored) {
                block = null;
            }
            if (block == null || block.id() == Block.SCAFFOLDING.id() || !(hit = block.registry().collisionShape().intersectBox(position.sub(pos.blockX(), pos.blockY(), pos.blockZ()), bb))) continue;
            return false;
        }
        return true;
    }

    public void sendMessage(@NotNull Identity source, @NotNull Component message, @NotNull MessageType type) {
        Messenger.sendMessage(this, message, ChatPosition.fromMessageType(type), source.uuid());
    }

    public void sendPluginMessage(@NotNull String channel, byte @NotNull [] data) {
        this.sendPacket(new PluginMessagePacket(channel, data));
    }

    public void sendPluginMessage(@NotNull String channel, @NotNull String message) {
        this.sendPluginMessage(channel, message.getBytes(StandardCharsets.UTF_8));
    }

    public void playSound(@NotNull Sound sound) {
        this.playSound(sound, this.position.x(), this.position.y(), this.position.z());
    }

    public void playSound(@NotNull Sound sound, @NotNull Point point) {
        this.sendPacket(AdventurePacketConvertor.createSoundPacket(sound, point.x(), point.y(), point.z()));
    }

    public void playSound(@NotNull Sound sound, double x, double y, double z) {
        this.sendPacket(AdventurePacketConvertor.createSoundPacket(sound, x, y, z));
    }

    public void playSound(@NotNull Sound sound, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Sound.Emitter emitter) {
        ServerPacket packet = emitter == Sound.Emitter.self() ? AdventurePacketConvertor.createSoundPacket(sound, this) : AdventurePacketConvertor.createSoundPacket(sound, emitter);
        this.sendPacket(packet);
    }

    public void stopSound(@NotNull SoundStop stop) {
        this.sendPacket(AdventurePacketConvertor.createSoundStopPacket(stop));
    }

    public void playEffect(@NotNull WorldEvent worldEvent, int x, int y, int z, int data, boolean disableRelativeVolume) {
        this.sendPacket(new WorldEventPacket(worldEvent.id(), new Vec(x, y, z), data, disableRelativeVolume));
    }

    public void sendPlayerListHeaderAndFooter(@NotNull Component header, @NotNull Component footer) {
        this.sendPacket(new PlayerListHeaderAndFooterPacket(header, footer));
    }

    public <T> void sendTitlePart(@NotNull TitlePart<T> part, @NotNull T value) {
        this.sendPacket(AdventurePacketConvertor.createTitlePartPacket(part, value));
    }

    public void sendActionBar(@NotNull Component message) {
        this.sendPacket(new ActionBarPacket(message));
    }

    public void resetTitle() {
        this.sendPacket(new ClearTitlesPacket(true));
    }

    public void clearTitle() {
        this.sendPacket(new ClearTitlesPacket(false));
    }

    public void showBossBar(@NotNull BossBar bar) {
        MinecraftServer.getBossBarManager().addBossBar(this, bar);
    }

    public void hideBossBar(@NotNull BossBar bar) {
        MinecraftServer.getBossBarManager().removeBossBar(this, bar);
    }

    public void openBook(@NotNull Book book) {
        if (this.getOpenInventory() != null) {
            this.closeInventory();
        }
        String title = PlainTextComponentSerializer.plainText().serialize(book.title());
        String author = PlainTextComponentSerializer.plainText().serialize(book.author());
        ItemStack writtenBook = ItemStack.builder(Material.WRITTEN_BOOK).set(ItemComponent.WRITTEN_BOOK_CONTENT, new WrittenBookContent(title, author, 0, book.pages(), false)).build();
        this.sendPacket(new SetSlotPacket(0, 0, 45, writtenBook));
        this.sendPacket(new OpenBookPacket(PlayerHand.OFF));
        this.sendPacket(new SetSlotPacket(0, 0, 45, this.getItemInOffHand()));
    }

    @Override
    public void setHealth(float health) {
        this.sendPacket(new UpdateHealthPacket(health, this.food, this.foodSaturation));
        super.setHealth(health);
    }

    @NotNull
    public PlayerMeta getPlayerMeta() {
        return (PlayerMeta)super.getEntityMeta();
    }

    public float getAdditionalHearts() {
        return this.getPlayerMeta().getAdditionalHearts();
    }

    public void setAdditionalHearts(float additionalHearts) {
        this.getPlayerMeta().setAdditionalHearts(additionalHearts);
    }

    public int getFood() {
        return this.food;
    }

    public void setFood(int food) {
        Check.argCondition(!MathUtils.isBetween(food, 0, 20), "Food has to be between 0 and 20");
        this.food = food;
        this.sendPacket(new UpdateHealthPacket(this.getHealth(), food, this.foodSaturation));
    }

    public float getFoodSaturation() {
        return this.foodSaturation;
    }

    public void setFoodSaturation(float foodSaturation) {
        Check.argCondition(!MathUtils.isBetween(foodSaturation, 0.0f, 20.0f), "Food saturation has to be between 0 and 20");
        this.foodSaturation = foodSaturation;
        this.sendPacket(new UpdateHealthPacket(this.getHealth(), this.food, foodSaturation));
    }

    public boolean isEating() {
        if (!this.isUsingItem()) {
            return false;
        }
        ItemStack itemStack = this.getItemInHand(this.itemUseHand);
        return itemStack.has(ItemComponent.FOOD) || itemStack.material() == Material.POTION;
    }

    public boolean isUsingItem() {
        return this.itemUseHand != null;
    }

    @Nullable
    public PlayerHand getItemUseHand() {
        return this.itemUseHand;
    }

    public long getCurrentItemUseTime() {
        if (!this.isUsingItem()) {
            return 0L;
        }
        return this.getAliveTicks() - this.startItemUseTime;
    }

    @Override
    public double getEyeHeight() {
        return switch (this.getPose()) {
            case EntityPose.SLEEPING -> 0.2;
            case EntityPose.FALL_FLYING, EntityPose.SWIMMING, EntityPose.SPIN_ATTACK -> 0.4;
            case EntityPose.SNEAKING -> 1.27;
            default -> 1.62;
        };
    }

    @Nullable
    public Component getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(@Nullable Component displayName) {
        this.displayName = displayName;
        PacketSendingUtils.broadcastPlayPacket(new PlayerInfoUpdatePacket(PlayerInfoUpdatePacket.Action.UPDATE_DISPLAY_NAME, this.infoEntry()));
    }

    @Nullable
    public PlayerSkin getSkin() {
        return this.skin;
    }

    public synchronized void setSkin(@Nullable PlayerSkin skin) {
        this.skin = skin;
        if (this.instance == null) {
            return;
        }
        DestroyEntitiesPacket destroyEntitiesPacket = new DestroyEntitiesPacket(this.getEntityId());
        PlayerInfoRemovePacket removePlayerPacket = this.getRemovePlayerToList();
        PlayerInfoUpdatePacket addPlayerPacket = this.getAddPlayerToList();
        RespawnPacket respawnPacket = new RespawnPacket(this.dimensionTypeId, this.instance.getDimensionName(), 0L, this.gameMode, this.gameMode, false, this.levelFlat, this.deathLocation, this.portalCooldown, 3, 63);
        this.sendPacket(removePlayerPacket);
        this.sendPacket(destroyEntitiesPacket);
        this.sendPacket(addPlayerPacket);
        this.sendPacket(respawnPacket);
        this.refreshClientStateAfterRespawn();
        PacketSendingUtils.broadcastPlayPacket(removePlayerPacket);
        this.sendPacketToViewers(destroyEntitiesPacket);
        PacketSendingUtils.broadcastPlayPacket(addPlayerPacket);
        this.getViewers().forEach(player -> this.showPlayer(player.getPlayerConnection()));
        this.getInventory().update();
        this.teleport(this.getPosition());
    }

    public void setDeathLocation(@NotNull Pos position) {
        this.setDeathLocation(this.getInstance().getDimensionName(), position);
    }

    public void setDeathLocation(@NotNull String dimension, @NotNull Pos position) {
        this.deathLocation = new WorldPos(dimension, position);
    }

    @Nullable
    public WorldPos getDeathLocation() {
        return this.deathLocation;
    }

    public boolean isEnableRespawnScreen() {
        return this.enableRespawnScreen;
    }

    public void setEnableRespawnScreen(boolean enableRespawnScreen) {
        this.enableRespawnScreen = enableRespawnScreen;
        this.sendPacket(new ChangeGameStatePacket(ChangeGameStatePacket.Reason.ENABLE_RESPAWN_SCREEN, enableRespawnScreen ? 0.0f : 1.0f));
    }

    @Override
    @NotNull
    public Component getName() {
        return Objects.requireNonNullElse(this.displayName, this.usernameComponent);
    }

    @NotNull
    public String getUsername() {
        return this.username;
    }

    public boolean dropItem(@NotNull ItemStack item) {
        if (item.isAir()) {
            return false;
        }
        ItemDropEvent itemDropEvent = new ItemDropEvent(this, item);
        EventDispatcher.call(itemDropEvent);
        return !itemDropEvent.isCancelled();
    }

    public void sendResourcePacks(@NotNull ResourcePackRequest request) {
        if (request.replace()) {
            this.clearResourcePacks();
        }
        for (ResourcePackInfo pack : request.packs()) {
            this.sendPacket(new ResourcePackPushPacket(pack, request.required(), request.prompt()));
            this.pendingResourcePacks.put(pack.id(), new PendingResourcePack(request.required(), request.callback()));
            if (this.resourcePackFuture != null) continue;
            this.resourcePackFuture = new CompletableFuture();
        }
    }

    public void removeResourcePacks(@NotNull UUID id, UUID ... others) {
        this.sendPacket(new ResourcePackPopPacket(id));
        for (UUID other : others) {
            this.sendPacket(new ResourcePackPopPacket(other));
        }
    }

    public void clearResourcePacks() {
        this.sendPacket(new ResourcePackPopPacket(null));
    }

    @ApiStatus.Internal
    @Nullable
    public CompletableFuture<Void> getResourcePackFuture() {
        return this.resourcePackFuture;
    }

    @ApiStatus.Internal
    public void onResourcePackStatus(@NotNull UUID id, @NotNull ResourcePackStatus status) {
        PendingResourcePack pendingPack = this.pendingResourcePacks.get(id);
        if (pendingPack == null) {
            return;
        }
        pendingPack.callback().packEventReceived(id, status, (Audience)this);
        if (!status.intermediate()) {
            this.pendingResourcePacks.remove(id);
            if (pendingPack.required() && status != ResourcePackStatus.SUCCESSFULLY_LOADED) {
                this.kick(MISSING_REQUIRED_RESOURCE_PACK);
            }
            if (this.pendingResourcePacks.isEmpty() && this.resourcePackFuture != null) {
                this.resourcePackFuture.complete(null);
                this.resourcePackFuture = null;
            }
        }
    }

    public void facePosition(@NotNull FacePoint facePoint, @NotNull Point targetPosition) {
        this.facePosition(facePoint, targetPosition, null, null);
    }

    public void facePosition(@NotNull FacePoint facePoint, Entity entity, FacePoint targetPoint) {
        this.facePosition(facePoint, entity.getPosition(), entity, targetPoint);
    }

    private void facePosition(@NotNull FacePoint facePoint, @NotNull Point targetPosition, @Nullable Entity entity, @Nullable FacePoint targetPoint) {
        int entityId = entity != null ? entity.getEntityId() : 0;
        this.sendPacket(new FacePlayerPacket(facePoint == FacePoint.EYE ? FacePlayerPacket.FacePosition.EYES : FacePlayerPacket.FacePosition.FEET, targetPosition, entityId, targetPoint == FacePoint.EYE ? FacePlayerPacket.FacePosition.EYES : FacePlayerPacket.FacePosition.FEET));
    }

    public void spectate(@NotNull Entity entity) {
        this.sendPacket(new CameraPacket(entity.getEntityId()));
    }

    public void stopSpectating() {
        this.spectate(this);
    }

    @NotNull
    public Pos getRespawnPoint() {
        return this.respawnPoint;
    }

    public void setRespawnPoint(@NotNull Pos respawnPoint) {
        this.respawnPoint = respawnPoint;
    }

    protected void refreshAfterTeleport() {
        this.sendPacketsToViewers(this.getEntityType().registry().spawnType().getSpawnPacket(this));
        this.sendPacketToViewersAndSelf(this.getVelocityPacket());
        this.sendPacketToViewersAndSelf(this.getMetadataPacket());
        this.sendPacketToViewersAndSelf(this.getPropertiesPacket());
        this.sendPacketToViewersAndSelf(this.getEquipmentsPacket());
        this.getInventory().update();
    }

    protected void refreshHealth() {
        this.food = 20;
        this.foodSaturation = 5.0f;
        this.heal();
    }

    public float getExp() {
        return this.exp;
    }

    public void setExp(float exp) {
        Check.argCondition(!MathUtils.isBetween(exp, 0.0f, 1.0f), "Exp should be between 0 and 1");
        this.exp = exp;
        this.sendPacket(new SetExperiencePacket(exp, this.level, 0));
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
        this.sendPacket(new SetExperiencePacket(this.exp, level, 0));
    }

    public int getPortalCooldown() {
        return this.portalCooldown;
    }

    public void setPortalCooldown(int portalCooldown) {
        this.portalCooldown = portalCooldown;
    }

    @NotNull
    public PlayerConnection getPlayerConnection() {
        return this.playerConnection;
    }

    public void sendPacket(@NotNull SendablePacket packet) {
        this.playerConnection.sendPacket(packet);
    }

    public void sendPackets(SendablePacket ... packets) {
        this.playerConnection.sendPackets(packets);
    }

    public void sendPackets(@NotNull Collection<SendablePacket> packets) {
        this.playerConnection.sendPackets(packets);
    }

    public boolean isOnline() {
        return this.playerConnection.isOnline();
    }

    @NotNull
    public ClientSettings getSettings() {
        return this.settings;
    }

    public void refreshSettings(ClientSettings settings) {
        ClientSettings previous = this.settings;
        this.settings = settings;
        boolean isInPlayState = this.getPlayerConnection().getConnectionState() == ConnectionState.PLAY;
        PlayerMeta playerMeta = this.getPlayerMeta();
        if (isInPlayState) {
            playerMeta.setNotifyAboutChanges(false);
        }
        playerMeta.setDisplayedSkinParts(settings.displayedSkinParts());
        playerMeta.setRightMainHand(settings.mainHand() == ClientSettings.MainHand.RIGHT);
        if (isInPlayState) {
            playerMeta.setNotifyAboutChanges(true);
        }
        byte previousViewDistance = previous.viewDistance();
        byte newViewDistance = settings.viewDistance();
        if (this.instance != null) {
            if (previousViewDistance < newViewDistance) {
                ChunkRange.chunksInRange(this.position.chunkX(), this.position.chunkZ(), newViewDistance, (chunkX, chunkZ) -> {
                    if (Math.abs(chunkX - this.position.chunkX()) > previousViewDistance || Math.abs(chunkZ - this.position.chunkZ()) > previousViewDistance) {
                        this.chunkAdder.accept(chunkX, chunkZ);
                    }
                });
            } else if (previousViewDistance > newViewDistance) {
                ChunkRange.chunksInRange(this.position.chunkX(), this.position.chunkZ(), previousViewDistance, (chunkX, chunkZ) -> {
                    if (Math.abs(chunkX - this.position.chunkX()) > newViewDistance || Math.abs(chunkZ - this.position.chunkZ()) > newViewDistance) {
                        this.chunkRemover.accept(chunkX, chunkZ);
                    }
                });
            }
        }
    }

    public DimensionType getDimensionType() {
        return DIMENSION_TYPE_REGISTRY.get(this.dimensionTypeId);
    }

    @NotNull
    public PlayerInventory getInventory() {
        return this.inventory;
    }

    public int getLatency() {
        return this.latency;
    }

    public GameMode getGameMode() {
        return this.gameMode;
    }

    public boolean setGameMode(@NotNull GameMode gameMode) {
        PlayerGameModeChangeEvent playerGameModeChangeEvent = new PlayerGameModeChangeEvent(this, gameMode);
        EventDispatcher.call(playerGameModeChangeEvent);
        if (playerGameModeChangeEvent.isCancelled()) {
            return false;
        }
        this.gameMode = gameMode = playerGameModeChangeEvent.getNewGameMode();
        if (this.isActive()) {
            this.sendPacket(new ChangeGameStatePacket(ChangeGameStatePacket.Reason.CHANGE_GAMEMODE, gameMode.ordinal()));
            PacketSendingUtils.broadcastPlayPacket(new PlayerInfoUpdatePacket(PlayerInfoUpdatePacket.Action.UPDATE_GAME_MODE, this.infoEntry()));
        }
        this.allowFlying = gameMode.allowFlying();
        this.instantBreak = gameMode.instantBreak();
        this.invulnerable = gameMode.invulnerable();
        if (gameMode == GameMode.SPECTATOR || !gameMode.allowFlying()) {
            if (this.isActive()) {
                this.refreshFlying(gameMode.allowFlying());
            } else {
                this.flying = gameMode.allowFlying();
            }
        }
        if (this.isActive()) {
            this.refreshAbilities();
            this.updateCollisions();
        }
        return true;
    }

    protected void sendDimension(@NotNull DynamicRegistry.Key<DimensionType> dimensionType, @NotNull String dimensionName) {
        Check.argCondition(this.instance.getDimensionName().equals(dimensionName), "The dimension needs to be different than the current one!");
        this.dimensionTypeId = DIMENSION_TYPE_REGISTRY.getId(dimensionType);
        this.sendPacket(new RespawnPacket(this.dimensionTypeId, dimensionName, 0L, this.gameMode, this.gameMode, false, this.levelFlat, this.deathLocation, this.portalCooldown, 3, 63));
        this.refreshClientStateAfterRespawn();
    }

    public void kick(@NotNull Component component) {
        this.getPlayerConnection().kick(component);
    }

    public void kick(@NotNull String message) {
        this.kick((Component)Component.text((String)message));
    }

    public void setHeldItemSlot(byte slot) {
        Check.argCondition(!MathUtils.isBetween((int)slot, 0, 8), "Slot has to be between 0 and 8");
        this.refreshHeldSlot(slot);
        this.sendPacket(new HeldItemChangePacket(slot));
    }

    public byte getHeldSlot() {
        return this.heldSlot;
    }

    public void setBelowNameTag(BelowNameTag belowNameTag) {
        if (this.belowNameTag == belowNameTag) {
            return;
        }
        if (this.belowNameTag != null) {
            this.belowNameTag.removeViewer(this);
        }
        this.belowNameTag = belowNameTag;
    }

    @Nullable
    public AbstractInventory getOpenInventory() {
        return this.openInventory;
    }

    public boolean openInventory(@NotNull Inventory inventory) {
        InventoryOpenEvent inventoryOpenEvent = new InventoryOpenEvent(inventory, this);
        EventDispatcher.callCancellable(inventoryOpenEvent, () -> {
            AbstractInventory openInventory = this.getOpenInventory();
            if (openInventory != null) {
                openInventory.removeViewer(this);
            }
            AbstractInventory newInventory = inventoryOpenEvent.getInventory();
            newInventory.addViewer(this);
            this.openInventory = newInventory;
        });
        return !inventoryOpenEvent.isCancelled();
    }

    public void closeInventory() {
        this.closeInventory(false);
    }

    @ApiStatus.Internal
    public void closeInventory(boolean fromClient) {
        AbstractInventory openInventory = this.getOpenInventory();
        if (openInventory == null) {
            return;
        }
        InventoryCloseEvent inventoryCloseEvent = new InventoryCloseEvent(openInventory, this, fromClient);
        EventDispatcher.call(inventoryCloseEvent);
        if (!fromClient) {
            this.didCloseInventory = true;
        }
        this.openInventory = null;
        openInventory.removeViewer(this);
        this.inventory.update();
        this.didCloseInventory = false;
        Inventory newInventory = inventoryCloseEvent.getNewInventory();
        if (newInventory != null) {
            this.openInventory(newInventory);
        }
    }

    public boolean didCloseInventory() {
        return this.didCloseInventory;
    }

    @ApiStatus.Internal
    public void UNSAFE_changeDidCloseInventory(boolean didCloseInventory) {
        this.didCloseInventory = didCloseInventory;
    }

    public int getNextTeleportId() {
        return this.teleportId.incrementAndGet();
    }

    public int getLastSentTeleportId() {
        return this.teleportId.get();
    }

    public int getLastReceivedTeleportId() {
        return this.receivedTeleportId;
    }

    public void refreshReceivedTeleportId(int receivedTeleportId) {
        if (receivedTeleportId < 0) {
            return;
        }
        this.receivedTeleportId = receivedTeleportId;
    }

    @ApiStatus.Internal
    void synchronizePositionAfterTeleport(@NotNull Pos position, @NotNull Point velocity, int relativeFlags, boolean shouldConfirm) {
        int teleportId = shouldConfirm ? this.getNextTeleportId() : -1;
        this.sendPacket(new PlayerPositionAndLookPacket(teleportId, position, velocity, position.yaw(), position.pitch(), relativeFlags));
        super.synchronizePosition();
    }

    @Override
    public void setView(float yaw, float pitch) {
        this.teleport(new Pos(0.0, 0.0, 0.0, yaw, pitch), null, 7).join();
    }

    @Override
    public void lookAt(@NotNull Point point) {
        this.sendPacket(new FacePlayerPacket(FacePlayerPacket.FacePosition.EYES, point, 0, null));
    }

    @Override
    public void lookAt(@NotNull Entity entity) {
        this.sendPacket(new FacePlayerPacket(FacePlayerPacket.FacePosition.EYES, entity.getPosition(), entity.getEntityId(), FacePlayerPacket.FacePosition.EYES));
    }

    public int getPermissionLevel() {
        return this.permissionLevel;
    }

    public void setPermissionLevel(int permissionLevel) {
        Check.argCondition(!MathUtils.isBetween(permissionLevel, 0, 4), "permissionLevel has to be between 0 and 4");
        this.permissionLevel = permissionLevel;
        if (this.isActive()) {
            byte permissionLevelStatus = (byte)(24 + permissionLevel);
            this.triggerStatus(permissionLevelStatus);
        }
    }

    public void setReducedDebugScreenInformation(boolean reduced) {
        this.reducedDebugScreenInformation = reduced;
        byte debugScreenStatus = (byte)(reduced ? 22 : 23);
        this.triggerStatus(debugScreenStatus);
    }

    public boolean hasReducedDebugScreenInformation() {
        return this.reducedDebugScreenInformation;
    }

    @Override
    public void setInvulnerable(boolean invulnerable) {
        super.setInvulnerable(invulnerable);
        this.refreshAbilities();
    }

    @Override
    public void setSneaking(boolean sneaking) {
        if (this.isFlying()) {
            this.entityMeta.setSneaking(sneaking);
        } else {
            super.setSneaking(sneaking);
        }
    }

    public boolean isFlying() {
        return this.flying;
    }

    public void setFlying(boolean flying) {
        this.refreshFlying(flying);
        this.refreshAbilities();
    }

    public void refreshFlying(boolean flying) {
        if (this.flying != flying) {
            EntityPose pose = this.getPose();
            if (this.isSneaking() && pose == EntityPose.STANDING) {
                this.setPose(EntityPose.SNEAKING);
            } else if (pose == EntityPose.SNEAKING) {
                this.setPose(EntityPose.STANDING);
            }
        }
        this.flying = flying;
    }

    public boolean isAllowFlying() {
        return this.allowFlying;
    }

    public void setAllowFlying(boolean allowFlying) {
        this.allowFlying = allowFlying;
        this.refreshAbilities();
    }

    public boolean isInstantBreak() {
        return this.instantBreak;
    }

    public void setInstantBreak(boolean instantBreak) {
        this.instantBreak = instantBreak;
        this.refreshAbilities();
    }

    public float getFlyingSpeed() {
        return this.flyingSpeed;
    }

    public void setFlyingSpeed(float flyingSpeed) {
        this.flyingSpeed = flyingSpeed;
        this.refreshAbilities();
    }

    public float getFieldViewModifier() {
        return this.fieldViewModifier;
    }

    public void setFieldViewModifier(float fieldViewModifier) {
        this.fieldViewModifier = fieldViewModifier;
        this.refreshAbilities();
    }

    @NotNull
    public Map<PlayerStatistic, Integer> getStatisticValueMap() {
        return this.statisticValueMap;
    }

    @NotNull
    public PlayerInputs inputs() {
        return this.inputs;
    }

    protected void refreshAbilities() {
        byte flags = 0;
        if (this.invulnerable) {
            flags = (byte)(flags | 1);
        }
        if (this.flying) {
            flags = (byte)(flags | 2);
        }
        if (this.allowFlying) {
            flags = (byte)(flags | 4);
        }
        if (this.instantBreak) {
            flags = (byte)(flags | 8);
        }
        this.sendPacket(new PlayerAbilitiesPacket(flags, this.flyingSpeed, this.fieldViewModifier));
    }

    public void addPacketToQueue(@NotNull ClientPacket packet) {
        boolean success = this.packets.offer((Object)packet);
        if (!success) {
            this.kick((Component)Component.text((String)"Too Many Packets", (TextColor)NamedTextColor.RED));
        }
    }

    @ApiStatus.Internal
    public void interpretPacketQueue() {
        PacketListenerManager manager = MinecraftServer.getPacketListenerManager();
        this.packets.drain(packet -> manager.processClientPacket(packet, this.playerConnection, this.getPlayerConnection().getConnectionState()), ServerFlag.PLAYER_PACKET_PER_TICK);
    }

    public void refreshLatency(int latency) {
        this.latency = latency;
        if (this.getPlayerConnection().getConnectionState() == ConnectionState.PLAY) {
            PacketSendingUtils.broadcastPlayPacket(new PlayerInfoUpdatePacket(PlayerInfoUpdatePacket.Action.UPDATE_LATENCY, this.infoEntry()));
        }
    }

    public void refreshOnGround(boolean onGround) {
        this.onGround = onGround;
        if (this.onGround && this.isFlyingWithElytra()) {
            this.setFlyingWithElytra(false);
            EventDispatcher.call(new PlayerStopFlyingWithElytraEvent(this));
        }
    }

    public void refreshKeepAlive(long lastKeepAlive) {
        this.lastKeepAlive = lastKeepAlive;
        this.answerKeepAlive = false;
    }

    public boolean didAnswerKeepAlive() {
        return this.answerKeepAlive;
    }

    public void refreshAnswerKeepAlive(boolean answerKeepAlive) {
        this.answerKeepAlive = answerKeepAlive;
    }

    public void refreshHeldSlot(byte slot) {
        byte oldHeldSlot = this.heldSlot;
        this.heldSlot = slot;
        this.syncEquipment(EquipmentSlot.MAIN_HAND);
        this.updateEquipmentAttributes(this.inventory.getItemStack(oldHeldSlot), this.inventory.getItemStack(this.heldSlot), EquipmentSlot.MAIN_HAND);
    }

    public void refreshItemUse(@Nullable PlayerHand itemUseHand, long itemUseTimeTicks) {
        this.itemUseHand = itemUseHand;
        if (itemUseHand != null) {
            this.startItemUseTime = this.getAliveTicks();
            this.itemUseTime = itemUseTimeTicks;
        } else {
            this.startItemUseTime = 0L;
        }
    }

    public void clearItemUse() {
        this.refreshItemUse(null, 0L);
    }

    public void refreshInput(boolean forward, boolean backward, boolean left, boolean right, boolean jump, boolean shift, boolean sprint) {
        this.inputs.refresh(forward, backward, left, right, jump, shift, sprint);
    }

    public long getLastKeepAlive() {
        return this.lastKeepAlive;
    }

    @Override
    @NotNull
    public HoverEvent<HoverEvent.ShowEntity> asHoverEvent(@NotNull UnaryOperator<HoverEvent.ShowEntity> op) {
        return HoverEvent.showEntity((HoverEvent.ShowEntity)HoverEvent.ShowEntity.showEntity((Keyed)EntityType.PLAYER, (UUID)this.getUuid(), (Component)this.displayName));
    }

    @NotNull
    protected PlayerInfoUpdatePacket getAddPlayerToList() {
        return new PlayerInfoUpdatePacket(EnumSet.of(PlayerInfoUpdatePacket.Action.ADD_PLAYER, PlayerInfoUpdatePacket.Action.UPDATE_LISTED), List.of(this.infoEntry()));
    }

    @NotNull
    protected PlayerInfoRemovePacket getRemovePlayerToList() {
        return new PlayerInfoRemovePacket(this.getUuid());
    }

    private PlayerInfoUpdatePacket.Entry infoEntry() {
        PlayerSkin skin = this.skin;
        List<PlayerInfoUpdatePacket.Property> prop = skin != null ? List.of(new PlayerInfoUpdatePacket.Property("textures", skin.textures(), skin.signature())) : List.of();
        return new PlayerInfoUpdatePacket.Entry(this.getUuid(), this.getUsername(), prop, true, this.getLatency(), this.getGameMode(), this.displayName, null, 0);
    }

    protected void showPlayer(@NotNull PlayerConnection connection) {
        connection.sendPacket(this.getEntityType().registry().spawnType().getSpawnPacket(this));
        connection.sendPacket(this.getVelocityPacket());
        connection.sendPacket(this.getMetadataPacket());
        connection.sendPacket(this.getEquipmentsPacket());
        if (this.hasPassenger()) {
            connection.sendPacket(this.getPassengersPacket());
        }
        connection.sendPacket(new EntityHeadLookPacket(this.getEntityId(), this.position.yaw()));
    }

    @Override
    @NotNull
    public ItemStack getEquipment(@NotNull EquipmentSlot slot) {
        return this.inventory.getEquipment(slot, this.heldSlot);
    }

    @Override
    public void setEquipment(@NotNull EquipmentSlot slot, @NotNull ItemStack itemStack) {
        this.inventory.setEquipment(slot, this.heldSlot, itemStack);
    }

    @Override
    @NotNull
    public PlayerSnapshot updateSnapshot(@NotNull SnapshotUpdater updater) {
        EntitySnapshot snapshot = super.updateSnapshot(updater);
        return new SnapshotImpl.Player(snapshot, this.username, this.gameMode);
    }

    public Locale getLocale() {
        return this.settings.locale();
    }

    public void setLocale(@NotNull Locale locale) {
        ClientSettings settings = this.settings;
        this.refreshSettings(new ClientSettings(locale, settings.viewDistance(), settings.chatMessageType(), settings.chatColors(), settings.displayedSkinParts(), settings.mainHand(), settings.enableTextFiltering(), settings.allowServerListings(), settings.particleSetting()));
    }

    @NotNull
    public Identity identity() {
        return this.identity;
    }

    @NotNull
    public Pointers pointers() {
        return this.pointers;
    }

    @Override
    public boolean isPlayer() {
        return true;
    }

    @Override
    public Player asPlayer() {
        return this;
    }

    @Override
    protected void updateCollisions() {
        this.preventBlockPlacement = this.gameMode != GameMode.SPECTATOR;
        this.collidesWithEntities = this.gameMode != GameMode.SPECTATOR;
    }

    protected void sendChunkUpdates(Chunk newChunk) {
        if (this.chunkUpdateLimitChecker.addToHistory(newChunk)) {
            int newX = newChunk.getChunkX();
            int newZ = newChunk.getChunkZ();
            Vec old = this.chunksLoadedByClient;
            this.sendPacket(new UpdateViewPositionPacket(newX, newZ));
            ChunkRange.chunksInRangeDiffering(newX, newZ, (int)old.x(), (int)old.z(), this.settings.effectiveViewDistance(), this.chunkAdder, this.chunkRemover);
            this.chunksLoadedByClient = new Vec(newX, newZ);
        }
    }

    @Override
    @NotNull
    public CompletableFuture<Void> teleport(@NotNull Pos position, long @Nullable [] chunks, int flags) {
        this.chunkUpdateLimitChecker.clearHistory();
        return super.teleport(position, chunks, flags);
    }

    public void sendNotification(@NotNull Notification notification) {
        this.sendPacket(notification.buildAddPacket());
        this.sendPacket(notification.buildRemovePacket());
    }

    private int compareChunkDistance(long chunkIndexA, long chunkIndexB) {
        int chunkAX = CoordConversion.chunkIndexGetX(chunkIndexA);
        int chunkAZ = CoordConversion.chunkIndexGetZ(chunkIndexA);
        int chunkBX = CoordConversion.chunkIndexGetX(chunkIndexB);
        int chunkBZ = CoordConversion.chunkIndexGetZ(chunkIndexB);
        int chunkDistanceA = Math.abs(chunkAX - this.chunksLoadedByClient.blockX()) + Math.abs(chunkAZ - this.chunksLoadedByClient.blockZ());
        int chunkDistanceB = Math.abs(chunkBX - this.chunksLoadedByClient.blockX()) + Math.abs(chunkBZ - this.chunksLoadedByClient.blockZ());
        return Integer.compare(chunkDistanceA, chunkDistanceB);
    }

    @Override
    @ApiStatus.Experimental
    @NotNull
    public Acquirable<? extends Player> acquirable() {
        return super.acquirable();
    }

    record PendingResourcePack(boolean required, @NotNull ResourcePackCallback callback) {
    }

    public static enum FacePoint {
        FEET,
        EYE;

    }
}

