/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.world.biome;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Locale;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.minestom.server.color.Color;
import net.minestom.server.registry.Registry;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import net.minestom.server.world.biome.Biome;
import net.minestom.server.world.biome.BiomeEffects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class BiomeImpl
extends Record
implements Biome {
    private final float temperature;
    private final float downfall;
    @NotNull
    private final BiomeEffects effects;
    @NotNull
    private final Biome.Precipitation precipitation;
    @NotNull
    private final Biome.TemperatureModifier temperatureModifier;
    @Nullable
    private final Registry.BiomeEntry registry;
    private static final Double SNOW_TEMPERATURE = 0.15;
    static final BinaryTagSerializer<Biome> REGISTRY_NBT_TYPE = BinaryTagSerializer.COMPOUND.map(tag -> {
        throw new UnsupportedOperationException("Biome is read-only");
    }, biome -> {
        CompoundBinaryTag.Builder builder = (CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().putFloat("temperature", biome.temperature())).putFloat("downfall", biome.downfall())).putByte("has_precipitation", (byte)(biome.precipitation() != Biome.Precipitation.NONE ? 1 : 0))).putString("precipitation", biome.precipitation().name().toLowerCase(Locale.ROOT));
        if (biome.temperatureModifier() != Biome.TemperatureModifier.NONE) {
            builder.putString("temperature_modifier", biome.temperatureModifier().name().toLowerCase(Locale.ROOT));
        }
        return ((CompoundBinaryTag.Builder)builder.put("effects", BiomeEffects.NBT_TYPE.write(biome.effects()))).build();
    });

    BiomeImpl(Registry.BiomeEntry entry) {
        this(entry.temperature(), entry.downfall(), BiomeImpl.getBuilder(entry).build(), entry.hasPrecipitation() ? ((double)entry.temperature() < SNOW_TEMPERATURE ? Biome.Precipitation.SNOW : Biome.Precipitation.RAIN) : Biome.Precipitation.NONE, (double)entry.temperature() < SNOW_TEMPERATURE ? Biome.TemperatureModifier.FROZEN : Biome.TemperatureModifier.NONE, entry);
    }

    BiomeImpl(float temperature, float downfall, @NotNull BiomeEffects effects, @NotNull Biome.Precipitation precipitation, @NotNull Biome.TemperatureModifier temperatureModifier, @Nullable Registry.BiomeEntry registry) {
        this.temperature = temperature;
        this.downfall = downfall;
        this.effects = effects;
        this.precipitation = precipitation;
        this.temperatureModifier = temperatureModifier;
        this.registry = registry;
    }

    @NotNull
    private static BiomeEffects.Builder getBuilder(Registry.BiomeEntry entry) {
        BiomeEffects.Builder effectsBuilder = BiomeEffects.builder();
        if (entry.foliageColor() != null) {
            effectsBuilder.foliageColor(new Color(entry.foliageColor()));
        }
        if (entry.grassColor() != null) {
            effectsBuilder.grassColor(new Color(entry.grassColor()));
        }
        if (entry.skyColor() != null) {
            effectsBuilder.skyColor(new Color(entry.skyColor()));
        }
        if (entry.waterColor() != null) {
            effectsBuilder.waterColor(new Color(entry.waterColor()));
        }
        if (entry.waterFogColor() != null) {
            effectsBuilder.waterFogColor(new Color(entry.waterFogColor()));
        }
        if (entry.fogColor() != null) {
            effectsBuilder.fogColor(new Color(entry.fogColor()));
        }
        return effectsBuilder;
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{BiomeImpl.class, "temperature;downfall;effects;precipitation;temperatureModifier;registry", "temperature", "downfall", "effects", "precipitation", "temperatureModifier", "registry"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{BiomeImpl.class, "temperature;downfall;effects;precipitation;temperatureModifier;registry", "temperature", "downfall", "effects", "precipitation", "temperatureModifier", "registry"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{BiomeImpl.class, "temperature;downfall;effects;precipitation;temperatureModifier;registry", "temperature", "downfall", "effects", "precipitation", "temperatureModifier", "registry"}, this, o);
    }

    @Override
    public float temperature() {
        return this.temperature;
    }

    @Override
    public float downfall() {
        return this.downfall;
    }

    @Override
    @NotNull
    public BiomeEffects effects() {
        return this.effects;
    }

    @Override
    @NotNull
    public Biome.Precipitation precipitation() {
        return this.precipitation;
    }

    @Override
    @NotNull
    public Biome.TemperatureModifier temperatureModifier() {
        return this.temperatureModifier;
    }

    @Override
    @Nullable
    public Registry.BiomeEntry registry() {
        return this.registry;
    }
}

