/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.world.biome;

import net.minestom.server.color.Color;
import net.minestom.server.coordinate.Point;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.registry.ProtocolObject;
import net.minestom.server.registry.Registry;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import net.minestom.server.world.biome.BiomeEffects;
import net.minestom.server.world.biome.BiomeImpl;
import net.minestom.server.world.biome.Biomes;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface Biome
extends Biomes,
ProtocolObject
permits BiomeImpl {
    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    @ApiStatus.Internal
    @NotNull
    public static DynamicRegistry<Biome> createDefaultRegistry() {
        return DynamicRegistry.create("minecraft:worldgen/biome", BiomeImpl.REGISTRY_NBT_TYPE, Registry.Resource.BIOMES, (namespace, props) -> new BiomeImpl(Registry.biome(namespace, props)), (a, b) -> a.equals("minecraft:plains") ? -1 : (b.equals("minecraft:plains") ? 1 : 0));
    }

    public float temperature();

    public float downfall();

    @NotNull
    public BiomeEffects effects();

    @NotNull
    public Precipitation precipitation();

    @NotNull
    public TemperatureModifier temperatureModifier();

    @Override
    @Nullable
    public Registry.BiomeEntry registry();

    public static final class Builder {
        private static final BiomeEffects DEFAULT_EFFECTS = BiomeEffects.builder().fogColor(new Color(12638463)).skyColor(new Color(7907327)).waterColor(new Color(4159204)).waterFogColor(new Color(329011)).build();
        private float temperature = 0.25f;
        private float downfall = 0.8f;
        private BiomeEffects effects = DEFAULT_EFFECTS;
        private Precipitation precipitation = Precipitation.RAIN;
        private TemperatureModifier temperatureModifier = TemperatureModifier.NONE;

        private Builder() {
        }

        @Contract(value="_ -> this", pure=true)
        @NotNull
        public Builder temperature(float temperature) {
            this.temperature = temperature;
            return this;
        }

        @Contract(value="_ -> this", pure=true)
        @NotNull
        public Builder downfall(float downfall) {
            this.downfall = downfall;
            return this;
        }

        @Contract(value="_ -> this", pure=true)
        @NotNull
        public Builder effects(@NotNull BiomeEffects effects) {
            this.effects = effects;
            return this;
        }

        @Contract(value="_ -> this", pure=true)
        @NotNull
        public Builder precipitation(@NotNull Precipitation precipitation) {
            this.precipitation = precipitation;
            return this;
        }

        @Contract(value="_ -> this", pure=true)
        @NotNull
        public Builder temperatureModifier(@NotNull TemperatureModifier temperatureModifier) {
            this.temperatureModifier = temperatureModifier;
            return this;
        }

        @Contract(pure=true)
        @NotNull
        public Biome build() {
            return new BiomeImpl(this.temperature, this.downfall, this.effects, this.precipitation, this.temperatureModifier, null);
        }
    }

    public static interface Getter {
        @NotNull
        public DynamicRegistry.Key<Biome> getBiome(int var1, int var2, int var3);

        @NotNull
        default public DynamicRegistry.Key<Biome> getBiome(@NotNull Point point) {
            return this.getBiome(point.blockX(), point.blockY(), point.blockZ());
        }
    }

    public static interface Setter {
        public void setBiome(int var1, int var2, int var3, @NotNull DynamicRegistry.Key<Biome> var4);

        default public void setBiome(@NotNull Point blockPosition, @NotNull DynamicRegistry.Key<Biome> biome) {
            this.setBiome(blockPosition.blockX(), blockPosition.blockY(), blockPosition.blockZ(), biome);
        }
    }

    public static enum TemperatureModifier {
        NONE,
        FROZEN;

        public static final BinaryTagSerializer<TemperatureModifier> NBT_TYPE;

        static {
            NBT_TYPE = BinaryTagSerializer.fromEnumStringable(TemperatureModifier.class);
        }
    }

    public static enum Precipitation {
        NONE,
        RAIN,
        SNOW;

        public static final BinaryTagSerializer<Precipitation> NBT_TYPE;

        static {
            NBT_TYPE = BinaryTagSerializer.fromEnumStringable(Precipitation.class);
        }
    }
}

