/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.player;

import java.net.SocketAddress;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.Component;
import net.minestom.server.MinecraftServer;
import net.minestom.server.crypto.PlayerPublicKey;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.Player;
import net.minestom.server.event.EventDispatcher;
import net.minestom.server.event.player.PlayerDisconnectEvent;
import net.minestom.server.network.ConnectionState;
import net.minestom.server.network.packet.server.SendablePacket;
import net.minestom.server.network.packet.server.common.CookieRequestPacket;
import net.minestom.server.network.packet.server.common.CookieStorePacket;
import net.minestom.server.network.packet.server.common.DisconnectPacket;
import net.minestom.server.network.packet.server.configuration.SelectKnownPacksPacket;
import net.minestom.server.network.packet.server.login.LoginDisconnectPacket;
import net.minestom.server.network.plugin.LoginPluginMessageProcessor;
import net.minestom.server.utils.NamespaceID;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PlayerConnection {
    private Player player;
    private volatile ConnectionState connectionState;
    private PlayerPublicKey playerPublicKey;
    volatile boolean online = true;
    private LoginPluginMessageProcessor loginPluginMessageProcessor = new LoginPluginMessageProcessor(this);
    private CompletableFuture<List<SelectKnownPacksPacket.Entry>> knownPacksFuture = null;
    private final Map<NamespaceID, CompletableFuture<byte @Nullable []>> pendingCookieRequests = new ConcurrentHashMap<NamespaceID, CompletableFuture<byte[]>>();

    public PlayerConnection() {
        this.connectionState = ConnectionState.HANDSHAKE;
    }

    @NotNull
    public String getIdentifier() {
        Player player = this.getPlayer();
        return player != null ? player.getUsername() : this.getRemoteAddress().toString();
    }

    public abstract void sendPacket(@NotNull SendablePacket var1);

    public void sendPackets(@NotNull Collection<SendablePacket> packets) {
        packets.forEach(this::sendPacket);
    }

    public void sendPackets(SendablePacket ... packets) {
        this.sendPackets(List.of(packets));
    }

    @NotNull
    public abstract SocketAddress getRemoteAddress();

    public int getProtocolVersion() {
        return 769;
    }

    @Nullable
    public String getServerAddress() {
        return MinecraftServer.getServer().getAddress();
    }

    public int getServerPort() {
        return MinecraftServer.getServer().getPort();
    }

    public void kick(@NotNull Component component) {
        Record disconnectPacket = this.connectionState == ConnectionState.LOGIN ? new LoginDisconnectPacket(component) : new DisconnectPacket(component);
        this.sendPacket((SendablePacket)((Object)disconnectPacket));
        this.disconnect();
    }

    public void disconnect() {
        this.online = false;
        MinecraftServer.getConnectionManager().removePlayer(this);
        Player player = this.getPlayer();
        if (player != null) {
            if (this.connectionState == ConnectionState.PLAY && !player.isRemoved()) {
                player.scheduleNextTick(Entity::remove);
            } else {
                EventDispatcher.call(new PlayerDisconnectEvent(player));
            }
        }
    }

    @Nullable
    public Player getPlayer() {
        return this.player;
    }

    public void setPlayer(Player player) {
        this.player = player;
    }

    public boolean isOnline() {
        return this.online;
    }

    public void setConnectionState(@NotNull ConnectionState connectionState) {
        this.connectionState = connectionState;
        if (connectionState == ConnectionState.CONFIGURATION) {
            this.loginPluginMessageProcessor = null;
        }
    }

    @NotNull
    public ConnectionState getConnectionState() {
        return this.connectionState;
    }

    public PlayerPublicKey playerPublicKey() {
        return this.playerPublicKey;
    }

    public void setPlayerPublicKey(PlayerPublicKey playerPublicKey) {
        this.playerPublicKey = playerPublicKey;
    }

    public void storeCookie(@NotNull String key, byte @NotNull [] data) {
        this.sendPacket(new CookieStorePacket(key, data));
    }

    public CompletableFuture<byte @Nullable []> fetchCookie(@NotNull String key) {
        if (this.getConnectionState() == ConnectionState.CONFIGURATION && this.getPlayer() == null) {
            throw new IllegalStateException("Cannot fetch cookie in PlayerProvider, use AsyncPlayerPreLoginEvent or AsyncPlayerConfigurationEvent");
        }
        CompletableFuture<byte[]> future = new CompletableFuture<byte[]>();
        this.pendingCookieRequests.put(NamespaceID.from(key), future);
        this.sendPacket(new CookieRequestPacket(key));
        return future;
    }

    @ApiStatus.Internal
    public void receiveCookieResponse(@NotNull String key, byte @Nullable [] data) {
        CompletableFuture<byte[]> future = this.pendingCookieRequests.remove(NamespaceID.from(key));
        if (future != null) {
            future.complete(data);
        }
    }

    @ApiStatus.Internal
    @NotNull
    public LoginPluginMessageProcessor loginPluginMessageProcessor() {
        return Objects.requireNonNull(this.loginPluginMessageProcessor, "Login plugin message processor is only available during the login state.");
    }

    @ApiStatus.Internal
    @NotNull
    public CompletableFuture<List<SelectKnownPacksPacket.Entry>> requestKnownPacks(@NotNull List<SelectKnownPacksPacket.Entry> serverPacks) {
        Check.stateCondition(this.knownPacksFuture != null, "Known packs already pending");
        this.sendPacket(new SelectKnownPacksPacket(serverPacks));
        this.knownPacksFuture = new CompletableFuture<List<SelectKnownPacksPacket.Entry>>();
        return this.knownPacksFuture;
    }

    @ApiStatus.Internal
    public void receiveKnownPacksResponse(@NotNull List<SelectKnownPacksPacket.Entry> clientPacks) {
        CompletableFuture<List<SelectKnownPacksPacket.Entry>> future = this.knownPacksFuture;
        if (future != null) {
            future.complete(clientPacks);
            this.knownPacksFuture = null;
        }
    }

    public String toString() {
        return "PlayerConnection{connectionState=" + String.valueOf((Object)this.connectionState) + ", identifier=" + this.getIdentifier() + "}";
    }
}

